/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.bean.tc.FreqPeriodBean;
import kd.tmc.fbp.common.bean.tc.FreqPeriodListBean;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;

public class TradeBusinessHelper {
    private static final Log logger = LogFactory.getLog(TradeBusinessHelper.class);

    public static int callSettleDelayDay(DynamicObjectCollection workCalendars, Date bizDate, Date settleDate) {
        int workDay = 0;
        while (bizDate.before(settleDate)) {
            if (!WorkCalendarHelper.isWorkDay(workCalendars, bizDate = TcDateUtils.getNextDay(TcDateUtils.truncateDate(bizDate), 1))) continue;
            ++workDay;
        }
        return workDay;
    }

    public static Date callSettleDelayDate(DynamicObjectCollection workCalendars, Date date, int settleDelay) {
        Date settleDate = date;
        int internal = 1;
        if (settleDelay < 0) {
            internal = -1;
            settleDelay = -settleDelay;
        }
        for (int index = 0; index < settleDelay; ++index) {
            settleDate = TcDateUtils.getNextDay(TcDateUtils.truncateDate(settleDate), internal);
            while (!WorkCalendarHelper.isWorkDay(workCalendars, settleDate)) {
                settleDate = TcDateUtils.getNextDay(TcDateUtils.truncateDate(settleDate), internal);
            }
        }
        return settleDate;
    }

    public static Date callAdjustSettleDate(DynamicObjectCollection workCalendars, Date date, AdjustMethodEnum adjustMethod) {
        Date settleDate = date = TcDateUtils.truncateDate(date);
        switch (adjustMethod) {
            case forward: {
                while (!WorkCalendarHelper.isWorkDay(workCalendars, settleDate)) {
                    settleDate = TcDateUtils.getNextDay(settleDate, 1);
                }
                break;
            }
            case ad_forward: {
                while (!WorkCalendarHelper.isWorkDay(workCalendars, settleDate)) {
                    if (!TcDateUtils.isSameMonth(date, settleDate)) {
                        settleDate = TradeBusinessHelper.callAdjustSettleDate(workCalendars, date, AdjustMethodEnum.backward);
                        continue;
                    }
                    settleDate = TcDateUtils.getNextDay(settleDate, 1);
                }
                if (TcDateUtils.isSameMonth(date, settleDate)) break;
                settleDate = TradeBusinessHelper.callAdjustSettleDate(workCalendars, date, AdjustMethodEnum.backward);
                break;
            }
            case backward: {
                while (!WorkCalendarHelper.isWorkDay(workCalendars, settleDate)) {
                    settleDate = TcDateUtils.getLastDay(settleDate, 1);
                }
                break;
            }
            case ad_backward: {
                while (!WorkCalendarHelper.isWorkDay(workCalendars, settleDate)) {
                    if (!TcDateUtils.isSameMonth(date, settleDate)) {
                        settleDate = TradeBusinessHelper.callAdjustSettleDate(workCalendars, date, AdjustMethodEnum.forward);
                        continue;
                    }
                    settleDate = TcDateUtils.getLastDay(settleDate, 1);
                }
                if (TcDateUtils.isSameMonth(date, settleDate)) break;
                settleDate = TradeBusinessHelper.callAdjustSettleDate(workCalendars, date, AdjustMethodEnum.forward);
                break;
            }
        }
        return settleDate;
    }

    public static Date callAdjustSettleDateForCache(Map<Date, Boolean> workCalendars, Date date, AdjustMethodEnum adjustMethod) {
        Date settleDate = date = TcDateUtils.truncateDate(date);
        switch (adjustMethod) {
            case forward: {
                while (!TradeBusinessHelper.isWorkDay(workCalendars, settleDate)) {
                    settleDate = TcDateUtils.getNextDay(settleDate, 1);
                }
                break;
            }
            case ad_forward: {
                while (!TradeBusinessHelper.isWorkDay(workCalendars, settleDate)) {
                    if (!TcDateUtils.isSameMonth(date, settleDate)) {
                        settleDate = TradeBusinessHelper.callAdjustSettleDateForCache(workCalendars, date, AdjustMethodEnum.backward);
                        continue;
                    }
                    settleDate = TcDateUtils.getNextDay(settleDate, 1);
                }
                if (TcDateUtils.isSameMonth(date, settleDate)) break;
                settleDate = TradeBusinessHelper.callAdjustSettleDateForCache(workCalendars, date, AdjustMethodEnum.backward);
                break;
            }
            case backward: {
                while (!TradeBusinessHelper.isWorkDay(workCalendars, settleDate)) {
                    settleDate = TcDateUtils.getLastDay(settleDate, 1);
                }
                break;
            }
            case ad_backward: {
                while (!TradeBusinessHelper.isWorkDay(workCalendars, settleDate)) {
                    if (!TcDateUtils.isSameMonth(date, settleDate)) {
                        settleDate = TradeBusinessHelper.callAdjustSettleDateForCache(workCalendars, date, AdjustMethodEnum.forward);
                        continue;
                    }
                    settleDate = TcDateUtils.getLastDay(settleDate, 1);
                }
                if (TcDateUtils.isSameMonth(date, settleDate)) break;
                settleDate = TradeBusinessHelper.callAdjustSettleDateForCache(workCalendars, date, AdjustMethodEnum.forward);
                break;
            }
        }
        return settleDate;
    }

    public static boolean isWorkDay(Map<Date, Boolean> workCalendarMap, Date date) {
        Boolean isWorkDay = workCalendarMap.get(date);
        if (isWorkDay == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            isWorkDay = 7 != calendar.get(7) && 1 != calendar.get(7);
            workCalendarMap.put(date, isWorkDay);
        }
        return isWorkDay;
    }

    public static Date callDelayAdjustSettleDate(DynamicObjectCollection workCalendars, Date date, int settleDelay, AdjustMethodEnum adjustMethod) {
        Date settleDelayDate = TradeBusinessHelper.callSettleDelayDate(workCalendars, date, settleDelay);
        return TradeBusinessHelper.callAdjustSettleDate(workCalendars, settleDelayDate, adjustMethod);
    }

    public static BigDecimal getBaseBasis(Date startDate, Date endDate, BasisEnum basisEnum, DynamicObject[] workCalendars, List<Date> dateList, PayFrequeEnum freqEnum) {
        int betweenDays = 0;
        int days = 0;
        BigDecimal value = BigDecimal.ZERO;
        switch (basisEnum) {
            case Actual_actual: 
            case ISDA_Actual_365: {
                value = TradeBusinessHelper.getBaseBasis_Act0Act(startDate, endDate);
                break;
            }
            case SIA_30_360: 
            case Actual_360: 
            case BMA_30_360: 
            case ISDA_30_360: 
            case European_30_360: 
            case Actual_365: 
            case BUS_252: 
            case Japanese_Actual_365: {
                betweenDays = TradeBusinessHelper.getBasis_BetweenDay(startDate, endDate, basisEnum, workCalendars);
                days = TradeBusinessHelper.getBasis_YearDay(0, basisEnum);
                value = new BigDecimal(betweenDays).divide(new BigDecimal(days), 10, 4);
                break;
            }
            case ICMA_Actual_actual: {
                value = TradeBusinessHelper.getBaseBasis_ICMA_Actual_actual(startDate, endDate, freqEnum, null);
                break;
            }
        }
        return value;
    }

    public static BigDecimal getBaseBasis(Date startDate, Date endDate, BasisEnum basisEnum, DynamicObject[] workCalendars, List<Date> dateList, PayFrequeEnum freqEnum, FreqPeriodListBean freqPeriodResolver) {
        BigDecimal value = BigDecimal.ZERO;
        value = basisEnum == BasisEnum.ICMA_Actual_actual ? TradeBusinessHelper.getBaseBasis_ICMA_Actual_actual(startDate, endDate, freqEnum, freqPeriodResolver) : TradeBusinessHelper.getBaseBasis(startDate, endDate, basisEnum, workCalendars, dateList, freqEnum);
        return value;
    }

    private static BigDecimal getBaseBasis_ICMA_Actual_actual(Date startDate, Date endDate, PayFrequeEnum freqEnum, FreqPeriodListBean freqPeriodResolver) {
        if (freqPeriodResolver == null || freqEnum == null) {
            return TradeBusinessHelper.getBaseBasis_Act0Act(startDate, endDate);
        }
        BigDecimal value = BigDecimal.ZERO;
        List<FreqPeriodBean> periods = freqPeriodResolver.locatePeriod(startDate, endDate);
        BigDecimal h1 = BigDecimal.ONE.divide(BigDecimal.valueOf(freqEnum.getFreque()), 10, 4);
        if (periods.size() == 1) {
            FreqPeriodBean first = periods.get(0);
            BigDecimal firstDays = BigDecimal.valueOf(TcDateUtils.getDiffDays(startDate, endDate));
            int df = TcDateUtils.getDiffDays(freqPeriodResolver.getPeriodStartDate(first), freqPeriodResolver.getPeriodEndDate(first));
            BigDecimal firstFreqDays = BigDecimal.valueOf(df);
            value = h1.multiply(firstDays.divide(firstFreqDays, 10, 4)).setScale(10, 4);
            logger.info(String.format("startdate:%tF, enddate:%tF, period:%s, days:%s, freqdays:%s, 1/h=%s, result=%s", startDate, endDate, first, firstDays, firstFreqDays, h1, value));
        } else {
            FreqPeriodBean first = periods.get(0);
            BigDecimal firstDays = BigDecimal.valueOf(TcDateUtils.getDiffDays(startDate, first.getAdjEndDate()));
            int df = TcDateUtils.getDiffDays(freqPeriodResolver.getPeriodStartDate(first), freqPeriodResolver.getPeriodEndDate(first));
            BigDecimal firstFreqDays = BigDecimal.valueOf(df);
            FreqPeriodBean last = periods.get(periods.size() - 1);
            BigDecimal lastDays = BigDecimal.valueOf(TcDateUtils.getDiffDays(freqPeriodResolver.getPeriodStartDate(last), endDate));
            int ldf = TcDateUtils.getDiffDays(freqPeriodResolver.getPeriodStartDate(last), freqPeriodResolver.getPeriodEndDate(last));
            BigDecimal lastFreqDays = BigDecimal.valueOf(ldf);
            BigDecimal n = BigDecimal.valueOf(periods.size() - 2);
            value = h1.multiply(firstDays.divide(firstFreqDays, 10, 4).add(lastDays.divide(lastFreqDays, 10, 4)).add(n)).setScale(10, 4);
            logger.info(String.format("startdate:%tF, enddate:%tF, firstperiod:%s, firstdays:%s, firstfreqdays:%s, lastperiod:%s, lastdays:%s, lastfreqdays:%s, n=%s, 1/h=%s, result=%s", startDate, endDate, first, firstDays, firstFreqDays, last, lastDays, lastFreqDays, n, h1, value));
        }
        return value;
    }

    public static int getBasis_YearDay(int year, BasisEnum basisEnum) {
        int days = 0;
        switch (basisEnum) {
            case Actual_actual: 
            case ISDA_Actual_365: {
                if (TcDateUtils.isLeapYear(year)) {
                    days = 366;
                    break;
                }
                days = 365;
                break;
            }
            case SIA_30_360: 
            case Actual_360: 
            case BMA_30_360: 
            case ISDA_30_360: 
            case European_30_360: {
                days = 360;
                break;
            }
            case Actual_365: {
                days = 365;
                break;
            }
            case BUS_252: {
                days = 252;
                break;
            }
            case Japanese_Actual_365: {
                days = 365;
                break;
            }
            default: {
                days = 365;
            }
        }
        return days;
    }

    public static int getBasis_BetweenDay(Date startDate, Date endDate, BasisEnum basisEnum, DynamicObject[] workCalendars) {
        int N = 0;
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        start.set(11, 0);
        start.set(12, 0);
        start.set(13, 0);
        start.set(14, 0);
        int y1 = start.get(1);
        int m1 = start.get(2);
        int d1 = start.get(5);
        int maxDayStart = start.getActualMaximum(5);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        start.set(11, 0);
        start.set(12, 0);
        start.set(13, 0);
        start.set(14, 0);
        int y2 = end.get(1);
        int m2 = end.get(2);
        int d2 = end.get(5);
        int maxDayEnd = end.getActualMaximum(5);
        switch (basisEnum) {
            case Actual_actual: 
            case ISDA_Actual_365: 
            case ICMA_Actual_actual: {
                N = TcDateUtils.getDiffDays(start.getTime(), end.getTime());
                break;
            }
            case SIA_30_360: {
                if (m1 == 1 && d1 == maxDayStart && m2 == 1 && d2 == maxDayEnd) {
                    d2 = 30;
                }
                if (d1 == maxDayStart) {
                    d1 = 30;
                }
                if (d2 == 31 && d1 == 30) {
                    d2 = 30;
                }
                N = d2 - d1 + 30 * (m2 - m1) + 360 * (y2 - y1);
                break;
            }
            case BMA_30_360: {
                if (d1 == maxDayStart) {
                    d1 = 30;
                }
                if (d2 == 31 && d1 == 30) {
                    d2 = 30;
                }
                N = d2 - d1 + 30 * (m2 - m1) + 360 * (y2 - y1);
                break;
            }
            case ISDA_30_360: {
                if (d1 == 31) {
                    d1 = 30;
                }
                if (d2 == 31 && d1 == 30) {
                    d2 = 30;
                }
                N = d2 - d1 + 30 * (m2 - m1) + 360 * (y2 - y1);
                break;
            }
            case European_30_360: {
                if (d1 == 31) {
                    d1 = 30;
                }
                if (d2 == 31) {
                    d2 = 30;
                }
                N = d2 - d1 + 30 * (m2 - m1) + 360 * (y2 - y1);
                break;
            }
            case Actual_360: {
                N = TcDateUtils.getDiffDays(start.getTime(), end.getTime());
                break;
            }
            case Actual_365: {
                N = TcDateUtils.getDiffDays(start.getTime(), end.getTime());
                break;
            }
            case BUS_252: {
                ArrayList<Long> ids = new ArrayList<Long>();
                Long[] calendarIds = new Long[]{};
                if (workCalendars != null) {
                    for (DynamicObject wc : workCalendars) {
                        if (wc == null) continue;
                        ids.add(wc.getLong("fbasedataid_id"));
                    }
                }
                N = WorkCalendarHelper.getWorkDayCount(ids.toArray(calendarIds), start.getTime(), end.getTime());
                break;
            }
            case Japanese_Actual_365: {
                Calendar leap;
                N = TcDateUtils.getDiffDays(start.getTime(), end.getTime());
                if (TcDateUtils.isLeapYear(y1)) {
                    leap = Calendar.getInstance();
                    leap.setTime(startDate);
                    leap.set(1, y1);
                    leap.set(2, 1);
                    leap.set(5, 29);
                    if (!leap.getTime().before(startDate) && !leap.getTime().after(endDate)) {
                        --N;
                    }
                }
                if (!TcDateUtils.isLeapYear(y2)) break;
                leap = Calendar.getInstance();
                leap.setTime(endDate);
                leap.set(1, y2);
                leap.set(2, 1);
                leap.set(5, 29);
                if (leap.getTime().before(startDate) || leap.getTime().after(endDate)) break;
                --N;
                break;
            }
            default: {
                N = TcDateUtils.getDiffDays(start.getTime(), end.getTime());
            }
        }
        return N;
    }

    private static BigDecimal getBaseBasis_Act0Act(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        BigDecimal value = BigDecimal.ZERO;
        int startYear = start.get(1);
        int endYear = end.get(1);
        int tempBetweenDays = 0;
        int tempDays = 0;
        Calendar temp = Calendar.getInstance();
        Calendar forward = Calendar.getInstance();
        for (int i = startYear; i <= endYear; ++i) {
            if (i == startYear) {
                temp = start;
            } else {
                temp.set(1, i);
                temp.set(2, 0);
                temp.set(5, 1);
            }
            if (i == endYear) {
                forward = end;
            } else {
                forward.set(1, i + 1);
                forward.set(2, 0);
                forward.set(5, 1);
            }
            tempBetweenDays = TcDateUtils.getDiffDays(temp.getTime(), forward.getTime());
            tempDays = TcDateUtils.isLeapYear(i) ? 366 : 365;
            value = value.add(new BigDecimal(tempBetweenDays).divide(new BigDecimal(tempDays), 10, 4));
        }
        return value;
    }

    private static BigDecimal getBaseBasis_ICMA_Actual_actual(Date startDate, Date endDate, List<Date> dateList, PayFrequeEnum freqEnum) {
        if (EmptyUtil.isEmpty(dateList)) {
            return BigDecimal.valueOf(TcDateUtils.getDiffDays(startDate, endDate) / 365);
        }
        if (EmptyUtil.isNoEmpty(dateList) && dateList.size() == 2) {
            freqEnum = PayFrequeEnum.year;
        }
        Date end_forw = PayFrequeEnum.getLastDateByPayfreq(endDate, freqEnum);
        BigDecimal n = BigDecimal.ONE.divide(new BigDecimal(freqEnum.getFreque()), 10, 4);
        if (end_forw.compareTo(startDate) == 0) {
            return n;
        }
        if (endDate.compareTo(dateList.get(dateList.size() - 1)) == 0) {
            Date start_after = PayFrequeEnum.getNextDateByPayfreq(startDate, freqEnum);
            if (start_after.after(endDate)) {
                BigDecimal actDays = new BigDecimal(TcDateUtils.getDiffDays(startDate, endDate));
                BigDecimal freqDays = new BigDecimal(TcDateUtils.getDiffDays(startDate, start_after));
                return actDays.divide(freqDays, 10, 4).multiply(n);
            }
            return n.add(TradeBusinessHelper.getBaseBasis_ICMA_Actual_actual(start_after, endDate, dateList, freqEnum));
        }
        if (end_forw.before(startDate)) {
            BigDecimal actDays = new BigDecimal(TcDateUtils.getDiffDays(startDate, endDate));
            BigDecimal freqDays = new BigDecimal(TcDateUtils.getDiffDays(end_forw, endDate));
            return actDays.divide(freqDays, 10, 4).multiply(n);
        }
        return n.add(TradeBusinessHelper.getBaseBasis_ICMA_Actual_actual(startDate, end_forw, dateList, freqEnum));
    }

    public static void initWorkCalendar(IDataModel model, IFormView view, String currencyField, String workCalendarField) {
        String sSQL;
        DataSet ds;
        String protecttype;
        DynamicObjectCollection workCalendar = (DynamicObjectCollection)model.getValue(workCalendarField);
        DynamicObject currency = (DynamicObject)model.getValue(currencyField);
        if (EmptyUtil.isEmpty(workCalendar) && EmptyUtil.isNoEmpty(currency) && !EmptyUtil.isEmpty(protecttype = (String)view.getFormShowParameter().getCustomParam("protecttype")) && !(ds = DB.queryDataSet((String)"default", (DBRoute)DBRouteConst.TC, (String)(sSQL = "Select FBaseDataId From T_Tbd_Default def left join T_Tbd_Default_Entrys entry on def.FId = entry.FId left join T_Tbd_Default_SubEntrys sub on entry.FEntryId = sub.FEntryId left join T_Tbd_Default_Sub_wc wc on sub.FDetailId = wc.FDetailId Where FTradeTypeId = ? and FCurrencyId = ?"), (Object[])new Object[]{Long.valueOf(protecttype), currency.getLong("id")})).isEmpty()) {
            HashSet<Long> idSet = new HashSet<Long>();
            for (Row row : ds) {
                if (!EmptyUtil.isNoEmpty(row.getLong("FBaseDataId"))) continue;
                idSet.add(row.getLong("FBaseDataId"));
            }
            if (idSet.size() > 0) {
                model.setValue(workCalendarField, (Object)idSet.toArray());
            }
        }
    }

    public static void initMarketValue(IDataModel model, IFormView view, String marketField, String currencyField) {
        Row row;
        Iterator it;
        String sSQL;
        DataSet ds;
        String protecttype;
        DynamicObject currency = (DynamicObject)model.getValue(currencyField);
        if (EmptyUtil.isNoEmpty(currency) && !EmptyUtil.isEmpty(protecttype = (String)view.getFormShowParameter().getCustomParam("protecttype")) && !(ds = DB.queryDataSet((String)"default", (DBRoute)DBRouteConst.TC, (String)(sSQL = "Select FMarketId From T_Tbd_Default def left join T_Tbd_Default_Entrys entry on def.FId = entry.FId left join T_Tbd_Default_SubEntrys sub on entry.FEntryId = sub.FEntryId Where FTradeTypeId = ? and FCurrencyId = ?"), (Object[])new Object[]{Long.valueOf(protecttype), currency.getLong("id")})).isEmpty() && (it = ds.iterator()).hasNext() && EmptyUtil.isNoEmpty((row = (Row)it.next()).getLong("FMarketId"))) {
            model.setValue(marketField, (Object)row.getLong("FMarketId"));
        }
    }
}

