/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.log;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.fbp.common.log.PayLog;

public class PayLogger {
    private Class<?> clz;
    private static Log logger = LogFactory.getLog(PayLogger.class);

    public static PayLogger create(Class<?> clz) {
        PayLogger logger = new PayLogger();
        logger.clz = clz;
        return logger;
    }

    public void log(PayLog logInfo) {
        if (logInfo == null) {
            return;
        }
        try {
            String logJson = JSON.toJSONString((Object)logInfo);
            this.fillCallerInfo(logInfo);
            logger.info(logJson);
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"payTraceLogService", (String)"log", (Object[])new Object[]{logInfo.getLogType(), logJson});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void logBatch(List<? extends PayLog> logInfoList) {
        try {
            if (CollectionUtils.isEmpty(logInfoList)) {
                return;
            }
            this.fillCallerInfo(logInfoList);
            ArrayList<String> logInfoStrList = new ArrayList<String>(logInfoList.size());
            for (PayLog payLog : logInfoList) {
                logInfoStrList.add(JSON.toJSONString((Object)payLog));
            }
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"payTraceLogService", (String)"logBatch", (Object[])new Object[]{logInfoList.get(0).getLogType(), logInfoStrList});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void fillCallerInfo(PayLog logInfo) {
        this.fillCallerInfo(Collections.singletonList(logInfo));
    }

    private void fillCallerInfo(List<? extends PayLog> logInfoList) {
        String className = null;
        String method = null;
        int line = 0;
        try {
            Throwable throwable = new Throwable();
            StackTraceElement stackTraceElement = throwable.getStackTrace()[this.getStackNum(throwable)];
            className = stackTraceElement.getClassName();
            method = stackTraceElement.getMethodName();
            line = stackTraceElement.getLineNumber();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (PayLog payLog : logInfoList) {
            if (className != null) {
                payLog.setClassName(className);
            }
            if (method != null) {
                payLog.setMethod(method);
            }
            if (line == 0) continue;
            payLog.setLine(line);
        }
    }

    private int getStackNum(Throwable t) {
        int num = 1;
        try {
            for (int i = 0; i < t.getStackTrace().length; ++i) {
                StackTraceElement stackTrace = t.getStackTrace()[i];
                String clzName = stackTrace.getClassName();
                if (!this.clz.getName().equals(clzName)) continue;
                num = i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }
}

