/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.mock;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.lang.Lang;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.mock.DynamicObjectMock;
import kd.tmc.fbp.common.mock.DynamicObjectMockerHelper;

public class DynamicObjectMocker {
    private static final String DEFAULT_ENTITY = "Simple";
    private static final int INITIAL_CAPACITY = 10;
    private final List<Map<String, Object>> items = new ArrayList<Map<String, Object>>(10);
    private String entityNumber;

    public DynamicObjectMocker(String entityNumber) {
        this.entityNumber = StringUtils.isNotEmpty((String)entityNumber) ? entityNumber : DEFAULT_ENTITY;
    }

    public DynamicObjectMocker() {
        this.entityNumber = DEFAULT_ENTITY;
    }

    private Map<String, Object> getCurrent() {
        if (this.items.size() < 1) {
            this.items.add(new HashMap(10));
        }
        return this.items.get(this.items.size() - 1);
    }

    private Map<String, Object> getFirst() {
        if (this.items.size() < 1) {
            this.items.add(new HashMap(10));
        }
        return this.items.get(0);
    }

    public DynamicObjectMocker add(String key, Object obj) {
        this.getCurrent().put(key, obj);
        return this;
    }

    public DynamicObjectMocker insert() {
        this.items.add(new HashMap(10));
        return this;
    }

    public DynamicObjectMocker clone(int totalLength) {
        if (this.items != null && this.items.size() >= 1) {
            int index = 0;
            for (int i = this.items.size(); i < totalLength; ++i) {
                this.items.add(this.items.get(index++));
            }
        }
        return this;
    }

    private DynamicObjectType getType(Map<String, Object> map) {
        DynamicObjectType type = new DynamicObjectType(this.entityNumber);
        for (Map.Entry<String, Object> item : map.entrySet()) {
            String k = item.getKey();
            Object v = item.getValue();
            Class itemClass = v == null ? Object.class : v.getClass();
            DynamicProperty property = new DynamicProperty();
            this.setField(property, "_name", k);
            this.setField(property, "_propertyType", itemClass);
            this.setField(property, "_defaultValue", null);
            this.setField(property, "_isReadonly", Boolean.FALSE);
            this.setField(property, "_hasDefaultValue", Boolean.FALSE);
            type.addProperty(property);
        }
        type.setDisplayName(new LocaleString(Lang.zh_CN.toString(), this.entityNumber));
        type.setDBRouteKey("tmc");
        return type;
    }

    private void setField(Object obj, String fieldName, Object value) {
        Class<?> aClass = obj.getClass();
        try {
            Field field = aClass.getDeclaredField(fieldName);
            ReflectionUtils.makeAccessible((Field)field);
            field.set(obj, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DynamicObjectMock getObject() {
        return this.getDynamicObjectMock(this.getCurrent());
    }

    private DynamicObjectMock getDynamicObjectMock(Map<String, Object> map) {
        DynamicObjectMock object = new DynamicObjectMock(this.getType(map));
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            object.set(entry.getKey(), entry.getValue());
        }
        return object;
    }

    public DynamicObjectMock getObject(int pos) {
        if (pos < 0) {
            pos = 0;
        }
        if (pos >= this.items.size()) {
            pos = this.items.size() - 1;
        }
        return pos < 0 ? null : this.getDynamicObjectMock(this.items.get(pos));
    }

    public DynamicObjectCollection getCollection(DynamicObject parent) {
        DynamicObjectCollection collection = new DynamicObjectCollection(this.getType(this.getFirst()), (Object)parent);
        int len = this.items.size();
        for (int i = 0; i < len; ++i) {
            collection.add((Object)this.getObject(i));
        }
        return collection;
    }

    public DynamicObjectCollection getCollection() {
        return this.getCollection(null);
    }

    public DynamicObject[] getArray() {
        DynamicObjectCollection collection = this.getCollection();
        Object[] array = new DynamicObject[collection.size()];
        return (DynamicObject[])collection.toArray(array);
    }

    public DataSet getDataSet() {
        return this.items.size() < 1 ? null : DynamicObjectMockerHelper.mapToDataSet(this.items);
    }
}

