/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.model.interest;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntBillExtInfo
extends IntBillInfo {
    private List<IntBillDetailExtInfo> extDetails;
    private BigDecimal floatInt = BigDecimal.ZERO;
    private BigDecimal benchmarkInt = BigDecimal.ZERO;

    public List<IntBillDetailExtInfo> getExtDetails() {
        return this.extDetails;
    }

    public IntBillExtInfo setExtDetails(List<IntBillDetailExtInfo> details) {
        this.extDetails = details;
        return this;
    }

    public BigDecimal getFloatInt() {
        return this.floatInt;
    }

    public IntBillExtInfo setFloatInt(BigDecimal floatInt) {
        this.floatInt = floatInt;
        return this;
    }

    public BigDecimal getBenchmarkInt() {
        return this.benchmarkInt;
    }

    public IntBillExtInfo setBenchmarkInt(BigDecimal benchmarkInt) {
        this.benchmarkInt = benchmarkInt;
        return this;
    }

    public BigDecimal getTotalInt() {
        return this.benchmarkInt.add(this.floatInt);
    }

    public IntBillExtInfo() {
    }

    public IntBillExtInfo(IntBillInfo billInfo) {
        this.setBizDate(billInfo.getBizDate());
        this.setBeginDate(billInfo.getBeginDate());
        this.setEndDate(billInfo.getEndDate());
        this.setAmount(billInfo.getAmount());
        this.setSeq(billInfo.getSeq());
    }

    public static IntBillExtInfo clone(IntBillInfo billInfo) {
        IntBillExtInfo extInfo = new IntBillExtInfo(billInfo);
        List<IntBillDetailInfo> details = billInfo.getDetails();
        if (EmptyUtil.isEmpty(details)) {
            return extInfo;
        }
        extInfo.setDetails(details);
        extInfo.initExtDetails(details);
        return extInfo;
    }

    public void initExtDetails(List<IntBillDetailInfo> details) {
        ArrayList<IntBillDetailExtInfo> extDetailList = new ArrayList<IntBillDetailExtInfo>(details.size());
        details.forEach(d -> extDetailList.add(IntBillDetailExtInfo.build(d)));
        this.setExtDetails(extDetailList);
    }

    public BigDecimal calcIntYearRate(BigDecimal actIntAmount) {
        BigDecimal intRate = BigDecimal.ZERO;
        BigDecimal totalIntAmount = this.getTotalInt();
        if (EmptyUtil.isEmpty(this.extDetails) || EmptyUtil.isEmpty(totalIntAmount)) {
            return intRate;
        }
        BigDecimal radio = actIntAmount.divide(totalIntAmount, 10, RoundingMode.HALF_UP);
        IntBillDetailExtInfo extInfo = this.extDetails.get(0);
        if (this.extDetails.size() == 1 && radio.compareTo(BigDecimal.ONE) == 0) {
            return extInfo.getRate();
        }
        Map<BigDecimal, List<IntBillDetailExtInfo>> listMap = this.extDetails.stream().collect(Collectors.groupingBy(IntBillDetailInfo::getPrinciple));
        if (listMap.size() == 1) {
            BigDecimal intTotal = actIntAmount.multiply(new BigDecimal(extInfo.getBasisDay()));
            int days = this.extDetails.stream().mapToInt(IntBillDetailInfo::getDays).sum();
            return intTotal.divide(extInfo.getPrinciple().multiply(new BigDecimal(days)), 10, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        }
        for (IntBillDetailExtInfo extDetail : this.extDetails) {
            BigDecimal totalInt = extDetail.getTotalInt().multiply(radio);
            BigDecimal principle = new BigDecimal(extDetail.getDays()).multiply(extDetail.getPrinciple());
            if (principle.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal rate = totalInt.divide(principle, 10, RoundingMode.HALF_UP);
            intRate = intRate.add(rate);
        }
        return intRate.divide(new BigDecimal(this.extDetails.size()), 10, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(extInfo.getBasisDay())).multiply(new BigDecimal(100));
    }
}

