/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.mq;

import java.io.Serializable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.mq.TmcMQTypeEnum;

public class TmcMQParam
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(TmcMQParam.class);
    public static final String QUEUE_TMC_IFM_TRANS = "kd.tmc.ifm.trans";
    private String type;
    private Object param;

    public String getType() {
        return this.type;
    }

    public TmcMQParam setType(String type) {
        this.type = type;
        return this;
    }

    public Object getParam() {
        return this.param;
    }

    public TmcMQParam setParam(Object param) {
        this.param = param;
        return this;
    }

    public static TmcMQParam build(TmcMQTypeEnum type, Object param) {
        return new TmcMQParam().setType(type.getType()).setParam(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(String queue) {
        MessagePublisher pub = null;
        String message = SerializationUtils.toJsonString((Object)this);
        try {
            pub = MQFactory.get().createSimplePublisher(TmcAppEnum.TMC.getValue(), queue);
            pub.publish(message);
            logger.info("send mq message success, queue: {}, message: {}", (Object)queue, (Object)message);
            boolean bl = true;
            this.close(pub);
            return bl;
        }
        catch (Exception e) {
            try {
                logger.error(String.format("send mq message error, queue:%s, param:%s", queue, message), (Throwable)e);
                boolean bl = false;
                this.close(pub);
                return bl;
            }
            catch (Throwable throwable) {
                this.close(pub);
                throw throwable;
            }
        }
    }

    public void sendMessageInDbTranscation(String queue) {
        MessagePublisher pub = null;
        String message = SerializationUtils.toJsonString((Object)this);
        try {
            pub = MQFactory.get().createSimplePublisher("tmc", queue);
            pub.publishInDbTranscation(DBRouteConst.TMC.getRouteKey(), (Object)this);
            logger.info("send mq message success, queue: {}, message: {}", (Object)queue, (Object)message);
        }
        catch (Exception e) {
            logger.error(String.format("send mq message error, queue:%s, param:%s", queue, message), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"MQ\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a%s", (String)"TmcMQParam_0", (String)"tmc-fbp-common", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            this.close(pub);
        }
    }

    private void close(MessagePublisher pub) {
        try {
            if (pub != null) {
                pub.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

