/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.ofd;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.ofd.CompressHelper;
import kd.tmc.fbp.common.ofd.OfdReadUtil;
import kd.tmc.fbp.common.ofd.PdfUtils;
import kd.tmc.fbp.common.ofd.SvgUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.DEROctetString;
import org.dom4j.Element;

public class OfdConvertUtil {
    private static final Log LOGGER = LogFactory.getLog(OfdConvertUtil.class);

    public static byte[] convertToPdfNew(byte[] fileBytes) {
        try {
            Map<String, Object> svgMap = OfdConvertUtil.ofdToSvgMap(fileBytes, true, -1);
            String svgStr = (String)svgMap.get("svgStr");
            Map fontFamilyMap = (Map)svgMap.get("fontFamilyMap");
            return PdfUtils.convertToPdf(svgStr, fontFamilyMap);
        }
        catch (Exception e) {
            LOGGER.error("\u8f6c\u6362PDF\u51fa\u73b0\u9519\u8bef:" + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u6362PDF\u51fa\u73b0\u9519\u8bef:%s\u3002", (String)"OfdConvertUtil_0", (String)"tmc-fbp-common", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private static Map<String, Object> ofdToSvgMap(byte[] fileBytes, boolean pdfFlag, int pageNo) {
        Map<String, byte[]> ofdFileMap = CompressHelper.decompress(fileBytes);
        return OfdConvertUtil.readOfdDataToSvg(ofdFileMap, pdfFlag, pageNo);
    }

    public static String ofdToSvgStr(byte[] fileBytes, boolean pdfFlag, int pageNo) {
        Map<String, Object> svgMap = OfdConvertUtil.ofdToSvgMap(fileBytes, pdfFlag, pageNo);
        return (String)svgMap.get("svgStr");
    }

    private static Map<String, Object> readOfdDataToSvg(Map<String, byte[]> ofdFileMap, boolean pdfFlag, int pageNo) {
        String annotationPath;
        byte[] annotationBytes;
        byte[] ofdMainByte = ofdFileMap.get("OFD.xml");
        String docRootPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/DocRoot");
        String signaturesPath = null;
        try {
            signaturesPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/Signatures");
        }
        catch (Exception e) {
            LOGGER.info("\u7b7e\u7ae0\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        String docRootDirPath = OfdReadUtil.getLastDirPath(docRootPath).toString();
        byte[] documentByte = ofdFileMap.get(docRootPath);
        Element documentEle = OfdReadUtil.getElementByByte(documentByte);
        Element commonDataEle = documentEle.element("CommonData");
        String documentResPath = commonDataEle.elementText("DocumentRes");
        HashMap<String, Object> fontFamilyMap = new HashMap<String, Object>();
        Map<String, Object> multiMediaMap = OfdConvertUtil.getMultiMediaMap(ofdFileMap, docRootDirPath + documentResPath, fontFamilyMap);
        String publicResPath = commonDataEle.elementText("PublicRes");
        if (StringUtils.isEmpty((CharSequence)publicResPath)) {
            publicResPath = documentResPath;
        }
        OfdConvertUtil.getFontFamilyByPublicRes(ofdFileMap, docRootDirPath, publicResPath, fontFamilyMap);
        Element element = commonDataEle.element("PageArea");
        String firstPageArea = null;
        if (null != element) {
            firstPageArea = element.elementText("PhysicalBox");
        }
        float width = 210.0f;
        List tempEleList = commonDataEle.elements("TemplatePage");
        Map<String, Element> templateMap = OfdConvertUtil.getTempEleMap(tempEleList);
        Element pagesEle = documentEle.element("Pages");
        List pageEleList = pagesEle.elements("Page");
        Element annotationsEle = documentEle.element("Annotations");
        List annotationList = null;
        if (annotationsEle != null && (annotationBytes = ofdFileMap.get(annotationPath = docRootDirPath + annotationsEle.getText())) != null) {
            Element annotationEle = OfdReadUtil.getElementByByte(annotationBytes);
            annotationList = annotationEle.elements("Page");
        }
        float offsetY = 0.0f;
        StringBuilder contentBuffer = new StringBuilder();
        for (int i = 0; i < pageEleList.size(); ++i) {
            Element annotationEle;
            byte[] bytes;
            if (pageNo != -1 && pageNo != i) continue;
            Element pageEle = OfdReadUtil.getElementByPath(ofdFileMap, (Element)pageEleList.get(i), docRootDirPath);
            String tempId = OfdConvertUtil.getTempEleIdByPage(pageEle);
            Element tempElePath = templateMap.get(tempId);
            if (!tempEleList.isEmpty() && tempElePath == null) {
                tempElePath = (Element)tempEleList.get(i);
            }
            Element tempEle = null;
            if (tempElePath != null) {
                tempEle = OfdReadUtil.getElementByPath(ofdFileMap, tempElePath, docRootDirPath);
            }
            String signSvgString = null;
            if (i == 0 && !StringUtils.isEmpty((CharSequence)signaturesPath)) {
                signSvgString = OfdConvertUtil.getSignSvgString(ofdFileMap, signaturesPath, offsetY);
            }
            Map<String, Object> svgMap = SvgUtil.getPageSvg(tempEle, firstPageArea, fontFamilyMap, null, multiMediaMap, offsetY, i, signSvgString);
            StringBuilder svgBuffer = (StringBuilder)svgMap.get("svgBuffer");
            Map<String, Object> pageSvgMap = SvgUtil.getPageSvg(pageEle, firstPageArea, fontFamilyMap, svgBuffer, multiMediaMap, offsetY, i, signSvgString);
            if (svgMap.isEmpty()) {
                svgMap = pageSvgMap;
                svgBuffer = (StringBuilder)svgMap.get("svgBuffer");
                float offsetX = ((Float)svgMap.get("offsetX")).floatValue();
                if (offsetX > width) {
                    width = offsetX;
                }
            }
            if (annotationList != null && annotationList.size() > i && null != (bytes = ofdFileMap.get(docRootDirPath + "Annots/" + ((Element)annotationList.get(i)).element("FileLoc").getText())) && bytes.length > 0 && (annotationEle = OfdReadUtil.getElementByPath(ofdFileMap, docRootDirPath + "Annots/" + ((Element)annotationList.get(i)).element("FileLoc").getText())) != null) {
                SvgUtil.appendAnnotation(annotationEle, fontFamilyMap, svgBuffer, multiMediaMap, offsetY);
            }
            svgBuffer.append("</svg>");
            if (!pdfFlag) {
                offsetY = ((Float)svgMap.get("offsetY")).floatValue();
            }
            contentBuffer.append((CharSequence)svgBuffer);
        }
        StringBuilder pageBuffer = new StringBuilder("<svg ").append(" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ").append(" version=\"1.1\" ");
        pageBuffer.append("width=\"").append(width).append("mm\" height=\"").append(offsetY).append("mm\">");
        pageBuffer.append((CharSequence)contentBuffer);
        pageBuffer.append("</svg>");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("svgStr", pageBuffer.toString());
        map.put("svgWidth", Float.valueOf(width));
        map.put("svgHeight", Float.valueOf(offsetY));
        map.put("fontFamilyMap", fontFamilyMap);
        return map;
    }

    private static Map<String, Element> getTempEleMap(List<Element> tempEleList) {
        HashMap<String, Element> templateMap = new HashMap<String, Element>(tempEleList.size());
        for (Element templateEle : tempEleList) {
            templateMap.put(templateEle.attributeValue("ID"), templateEle);
        }
        return templateMap;
    }

    private static String getTempEleIdByPage(Element pageEle) {
        String tempEleId = null;
        Element templateEle = pageEle.element("Template");
        if (templateEle != null) {
            tempEleId = templateEle.attributeValue("TemplateID");
        }
        return tempEleId;
    }

    private static Map<String, Object> getFontFamilyByPublicRes(Map<String, byte[]> ofdFileMap, String docRootDirPath, String publicResPath, Map<String, Object> fontFamilyMap) {
        byte[] fileBytes;
        if (fontFamilyMap == null) {
            fontFamilyMap = new HashMap<String, Object>();
        }
        if ((fileBytes = ofdFileMap.get(docRootDirPath + publicResPath)) == null || fileBytes.length == 0) {
            return fontFamilyMap;
        }
        Element publicResEle = OfdReadUtil.getElementByByte(fileBytes);
        Element drawParamsEle = publicResEle.element("DrawParams");
        OfdConvertUtil.setDrawEle(drawParamsEle, fontFamilyMap);
        Element fontsEle = publicResEle.element("Fonts");
        if (fontsEle != null) {
            String baseLoc = publicResEle.attributeValue("BaseLoc");
            baseLoc = !StringUtils.isEmpty((CharSequence)baseLoc) ? baseLoc + "/" : "";
            List fontEleList = fontsEle.elements("Font");
            for (Element fontEle : fontEleList) {
                String fontFamilyName = fontEle.attributeValue("FamilyName");
                if (EmptyUtil.isEmpty(fontFamilyName)) {
                    fontFamilyName = fontEle.attributeValue("FontName");
                }
                String fontFamilyNameLow = fontFamilyName.toLowerCase(Locale.ROOT);
                boolean ofdFonts = true;
                if (fontFamilyNameLow.contains("kaiti") && !fontFamilyNameLow.contains("bold")) {
                    fontFamilyName = ResManager.loadKDString((String)"\u6977\u4f53, KaiTi, Kai, simkai", (String)"OfdConstants_2", (String)"tmc-fbp-common", (Object[])new Object[0]);
                    ofdFonts = false;
                }
                if (fontFamilyNameLow.contains("simsun") && !fontFamilyNameLow.contains("bold")) {
                    fontFamilyName = ResManager.loadKDString((String)"\u5b8b\u4f53, SimSun, simsun", (String)"OfdConstants_3", (String)"tmc-fbp-common", (Object[])new Object[0]);
                    ofdFonts = false;
                }
                if (EmptyUtil.isNoEmpty(fontFamilyName)) {
                    fontFamilyName = fontFamilyName.replace(ResManager.loadKDString((String)"\u6977\u4f53", (String)"OfdConstants_0", (String)"tmc-fbp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6977\u4f53, KaiTi, Kai, simkai", (String)"OfdConstants_2", (String)"tmc-fbp-common", (Object[])new Object[0]));
                    fontFamilyName = fontFamilyName.replace(ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"OfdConstants_1", (String)"tmc-fbp-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8b\u4f53, SimSun, simsun", (String)"OfdConstants_3", (String)"tmc-fbp-common", (Object[])new Object[0]));
                }
                String idStr = fontEle.attributeValue("ID");
                fontFamilyMap.put(idStr, fontFamilyName);
                if (!ofdFonts) continue;
                String fileName = fontEle.elementText("FontFile");
                String path = docRootDirPath + baseLoc + fileName;
                byte[] fontBytes = ofdFileMap.get(path);
                if (fontBytes == null) continue;
                fontFamilyMap.put(fontFamilyName, fontBytes);
                String[] fileNameArr = fileName.split("\\.");
                fontFamilyMap.put(fontFamilyName + "_name", fontFamilyName + "." + fileNameArr[fileNameArr.length - 1]);
            }
        }
        return fontFamilyMap;
    }

    private static void setDrawEle(Element drawParamsEle, Map<String, Object> map) {
        List drawEleList;
        if (drawParamsEle != null && (drawEleList = drawParamsEle.elements("DrawParam")) != null && !drawEleList.isEmpty()) {
            for (Element drawEle : drawEleList) {
                Element fillColorEle;
                if (drawEle == null) continue;
                String drawId = drawEle.attributeValue("ID");
                String lineWidth = drawEle.attributeValue("LineWidth");
                if (!StringUtils.isEmpty((CharSequence)lineWidth)) {
                    map.put("LINE_WIDTH_" + drawId, lineWidth);
                }
                if ((fillColorEle = drawEle.element("FillColor")) != null) {
                    OfdConvertUtil.setDrawParamsColor(drawEle, fillColorEle, map);
                    continue;
                }
                Element strokeColorEle = drawEle.element("StrokeColor");
                OfdConvertUtil.setDrawParamsColor(drawEle, strokeColorEle, map);
            }
        }
    }

    private static void setDrawParamsColor(Element drawEle, Element colorEle, Map<String, Object> map) {
        String fillColor;
        if (colorEle != null && EmptyUtil.isNoEmpty(fillColor = colorEle.attributeValue("Value"))) {
            String colorId = drawEle.attributeValue("ID");
            map.put("LINE_COLOR_" + colorId, fillColor);
        }
    }

    private static Map<String, Object> getMultiMediaMap(Map<String, byte[]> ofdFileMap, String documentResPath, Map<String, Object> fontFamilyMap) {
        HashMap<String, Object> multiMediaMap = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)documentResPath) && !documentResPath.endsWith("null")) {
            byte[] docResByte = ofdFileMap.get(documentResPath);
            Element docResEle = OfdReadUtil.getElementByByte(docResByte);
            String baseLoc = docResEle.attributeValue("BaseLoc");
            baseLoc = !StringUtils.isEmpty((CharSequence)baseLoc) ? baseLoc + "/" : "";
            List multiMediasEles = docResEle.elements("MultiMedias");
            if (multiMediasEles != null && !multiMediasEles.isEmpty()) {
                for (Element multiMediasEle : multiMediasEles) {
                    List multiMediaList = multiMediasEle.elements("MultiMedia");
                    if (multiMediaList == null || multiMediaList.isEmpty()) continue;
                    String documentResDirPath = OfdReadUtil.getLastDirPath(documentResPath).append(baseLoc).toString();
                    OfdConvertUtil.setMultiMediaMap(multiMediaMap, multiMediaList, documentResDirPath, ofdFileMap);
                }
            }
            Element drawParamsEle = docResEle.element("DrawParams");
            OfdConvertUtil.setDrawEle(drawParamsEle, fontFamilyMap);
        }
        return multiMediaMap;
    }

    private static void setMultiMediaMap(Map<String, Object> multiMediaMap, List<Element> multiMediaList, String documentResPath, Map<String, byte[]> ofdFileMap) {
        for (Element multiMediaEle : multiMediaList) {
            String fileName = multiMediaEle.elementText("MediaFile");
            String idStr = multiMediaEle.attributeValue("ID");
            multiMediaMap.put(idStr, fileName);
            multiMediaMap.put(idStr + "_BYTE", ofdFileMap.get(documentResPath + fileName));
        }
    }

    private static String getSignSvgString(Map<String, byte[]> ofdFileMap, String signaturesPath, float offsetY) {
        try {
            String signPic = null;
            Element signaturesEle = OfdReadUtil.getElementByPath(ofdFileMap, signaturesPath);
            Element signaturePathEle = signaturesEle.element("Signature");
            String signaturePath = signaturePathEle.attributeValue("BaseLoc");
            signaturePath = OfdReadUtil.getDirPath(signaturePath, signaturesPath);
            Element signatureEle = OfdReadUtil.getElementByPath(ofdFileMap, signaturePath);
            Element signedInfoEle = signatureEle.element("SignedInfo");
            Element stampAnnotEle = signedInfoEle.element("StampAnnot");
            if (stampAnnotEle != null) {
                String signBoundary = stampAnnotEle.attributeValue("Boundary");
                String signedValuePath = signatureEle.elementText("SignedValue");
                signedValuePath = OfdReadUtil.getDirPath(signedValuePath, signaturePath);
                byte[] signedValueByte = OfdReadUtil.getByteByPath(ofdFileMap, signedValuePath);
                signPic = OfdConvertUtil.getSignPic(signedValueByte, signBoundary, offsetY);
            }
            return signPic;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7b7e\u7ae0\u56fe\u7247\u51fa\u73b0\u9519\u8bef:" + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7b7e\u7ae0\u56fe\u7247\u51fa\u73b0\u9519\u8bef:%s\u3002", (String)"OfdConvertUtil_1", (String)"tmc-fbp-common", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private static String getSignPic(byte[] signFileByte, String signBoundary, float offsetY) throws IOException {
        String contentStr;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(signFileByte);
        ASN1StreamParser asn1StreamParser = new ASN1StreamParser((InputStream)inputStream);
        ASN1Encodable asn1Encodable = asn1StreamParser.readObject();
        ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Encodable.toASN1Primitive();
        if (!(asn1Sequence.getObjectAt(0) instanceof ASN1Sequence)) {
            return null;
        }
        ASN1Sequence asn1Sequence0 = (ASN1Sequence)asn1Sequence.getObjectAt(0);
        ASN1Sequence asnSealSequence = (ASN1Sequence)asn1Sequence0.getObjectAt(1);
        ASN1Sequence sealPicSeq = (ASN1Sequence)((ASN1Sequence)asnSealSequence.getObjectAt(0)).getObjectAt(3);
        String picType = sealPicSeq.getObjectAt(0).toString();
        byte[] picBytes = ((DEROctetString)sealPicSeq.getObjectAt(1)).getOctets();
        if ("ofd".equals(picType)) {
            contentStr = OfdConvertUtil.getSignOfdBuffer(picBytes, signBoundary);
        } else {
            picBytes = OfdConvertUtil.imageToPng(picBytes);
            contentStr = OfdConvertUtil.getSignPicBuffer(picBytes, signBoundary, offsetY);
        }
        return contentStr;
    }

    public static byte[] imageToPng(byte[] picBytes) throws IOException {
        BufferedImage input = ImageIO.read(new ByteArrayInputStream(picBytes));
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)input, "PNG", outputStream);
            picBytes = outputStream.toByteArray();
        }
        return picBytes;
    }

    private static String getSignOfdBuffer(byte[] picBytes, String signBoundary) {
        String[] signBoundaryArr = signBoundary.split(" ");
        float pageOffsetX = Float.parseFloat(signBoundaryArr[0]);
        float pageOffsetY = Float.parseFloat(signBoundaryArr[1]);
        float width = 0.0f;
        float height = 0.0f;
        if (signBoundaryArr.length == 4) {
            width = Float.parseFloat(signBoundaryArr[2]);
            height = Float.parseFloat(signBoundaryArr[3]);
        }
        Map<String, byte[]> signOfdMap = CompressHelper.decompress(picBytes);
        byte[] ofdMainByte = signOfdMap.get("OFD.xml");
        String docRootPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/DocRoot");
        String docRootDirPath = OfdReadUtil.getLastDirPath(docRootPath).toString();
        byte[] documentByte = signOfdMap.get(docRootPath);
        Element documentEle = OfdReadUtil.getElementByByte(documentByte);
        Element commonDataEle = documentEle.element("CommonData");
        String publicResPath = commonDataEle.elementText("PublicRes");
        Map<String, Object> fontFamilyMap = OfdConvertUtil.getFontFamilyByPublicRes(signOfdMap, docRootDirPath, publicResPath, null);
        Element pagesEle = documentEle.element("Pages");
        List pageEleList = pagesEle.elements("Page");
        StringBuilder contentBuffer = new StringBuilder();
        for (int i = 0; i < pageEleList.size(); ++i) {
            Element pageEle = OfdReadUtil.getElementByPath(signOfdMap, (Element)pageEleList.get(i), docRootDirPath);
            Element areaEle = pageEle.element("Area");
            String physicalText = areaEle.elementText("PhysicalBox");
            float zoomX = 1.0f;
            float zoomY = 1.0f;
            if (EmptyUtil.isNoEmpty(physicalText)) {
                String[] physicalArr = physicalText.split(" ");
                zoomX = width / Float.parseFloat(physicalArr[2]);
                zoomY = height / Float.parseFloat(physicalArr[3]);
            }
            Element contentEle = pageEle.element("Content");
            List layerEleList = contentEle.elements("Layer");
            for (Element layerEle : layerEleList) {
                List pathObjectEleList;
                List textEleList;
                Element pageBlockEle = layerEle.element("PageBlock");
                String drawParamId = layerEle.attributeValue("DrawParam");
                List blockTextEleList = null;
                List blockPathEleList = null;
                if (pageBlockEle != null) {
                    blockTextEleList = pageBlockEle.elements("TextObject");
                    blockPathEleList = pageBlockEle.elements("PathObject");
                }
                if ((textEleList = layerEle.elements("TextObject")) != null && !textEleList.isEmpty()) {
                    SvgUtil.getSvgTextByList(textEleList, fontFamilyMap, contentBuffer, drawParamId, pageOffsetX, pageOffsetY, zoomX, zoomY);
                }
                if (blockTextEleList != null && !blockTextEleList.isEmpty()) {
                    SvgUtil.getSvgTextByList(blockTextEleList, fontFamilyMap, contentBuffer, drawParamId, pageOffsetX, pageOffsetY, zoomX, zoomY);
                }
                if ((pathObjectEleList = layerEle.elements("PathObject")) != null && !pathObjectEleList.isEmpty()) {
                    contentBuffer.append(SvgUtil.getSvgLineByList(pathObjectEleList, fontFamilyMap, drawParamId, pageOffsetX, pageOffsetY, zoomX, zoomY));
                }
                if (blockPathEleList == null || blockPathEleList.isEmpty()) continue;
                contentBuffer.append(SvgUtil.getSvgLineByList(blockPathEleList, fontFamilyMap, drawParamId, pageOffsetX, pageOffsetY, zoomX, zoomY));
            }
        }
        return contentBuffer.toString();
    }

    private static String getSignPicBuffer(byte[] picBytes, String signBoundary, float offsetY) {
        if (picBytes == null) {
            return null;
        }
        picBytes = OfdConvertUtil.removeBlank(picBytes);
        String picBase64Str = Base64.getEncoder().encodeToString(picBytes);
        String[] signBoundaryArr = signBoundary.split(" ");
        float pageOffsetY = Float.parseFloat(signBoundaryArr[1]);
        StringBuilder contentBuffer = new StringBuilder();
        contentBuffer.append("<image x=\"").append(signBoundaryArr[0]).append("mm\" ");
        contentBuffer.append("y=\"").append(offsetY + pageOffsetY).append("mm\" ");
        contentBuffer.append("width=\"").append(signBoundaryArr[2]).append("mm\" ");
        contentBuffer.append("height=\"").append(signBoundaryArr[3]).append("mm\" xlink:href=\"data:image/png;base64,");
        contentBuffer.append(picBase64Str.replaceAll("\r", "").replaceAll("\n", ""));
        contentBuffer.append("\"/>");
        return contentBuffer.toString();
    }

    private static byte[] removeBlank(byte[] bytes) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(bytes));
            int width = image.getWidth();
            int height = image.getHeight();
            BufferedImage newImage = new BufferedImage(width, height, 2);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int rgb = image.getRGB(x, y);
                    if (OfdConvertUtil.isWhite(rgb)) {
                        newImage.setRGB(x, y, 0xFFFFFF);
                        continue;
                    }
                    newImage.setRGB(x, y, rgb);
                }
            }
            ImageIO.write((RenderedImage)newImage, "png", outputStream);
        }
        catch (IOException e) {
            return bytes;
        }
        return outputStream.size() > 0 ? outputStream.toByteArray() : bytes;
    }

    private static boolean isWhite(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return red == 255 && green == 255 && blue == 255;
    }
}

