/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.property;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.tmc.fbp.common.property.TmcTreeNodeRefProp;
import kd.tmc.fbp.common.property.TmcTreeNodeTypeProp;

public class TmcTreeNodeProp
extends TmcTreeNodeRefProp {
    public static final char SEPARATOR_NODE = '/';
    public static final char SEPARATOR_ID = '#';
    private boolean isRoot;
    private String nodeId;
    private List<TmcTreeNodeTypeProp> typeList;

    public TmcTreeNodeProp(TreeNode treeNode, TreeNode root, List<TmcTreeNodeTypeProp> typeModelList) {
        this.typeList = typeModelList;
        this.isRoot = StringUtils.equals((CharSequence)root.getId(), (CharSequence)treeNode.getId());
        if (!this.isRoot) {
            this.nodeId = treeNode.getId();
            this.generateNodeType();
            this.generateRefEntityPkValue();
        } else {
            this.nodeId = root.getId();
            this.nodeName = root.getText();
            this.nodeType = TmcTreeNodeTypeProp.ROOT;
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public TmcTreeNodeTypeProp.LeafMode getLeafMode() {
        if (this.nodeType == null) {
            return TmcTreeNodeTypeProp.LeafMode.LEAF;
        }
        return this.nodeType.getLeafMode();
    }

    @Override
    public Object getRefEntityPkValue() {
        return this.refEntityPkValue;
    }

    public Object getParentRefEntityPkValue(TmcTreeNodeTypeProp typeModel) {
        int pTypeIndex;
        String pRefId = null;
        String pTypeName = typeModel.getName() + '#';
        boolean containParent = this.nodeId.contains(pTypeName);
        if (containParent && (pTypeIndex = this.nodeId.lastIndexOf(pTypeName)) != -1) {
            String substring = this.nodeId.substring(pTypeIndex);
            int endIndex = substring.contains(String.valueOf('/')) ? substring.indexOf(47) : substring.length();
            pRefId = substring.substring(pTypeName.length(), endIndex);
        }
        return pRefId;
    }

    @Override
    public TmcTreeNodeTypeProp getNodeType() {
        return this.nodeType;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public String generateChildNodeId(TmcTreeNodeRefProp refModel) {
        if (TmcTreeNodeTypeProp.LeafMode.LEAF == this.getLeafMode()) {
            throw new KDException(BosErrorCode.beans, new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u4e3a\u53f6\u5b50\u8282\u70b9, \u65e0\u6cd5\u751f\u6210\u5b50\u8282\u70b9ID\u3002", (String)"TmcTreeNodeProp_0", (String)"tmc-fbp-common", (Object[])new Object[0])});
        }
        String nodeID = this.nodeId + '/' + refModel.getNodeType().getName() + '#' + refModel.getRefEntityPkValue();
        return nodeID;
    }

    private void generateNodeType() {
        String currNodeInfo = this.nodeId.substring(this.nodeId.lastIndexOf(47) + 1);
        String nodeTypeStr = currNodeInfo.substring(0, currNodeInfo.indexOf(35));
        for (TmcTreeNodeTypeProp typeModel : this.typeList) {
            if (!StringUtils.equals((CharSequence)typeModel.getName(), (CharSequence)nodeTypeStr)) continue;
            this.nodeType = typeModel;
            break;
        }
        if (this.nodeType == null) {
            throw new KDException(BosErrorCode.beans, new Object[]{ResManager.loadKDString((String)"\u672a\u627e\u5230\u6811\u8282\u70b9\u7c7b\u578b\u3002", (String)"TmcTreeNodeProp_1", (String)"tmc-fbp-common", (Object[])new Object[0])});
        }
    }

    private void generateRefEntityPkValue() {
        this.refEntityPkValue = this.nodeId.substring(this.nodeId.lastIndexOf(35) + 1);
    }
}

