/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
public class DateUtils {
    protected static final int[] SEASON = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
    public static final String FORMAT_yyyy = "yyyy";
    public static final String FORMAT_YMD = "yyyy-MM-dd";
    public static final String FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_yyyyMMdd = "yyyyMMdd";
    public static final String FORMAT_yyyyMM = "yyyyMM";
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final String COMMON_MAXDATE_STR = "2099-12-31";
    public static final String COMMON_MINDATE_STR = "1970-01-01";
    private static final ZoneId DEFAULT_ZONE = ZoneId.systemDefault();

    public static Timestamp getCurrentTime() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Date getCurrentDate() {
        return DateUtils.localDate2Date(LocalDate.now());
    }

    public static Date truncateDate(Date dt) {
        if (dt == null) {
            return null;
        }
        return DateUtils.localDate2Date(DateUtils.date2LocalDate(dt));
    }

    public static Date getLastDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static Date getLastMonth(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) - i);
        return cal.getTime();
    }

    public static Date getNextMonth(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) + i);
        return cal.getTime();
    }

    public static Date getLastYear(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(1, cal.get(1) - i);
        return cal.getTime();
    }

    public static Date getNextYear(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(1, cal.get(1) + i);
        return cal.getTime();
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = (int)diff + 1;
        return days;
    }

    public static int getDiffHours(Date beginTime, Date endTime) {
        if (beginTime == null || endTime == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endTime.getTime() - beginTime.getTime()) / 3600000L;
        int hours = (int)diff;
        return hours;
    }

    public static int getDiffMinute(Date beginTime, Date endTime) {
        if (beginTime == null || endTime == null) {
            throw new IllegalArgumentException("getDiffMin param is null!");
        }
        long diff = (endTime.getTime() - beginTime.getTime()) / 60000L;
        int min = (int)diff;
        return min;
    }

    public static Date getDataFormat(Date date, boolean isStart) {
        String dateStr = new SimpleDateFormat(FORMAT_YMD).format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return new SimpleDateFormat(FORMAT_YMDHMS).parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static String formatString(Date date, String forPattern) {
        return new SimpleDateFormat(forPattern).format(date);
    }

    public static int getDay(Date date) {
        return DateUtils.date2LocalDate(date).getDayOfMonth();
    }

    public static int getMonth(Date date) {
        return DateUtils.date2LocalDate(date).getMonthValue();
    }

    public static int getYear(Date date) {
        return DateUtils.date2LocalDate(date).getYear();
    }

    public static Map<String, Date> getWeekDate() {
        return DateUtils.getWeekDate(new Date());
    }

    public static int getCurrWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) - 1;
    }

    public static Map<String, Date> getWeekDate(Date date) {
        HashMap<String, Date> weekDate = new HashMap<String, Date>(16);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int d = 0;
        d = cal.get(7) == 1 ? -6 : 2 - cal.get(7);
        cal.add(7, d);
        weekDate.put("beginDate", cal.getTime());
        cal.add(7, 6);
        weekDate.put("endDate", cal.getTime());
        return weekDate;
    }

    public static Date getMinMonthDate(Date date) {
        date = DateUtils.getDataFormat(date, true);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMaxMonthDate(Date date) {
        date = DateUtils.getDataFormat(date, false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date getMaxWeekDate(Date date) {
        date = DateUtils.getDataFormat(date, false);
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getFirstDayOfWeek(date));
        cal.add(5, 6);
        date = cal.getTime();
        return date;
    }

    public static Date getFirstDateOfNextMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getLastDateOfNextMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date getFirstDateOfAnyMonth(Date date, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, offset);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getLastDateOfAnyMonth(Date date, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, offset);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        return DateUtils.date2LocalDate(date1).isEqual(DateUtils.date2LocalDate(date2));
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            return false;
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static Date stringToDate(String s, String format) {
        Date date = null;
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            date = formater.parse(s);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static Date getFirstSeasonDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = DateUtils.getSeason(cal.get(2));
        cal.set(2, sean * 3 - 3);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getLastSeasonDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = DateUtils.getSeason(cal.get(2));
        cal.set(2, sean * 3);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static int getSeason(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return DateUtils.getSeason(cal.get(2));
    }

    public static int getSeason(int mouth) {
        return SEASON[mouth];
    }

    public static Date getQuarterEnd(Date date) {
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(date);
        endCalendar.set(2, endCalendar.get(2) / 3 * 3 + 2);
        endCalendar.set(5, endCalendar.getActualMaximum(5));
        return endCalendar.getTime();
    }

    public static Date getFirstYearDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getLastYearDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 11);
        cal.set(5, 31);
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getFirstDayOfCurYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(2, 0);
        cal.set(5, 1);
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getLastDayOfCurYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(2, 11);
        cal.set(5, 31);
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getFirstDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMinimum(5));
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getLastDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMaximum(5));
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getFirstDayOfMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(5, cal.getActualMinimum(5));
        return DateUtils.truncateDate(cal.getTime());
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getFirstDayOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return cal.getTime();
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getFirstDayOfWeek(date));
        cal.add(5, 7);
        return cal.getTime();
    }

    public static boolean compareHourAndMinute(int hourFrom, int minuteFrom, int hourTo, int minuteTo) {
        return hourFrom < hourTo || hourFrom == hourTo && minuteFrom < minuteTo;
    }

    public static Date getYearFirst(int year) {
        return DateUtils.localDate2Date(LocalDate.of(year, 1, 1));
    }

    public static Date getYearLast(int year) {
        return DateUtils.localDate2Date(LocalDate.of(year, 12, 31));
    }

    public static Date getAppointDay(int year, int month, int day) {
        return DateUtils.localDate2Date(LocalDate.of(year, month, day));
    }

    public static int getDaysByYearMonth(int year, int month) {
        return LocalDate.of(year, month, 1).lengthOfMonth();
    }

    public static boolean isLeapYear(int year) {
        return LocalDate.of(year, 1, 1).isLeapYear();
    }

    public static boolean isSameYear(Date date1, Date date2) {
        return DateUtils.date2LocalDate(date1).getYear() == DateUtils.date2LocalDate(date2).getYear();
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        return DateUtils.date2LocalDate(date1).getMonthValue() == DateUtils.date2LocalDate(date2).getMonthValue();
    }

    public static Date getNextWeek(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(4, cal.get(4) + i);
        return cal.getTime();
    }

    public static List<Date> getMonthCycList(Date startDate, Date endDate, int MonthCycle) {
        ArrayList<Date> cycleDateList = new ArrayList<Date>(10);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int dateNum = cal.get(5);
        while (startDate.compareTo(endDate) <= 0) {
            cycleDateList.add(startDate);
            cal.add(2, MonthCycle);
            int actualMaximum = cal.getActualMaximum(5);
            if (actualMaximum < dateNum) {
                cal.set(5, actualMaximum);
            } else {
                cal.set(5, dateNum);
            }
            startDate = cal.getTime();
        }
        return cycleDateList;
    }

    public static List<Date> getWeekCycList(Date startDate, Date endDate, int weekCycle) {
        ArrayList<Date> cycleDateList = new ArrayList<Date>(10);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (startDate.compareTo(endDate) <= 0) {
            cycleDateList.add(startDate);
            cal.set(4, cal.get(4) + weekCycle);
            startDate = cal.getTime();
        }
        return cycleDateList;
    }

    @KSMethod
    public static String getDiff_ymd(Date startDate, Date endDate) {
        LocalDate startLocalDate = DateUtils.date2LocalDate(startDate);
        LocalDate endLocalDate = DateUtils.date2LocalDate(endDate);
        Period between = Period.between(startLocalDate, endLocalDate);
        StringBuilder sBuilder = new StringBuilder();
        int years = between.getYears();
        int months = between.getMonths();
        int days = between.getDays();
        int endMonthDay = endLocalDate.getDayOfMonth();
        boolean isEndMonthDay = endLocalDate.lengthOfMonth() == endMonthDay;
        int startDayOfMonth = startLocalDate.getDayOfMonth();
        if (isEndMonthDay) {
            if (startDayOfMonth >= endMonthDay && days > 0) {
                if (++months == 12) {
                    ++years;
                    months = 0;
                }
                days = 0;
            } else if (startDayOfMonth == startLocalDate.lengthOfMonth()) {
                days = 0;
            }
        }
        if (years > 0) {
            sBuilder.append(years).append("y");
        }
        if (months > 0) {
            sBuilder.append(months).append("m");
        }
        if (days > 0) {
            sBuilder.append(days).append("d");
        }
        return sBuilder.toString();
    }

    public static Date getCommonMaxDate() {
        return DateUtils.stringToDate(COMMON_MAXDATE_STR, FORMAT_YMD);
    }

    public static Date getAfterMonthAccordThirtyDays(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(5, 30 * i);
        return cal.getTime();
    }

    public static Date localDate2Date(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(DEFAULT_ZONE).toInstant());
    }

    public static LocalDate date2LocalDate(Date date) {
        return DateUtils.date2LocalDateTime(date).toLocalDate();
    }

    public static Date localDateTime2Date(LocalDateTime localDate) {
        return Date.from(localDate.atZone(DEFAULT_ZONE).toInstant());
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), DEFAULT_ZONE);
    }

    public static LocalDateTime getFirstDayOfMonth(LocalDateTime localDate) {
        return localDate.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDateTime getLastDayOfMonth(LocalDateTime localDate) {
        return localDate.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static boolean isValidDate(String dateStr, String format) {
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            formater.parse(dateStr);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static Date getDateOfZoone(Date date, String zoneId) {
        ZoneId currZoneId = ZoneId.of(zoneId);
        if (!DEFAULT_ZONE.equals(currZoneId)) {
            ZonedDateTime zonedDateTime = date.toInstant().atZone(ZoneId.of(zoneId));
            LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
            return DateUtils.localDateTime2Date(localDateTime);
        }
        return date;
    }
}

