/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

@KSObject
public class TcDateUtils {
    private static Log logger = LogFactory.getLog(TcDateUtils.class);
    private static final int[] SEASON = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
    public static final String FORMAT_YMD = "yyyy-MM-dd";
    public static final String FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_yyyyMMdd = "yyyyMMdd";
    public static final String FORMAT_MMddyyyy = "MM/dd/yyyy";

    public static Timestamp getCurrentTime() {
        return new Timestamp(new Date().getTime());
    }

    public static Date getCurrentDate() {
        return DateUtils.getCurrentDate();
    }

    public static Date truncateDate(Date dt) {
        return DateUtils.truncateDate(dt);
    }

    public static Date addSecond(Date date, int time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(13, time);
        return cal.getTime();
    }

    public static Date getLastDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static Date getLastMonth(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(2, -i);
        return cal.getTime();
    }

    public static Date getNextMonth(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(2, i);
        return cal.getTime();
    }

    public static Date getLastYear(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(1, -i);
        return cal.getTime();
    }

    public static Date getNextYear(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(1, i);
        return cal.getTime();
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = (int)diff;
        return days;
    }

    public static int getDiffHours(Date beginTime, Date endTime) {
        if (beginTime == null || endTime == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endTime.getTime() - beginTime.getTime()) / 3600000L;
        int hours = (int)diff;
        return hours;
    }

    public static Date getDataFormat(Date date, boolean isStart) {
        String dateStr = new SimpleDateFormat(FORMAT_YMD).format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return new SimpleDateFormat(FORMAT_YMDHMS).parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static String formatString(Date date, String forPattern) {
        return DateUtils.formatString(date, forPattern);
    }

    public static int getDay(Date date) {
        return DateUtils.getDay(date);
    }

    public static int getMonth(Date date) {
        return DateUtils.getDay(date);
    }

    public static int getYear(Date date) {
        return DateUtils.getDay(date);
    }

    public static Map<String, Date> getWeekDate() {
        HashMap<String, Date> weekDate = new HashMap<String, Date>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int d = 0;
        d = cal.get(7) == 1 ? -6 : 2 - cal.get(7);
        cal.add(7, d);
        weekDate.put("beginDate", cal.getTime());
        cal.add(7, 6);
        weekDate.put("endDate", cal.getTime());
        return weekDate;
    }

    public static Date getMinMonthDate(Date date) {
        date = TcDateUtils.getDataFormat(date, true);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMaxMonthDate(Date date) {
        date = TcDateUtils.getDataFormat(date, false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date getFirstDateOfNextMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getLastDateOfNextMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return TcDateUtils.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            return false;
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int month1 = calendar1.get(2);
        int month2 = calendar2.get(2);
        return month1 == month2;
    }

    public static boolean isSameMonthAndDay(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int month1 = calendar1.get(2);
        int month2 = calendar2.get(2);
        int day1 = calendar1.get(5);
        int day2 = calendar2.get(5);
        return month1 == month2 && day1 == day2;
    }

    public static Date stringToDate(String s, String format) {
        Date date = null;
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            date = formater.parse(s);
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        return date;
    }

    public static Date getFirstSeasonDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = TcDateUtils.getSeason(cal.get(2));
        cal.set(2, sean * 3 - 3);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getLastSeasonDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = TcDateUtils.getSeason(cal.get(2));
        cal.set(2, sean * 3);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static int getSeason(int mouth) {
        return SEASON[mouth];
    }

    public static Date getFirstYearDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        return TcDateUtils.truncateDate(cal.getTime());
    }

    public static Date getLastYearDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 11);
        cal.set(5, 31);
        return TcDateUtils.truncateDate(cal.getTime());
    }

    public static Date getFirstDayOfCurYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(2, 0);
        cal.set(5, 1);
        return TcDateUtils.truncateDate(cal.getTime());
    }

    public static Date getLastDayOfCurYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(2, 11);
        cal.set(5, 31);
        return TcDateUtils.truncateDate(cal.getTime());
    }

    public static Date getFirstDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMinimum(5));
        return TcDateUtils.truncateDate(cal.getTime());
    }

    public static Date getLastDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMaximum(5));
        return TcDateUtils.truncateDate(cal.getTime());
    }

    public static Date getFirstDayOfMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(5, cal.getActualMinimum(5));
        return TcDateUtils.truncateDate(cal.getTime());
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getFirstDayOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return cal.getTime();
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(TcDateUtils.getFirstDayOfWeek(date));
        cal.add(5, 7);
        return cal.getTime();
    }

    public static boolean compareHourAndMinute(int hourFrom, int minuteFrom, int hourTo, int minuteTo) {
        return hourFrom < hourTo || hourFrom == hourTo && minuteFrom < minuteTo;
    }

    public static void main(String[] args) {
        System.out.println(TcDateUtils.getDataFormat(new Date(), true));
        System.out.println(TcDateUtils.getDataFormat(new Date(), false));
        System.out.println(TcDateUtils.getNextDay(new Date(), -1));
    }

    public static int getDiffMonth(Date startDate, Date endDate) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(endDate);
        c2.setTime(startDate);
        int year1 = c1.get(1);
        int year2 = c2.get(1);
        int month1 = c1.get(2);
        int month2 = c2.get(2);
        int day1 = c1.get(5);
        int day2 = c2.get(5);
        int yearInterval = year1 - year2;
        if (month1 < month2 || month1 == month2 && day1 < day2) {
            --yearInterval;
        }
        int monthInterval = month1 + 12 - month2;
        if (day1 < day2) {
            --monthInterval;
        }
        int monthsDiff = Math.abs(yearInterval * 12 + (monthInterval %= 12));
        return monthsDiff;
    }

    @KSMethod
    public static String getDiffYMD(Date startDate, Date endDate) {
        if (endDate.before(startDate)) {
            return "0d";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int startY = cal.get(1);
        int startM = cal.get(2);
        int startD = cal.get(5);
        int startDayOfMonth = cal.getActualMaximum(5);
        cal.setTime(endDate);
        int endY = cal.get(1);
        int endM = cal.get(2);
        int endD = cal.get(5);
        cal = Calendar.getInstance();
        cal.setTime(endDate);
        cal.add(2, -1);
        int dayOfLastMonthEnd = cal.getActualMaximum(5);
        StringBuilder sBuilder = new StringBuilder();
        int lday = endD - startD;
        if (lday < 0) {
            --endM;
            lday = dayOfLastMonthEnd < startD ? endD : dayOfLastMonthEnd + endD - startD;
        }
        int mos = (endY - startY) * 12 + (endM - startM);
        int lyear = mos / 12;
        int lmonth = mos % 12;
        if (lyear > 0) {
            sBuilder.append(lyear).append("y");
        }
        if (lmonth > 0) {
            sBuilder.append(lmonth).append("m");
        }
        if (lday > 0) {
            sBuilder.append(lday).append("d");
        }
        if (EmptyUtil.isEmpty(sBuilder.toString())) {
            sBuilder.append("0d");
        }
        return sBuilder.toString();
    }

    @KSMethod
    public static String getDiff_ymd(Date startDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int startY = cal.get(1);
        int startM = cal.get(2);
        int startD = cal.get(5);
        int startDayOfMonth = cal.getActualMaximum(5);
        cal.setTime(endDate);
        int endY = cal.get(1);
        int endM = cal.get(2);
        int endD = cal.get(5) + 1;
        int endDayOfMonth = cal.getActualMaximum(5);
        StringBuilder sBuilder = new StringBuilder();
        int lday = endD - startD;
        if (lday < 0) {
            --endM;
            lday = startDayOfMonth + lday;
        }
        if (lday == endDayOfMonth) {
            ++endM;
            lday = 0;
        }
        int mos = (endY - startY) * 12 + (endM - startM);
        int lyear = mos / 12;
        int lmonth = mos % 12;
        if (lyear > 0) {
            sBuilder.append(lyear).append("y");
        }
        if (lmonth > 0) {
            sBuilder.append(lmonth).append("m");
        }
        if (lday > 0) {
            sBuilder.append(lday).append("d");
        }
        if (EmptyUtil.isEmpty(sBuilder.toString())) {
            sBuilder.append("0d");
        }
        return sBuilder.toString();
    }

    public static double getDiffYear(Date startDate, Date endDate) {
        Calendar d1 = Calendar.getInstance();
        d1.setTime(startDate);
        Calendar d2 = Calendar.getInstance();
        d2.setTime(endDate);
        double result = d2.get(1) - d1.get(1) + (d2.get(2) - d1.get(2)) / 12;
        return result;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static TimeZone getTimeZone(DynamicObject timeZone) {
        String timeArea = timeZone.getString("number");
        return TimeZone.getTimeZone(timeArea);
    }

    public static Date getZoneTime(Date date, TimeZone zone) {
        TimeZone sysZone = KDDateUtils.getSysTimeZone();
        return new Date(date.getTime() + (long)(sysZone.getRawOffset() - zone.getRawOffset()));
    }

    public static DynamicObject getSysZone() {
        TimeZone sysZone = KDDateUtils.getSysTimeZone();
        QFilter filter = new QFilter("number", "=", (Object)sysZone.getID());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"inte_timezone", (QFilter[])filter.toArray());
    }
}

