/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.sdk.tmc.fbp.extpoint.INormalReportSDKService;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.snap.IDataSnapExecute;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractTmcListDataPlugin
extends AbstractReportListDataPlugin
implements IDataSnapExecute {
    private static final Log logger = LogFactory.getLog(AbstractTmcListDataPlugin.class);
    protected String sumField = "sumlevel";

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        String snapItem = null;
        Map<String, Object> filterParam = this.transQueryParam(queryParam);
        if (filterParam.containsKey("snapItem") && EmptyUtil.isNoEmpty((Object)filterParam.get("snapItem"))) {
            snapItem = (String)filterParam.get("snapItem");
        }
        String formid = (String)filterParam.get("formid");
        SnapDataHelper.saveQueryParam((String)formid, (ReportQueryParam)queryParam, (String)((Object)((Object)this)).getClass().getName(), (boolean)false);
        return this.getQueryDataSet(formid, queryParam, snapItem);
    }

    protected DataSet getQueryDataSet(String formid, ReportQueryParam queryParam, String snapItem) {
        if (this.isUseDataSnap(snapItem)) {
            logger.info("-----------\u6267\u884c\u62a5\u8868\u5feb\u7167\u6570\u636e\u67e5\u8be2-----------");
            return this.querySnapDataSet(formid, queryParam, snapItem);
        }
        logger.info("-----------\u6267\u884c\u5b9e\u65f6\u8868\u6570\u636e\u67e5\u8be2-----------");
        return this.queryRealTimeDataSet(queryParam);
    }

    protected boolean isUseDataSnap(String snapItem) {
        return EmptyUtil.isNoEmpty((String)snapItem);
    }

    public DataSet querySnapDataSet(String formid, ReportQueryParam queryParam, String snapItem) {
        long beginTime = System.currentTimeMillis();
        logger.info("-----------formid:" + formid + "-----------");
        CachedDataSet ds = this.queryShowSnapDataSet(formid, queryParam, snapItem);
        if (EmptyUtil.isEmpty((Object)ds)) {
            return this.queryRealTimeDataSet(queryParam);
        }
        long endTime = System.currentTimeMillis();
        logger.info("-----------formid:" + formid + "; \u8017\u65f6\uff1a" + (endTime - beginTime) + "ms-----------");
        return ds.toDataSet(Algo.create((String)"filterSnapDataSet"), false);
    }

    protected CachedDataSet queryShowSnapDataSet(String formid, ReportQueryParam queryParam, String snapItem) {
        Map<String, Object> param = this.transQueryParam(queryParam);
        DynamicObject org = null;
        Date queryDate = null;
        if (param.containsKey("org")) {
            org = (DynamicObject)param.get("org");
        }
        if (param.containsKey("querydate")) {
            queryDate = (Date)param.get("querydate");
        }
        return (CachedDataSet)SnapDataHelper.createCacheDataSet((String)formid, (Long)(org == null ? 0L : org.getLong("id")), (String)snapItem, (Date)queryDate).getRight();
    }

    protected ReportQueryParam initSnapQueryParam(ReportQueryParam queryParam) {
        return queryParam;
    }

    protected Map<String, Object> transQueryParam(ReportQueryParam param) {
        return SnapDataHelper.transQueryParam((ReportQueryParam)param);
    }

    protected DataSet mergeDataSet(DataSet ds1, DataSet ds2, String[] leftJoinFieldName, String[] rightJoinFieldName) {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        Collections.addAll(fieldNameList, ds1.getRowMeta().getFieldNames());
        for (String fieldName : ds2.getRowMeta().getFieldNames()) {
            if (fieldNameList.contains(fieldName)) continue;
            fieldNameList.add(fieldName);
        }
        JoinDataSet ds = ds1.copy().join(ds2, JoinType.LEFT);
        for (int index = 0; index < rightJoinFieldName.length; ++index) {
            ds.on(leftJoinFieldName[index].trim(), rightJoinFieldName[index].trim());
        }
        return ds.select(fieldNameList.toArray(new String[fieldNameList.size()])).finish();
    }

    public String printDs(DataSet dataSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(Arrays.toString(dataSet.copy().getRowMeta().getFieldNames()));
        DynamicObjectCollection dcs = ORM.create().toPlainDynamicObjectCollection(dataSet.copy());
        sb.append(ResManager.loadKDString((String)"\u603b\u884c\u6570\uff1a", (String)"AbstractTmcListDataPlugin_1", (String)"tmc-fbp-report", (Object[])new Object[0])).append(dcs.size());
        sb.append("\n");
        for (DynamicObject dc : dcs) {
            sb.append(dc.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected DataSet ChangeRowToColDataSet(DataSet ds, String changeField, String groupFieldName, String beginChangeField) {
        DataSet tempDs = ds.copy();
        HashSet<DataSet> dsSet = new HashSet<DataSet>(32);
        HashMap<String, String> dsFieldName = new HashMap<String, String>(32);
        HashSet<Integer> hashCodes = new HashSet<Integer>(32);
        while (tempDs.hasNext()) {
            void var13_13;
            String fieldName;
            Row row = tempDs.next();
            DataType dateType = tempDs.getRowMeta().getField(changeField).getDataType();
            String fieldValue = row.getString(changeField);
            if (dateType.equals((Object)DataType.StringType)) {
                fieldName = beginChangeField + this.getHashCode(hashCodes, fieldValue);
                String string = changeField + " = '" + fieldValue + "'";
            } else {
                fieldName = beginChangeField + fieldValue;
                String string = changeField + " = " + fieldValue;
            }
            if (dsFieldName.get(fieldValue) != null) continue;
            DataSet ds1 = ds.copy().filter((String)var13_13).select(groupFieldName + ", count as " + fieldName);
            dsSet.add(ds1);
            dsFieldName.put(fieldValue, "");
        }
        DataSet result = ds.copy().select(groupFieldName).groupBy(groupFieldName.split(",")).finish();
        for (DataSet dsTemp : dsSet) {
            void var13_19;
            if (result == null) {
                result = dsTemp;
                continue;
            }
            ArrayList<String> fieldNameList = new ArrayList<String>();
            Collections.addAll(fieldNameList, dsTemp.getRowMeta().getFieldNames());
            for (String fieldName : result.getRowMeta().getFieldNames()) {
                if (fieldNameList.contains(fieldName)) continue;
                fieldNameList.add(fieldName);
            }
            JoinDataSet joinDataSet = result.join(dsTemp, JoinType.LEFT);
            for (String groupField : groupFieldName.split(",")) {
                JoinDataSet joinDataSet2 = var13_19.on(groupField.trim(), groupField.trim());
            }
            result = var13_19.select(fieldNameList.toArray(new String[fieldNameList.size()])).finish();
        }
        return result;
    }

    protected int getHashCode(Set<Integer> hashCodes, String s) {
        int i = s.hashCode();
        if (i < 0) {
            i = -1 * i;
        }
        if (hashCodes == null) {
            return i;
        }
        while (hashCodes.contains(i)) {
            ++i;
        }
        return i;
    }

    protected DataSet addSubTotalDataSet(DataSet rowSet, List<String> gruopFields, List<String> sumFields, String sumNameField, String totalDesc) {
        Field[] fields;
        DataSet dsTemp = rowSet.copy();
        GroupbyDataSet gdsTemp = dsTemp.groupBy(gruopFields.toArray(new String[0]));
        for (String sumField : sumFields) {
            gdsTemp.sum(sumField);
        }
        DataSet ds = gdsTemp.finish();
        LinkedList<String> selectField = new LinkedList<String>();
        for (Field field : fields = rowSet.getRowMeta().getFields()) {
            if (gruopFields.contains(field.getName()) || sumFields.contains(field.getName())) {
                selectField.add(field.getName());
                continue;
            }
            if (field.getName().equals(sumNameField)) {
                selectField.add("'" + totalDesc + "' as " + field.getName());
                continue;
            }
            if (field.getName().equals(this.sumField)) {
                selectField.add("1 as " + this.sumField);
                continue;
            }
            selectField.add("NULL as " + field.getName());
        }
        return ds.select(String.join((CharSequence)",", selectField));
    }

    protected DataSet addSubTotalDataSet(DataSet rowSet, List<String> gruopFields, List<String> sumFields, String sumNameField) {
        return this.addSubTotalDataSet(rowSet, gruopFields, sumFields, sumNameField, ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AbstractTmcListDataPlugin_2", (String)"tmc-fbp-report", (Object[])new Object[0]));
    }

    protected DataSet addAllTotalDataSet(DataSet bizDs, List<String> sumFields, String sumNameField) {
        return this.addAllTotalDataSet(bizDs, sumFields, new ArrayList<String>(), sumNameField);
    }

    protected DataSet addAllTotalDataSet(DataSet bizDs, List<String> sumFields, List<String> gruopFields, String sumNameField) {
        return this.addAllTotalDataSet(bizDs, sumFields, gruopFields, sumNameField, ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AbstractTmcListDataPlugin_3", (String)"tmc-fbp-report", (Object[])new Object[0]));
    }

    protected DataSet addAllTotalDataSet(DataSet bizDs, List<String> sumFields, List<String> gruopFields, String sumNameField, String totalDesc) {
        Field[] fields;
        DataSet dsTemp = bizDs.copy();
        String[] groupField = null;
        if (EmptyUtil.isNoEmpty(gruopFields)) {
            groupField = gruopFields.toArray(new String[0]);
        }
        GroupbyDataSet gdsTemp = dsTemp.filter(this.sumField + " = 0").groupBy(groupField);
        for (String sumField : sumFields) {
            gdsTemp.sum(sumField);
        }
        DataSet ds = gdsTemp.finish();
        LinkedList<String> selectField = new LinkedList<String>();
        for (Field field : fields = bizDs.getRowMeta().getFields()) {
            if (sumFields.contains(field.getName())) {
                selectField.add(field.getName());
                continue;
            }
            if (field.getName().equals(sumNameField)) {
                selectField.add("'" + totalDesc + "' as " + field.getName());
                continue;
            }
            if (field.getName().equals(this.sumField)) {
                selectField.add("2 as " + this.sumField);
                continue;
            }
            if (gruopFields != null && gruopFields.contains(field.getName().trim())) {
                selectField.add(field.getName());
                continue;
            }
            selectField.add("NULL as " + field.getName());
        }
        return ds.select(String.join((CharSequence)",", selectField));
    }

    public DataSet getSumDataSetByLevel(DataSet treeData, List<String> sumFields, String customFields) {
        Set<Integer> levels = this.getLevels(treeData.copy());
        List levelList = levels.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        for (Integer level : levelList) {
            if (level == 1) continue;
            String filter = "level=" + level;
            String sumFieldSts = this.getSumFields(sumFields, false, customFields);
            GroupbyDataSet groupbyDataSet = treeData.copy().filter(filter).select(sumFieldSts.split(",")).groupBy(new String[]{"pid"});
            sumFields.forEach(field -> groupbyDataSet.sum("p" + field));
            DataSet deltailSm = groupbyDataSet.finish();
            String joinFieldSts = this.getSumFields(sumFields, true, customFields);
            treeData = treeData.leftJoin(deltailSm).on("rowid", "pid").select(joinFieldSts.split(",")).finish();
        }
        return treeData;
    }

    @Deprecated
    public DataSet getSubDataSet(DataSet treeData, List<String> sumFields) {
        return this.getSubDataSet(treeData, sumFields, treeData);
    }

    public DataSet getSubDataSet(DataSet treeData, List<String> sumFields, DataSet sumData) {
        String filterStr = this.getFilterStr(sumFields);
        DataSet filterData = sumData.copy().filter(filterStr);
        HashSet parentIds = new HashSet();
        filterData.forEach(t -> {
            if (EmptyUtil.isNotBlank((CharSequence)t.getString("pid"))) {
                parentIds.add(t.getString("pid"));
            }
        });
        DataSet subDs = EmptyUtil.isNoEmpty(parentIds) ? treeData.filter("rowid in ('" + StringUtils.join(parentIds, (String)"','") + "')") : this.createEmptyDataSet(treeData);
        return subDs.updateField("pid", "rowid").updateField("isgroupnode", "'0'").updateField("rowid", "rowid+'_sort'").addField("0", "subsort");
    }

    public DataSet removeNoDataTreeDs(DataSet treeData, List<String> amountFields) {
        String[] fieldNames = treeData.getRowMeta().getFieldNames();
        treeData = treeData.copy().filter(this.getFilterStr(amountFields)).select(fieldNames);
        DataSet pidGroupDs = treeData.copy().groupBy(new String[]{"pid"}).finish().select("pid parentid");
        treeData = treeData.leftJoin(pidGroupDs).on("rowid", "parentid").select(fieldNames, new String[]{"parentid"}).finish();
        return treeData.updateField("isgroupnode", "case when parentid=null then '0' else '1' end ");
    }

    public DataSet createEmptyDataSet(DataSet dataSet) {
        return AbstractTmcListDataPlugin.createEmptyDataSet(dataSet.getRowMeta().getFieldNames(), dataSet.getRowMeta().getDataTypes());
    }

    public static DataSet createEmptyDataSet(String[] fieldNames, DataType[] dataTypes) {
        RowMeta rowMeta = new RowMeta(fieldNames, dataTypes);
        DataSet emptyDataSet = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        return emptyDataSet;
    }

    private String getFilterStr(List<String> amountFields) {
        StringBuilder filter = new StringBuilder();
        amountFields.forEach(o -> {
            filter.append("( ");
            filter.append((String)o);
            filter.append(" !=0 and ");
            filter.append((String)o);
            filter.append("!=null ) or ");
        });
        return filter.substring(0, filter.length() - 4);
    }

    private String getSumFields(List<String> sumFields, boolean isJoin, String customFields) {
        StringBuilder fieldStrs = new StringBuilder();
        String str = "pid,";
        if (isJoin) {
            str = "rowid, pid, isgroupnode, level, sumlevel,";
        }
        fieldStrs.append(str);
        for (String field : sumFields) {
            String expStr = field + " as p" + field;
            if (isJoin) {
                expStr = field + "+ p" + field + " as " + field;
            }
            fieldStrs.append(expStr).append(",");
        }
        if (isJoin) {
            return fieldStrs.append(customFields).toString();
        }
        return fieldStrs.substring(0, fieldStrs.length());
    }

    private Set<Integer> getLevels(DataSet treeData) {
        HashSet<Integer> levels = new HashSet<Integer>();
        DataSet levelDs = treeData.groupBy(new String[]{"level"}).finish();
        levelDs.forEach(o -> {
            if (o.getInteger("level") != null) {
                levels.add(o.getInteger("level"));
            }
        });
        return levels;
    }

    protected DataSet queryRealTimeDataSet(ReportQueryParam queryParam) {
        DataSet finalDataSet;
        DataSet dataSet = this.query(queryParam);
        PluginProxy pluginProxy = PluginProxy.create(INormalReportSDKService.class, (String)"kd.sdk.tmc.fbp.extpoint.INormalReportSDKService");
        List dataSetList = pluginProxy.callReplace(arg_0 -> this.lambda$queryRealTimeDataSet$4(finalDataSet = dataSet, queryParam, arg_0));
        if (EmptyUtil.isNoEmpty((Object)dataSetList) && dataSetList.size() > 0 && EmptyUtil.isNoEmpty(dataSetList.get(0))) {
            dataSet = (DataSet)dataSetList.get(0);
        }
        return dataSet;
    }

    protected DataSet query(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet data(String formid, String schemeid, QFilter[] filters) throws Exception {
        logger.info("-----------\u6570\u636e\u5feb\u7167\u53d6\u6570\u63a5\u53e3 formid=" + formid + "; schemeid=" + schemeid);
        ReportQueryParam param = this.getQueryParam(formid, schemeid, "query");
        param = this.setQueryParam(param, filters);
        DataSet ds = this.queryRealTimeDataSet(param);
        logger.info("-----------\u6570\u636e\u5feb\u7167\u53d6\u6570\u63a5\u53e3\u7ed3\u675f formid=" + formid + "; schemeid=" + schemeid);
        return ds;
    }

    public DataSet data(QFilter[] filters) throws Exception {
        logger.info("-----------\u53cd\u5c04\u8c03\u7528\u53d6\u6570\u63a5\u53e3\u5f00\u59cb");
        ReportQueryParam param = new ReportQueryParam();
        param = this.setQueryParam(param, filters);
        DataSet ds = this.queryRealTimeDataSet(param);
        logger.info("-----------\u53cd\u5c04\u8c03\u7528\u53d6\u6570\u63a5\u53e3\u7ed3\u675f");
        return ds;
    }

    public void execute(String formid, String schemeid, QFilter[] filter, String batchno) throws Exception {
        ReportQueryParam param = this.getQueryParam(formid, schemeid, batchno);
        param = this.setQueryParam(param, filter);
        DataSet ds = this.queryRealTimeDataSet(param);
        Pair orgAndOrgView = SnapDataHelper.getOrgAndOrgViewId((QFilter[])filter);
        SnapDataHelper.saveDataSet((String)formid, (Long)((Long)orgAndOrgView.getLeft()), (String)batchno, (DataSet)ds, null);
    }

    protected ReportQueryParam getQueryParam(String formid, String schemeid, String batchno) throws Exception {
        return SnapDataHelper.getReportQueryParam((String)formid, (String)schemeid, (String)batchno);
    }

    protected ReportQueryParam setQueryParam(ReportQueryParam param, QFilter[] filter) {
        return param;
    }

    public DataSet getDataSet(String formid, ReportQueryParam queryParam, String snapItem) {
        CachedDataSet ds;
        long beginTime = System.currentTimeMillis();
        logger.info("-----------formid:" + formid + "; snapItem=" + snapItem + "-----------");
        DynamicObject org = null;
        Date queryDate = null;
        Map<String, Object> param = this.transQueryParam(queryParam);
        if (param.containsKey("org")) {
            org = (DynamicObject)param.get("org");
        }
        if (param.containsKey("querydate")) {
            queryDate = (Date)param.get("querydate");
        }
        if (EmptyUtil.isEmpty((Object)(ds = (CachedDataSet)SnapDataHelper.createCacheDataSet((String)formid, (Long)(org == null ? 0L : org.getLong("id")), (String)snapItem, (Date)queryDate).getRight()))) {
            try {
                return this.query(queryParam, 88);
            }
            catch (Throwable e) {
                throw new KDBizException(e.getMessage());
            }
        }
        DataSet snapDs = ds.toDataSet(Algo.create((String)"newDataSet2"), false);
        long endTime = System.currentTimeMillis();
        logger.info("-----------formid:" + formid + "; \u8017\u65f6\uff1a" + (endTime - beginTime) + "ms-----------");
        return snapDs;
    }

    private /* synthetic */ DataSet lambda$queryRealTimeDataSet$4(DataSet finalDataSet, ReportQueryParam queryParam, INormalReportSDKService p) {
        return p.reBuildDataSet(((Object)((Object)this)).getClass().getName(), finalDataSet, queryParam);
    }
}

