/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.datatype.StringType;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractTmcTreeReportDataPlugin
extends AbstractTmcListDataPlugin {
    private static final List<String> TREELIST = Arrays.asList("rowid", "pid", "isgroupnode", "orgname", "level", "sumlevel");
    private static final Long DEFAULTORGVIEWID = 8L;
    protected String uniqueRow;
    private static final Log logger = LogFactory.getLog(AbstractTmcTreeReportDataPlugin.class);

    @Override
    public DataSet query(ReportQueryParam queryParam) {
        DataSet bizDataSet = this.queryDataSet(queryParam);
        if (bizDataSet == null || bizDataSet.isEmpty()) {
            return this.reDealResultDataSet(bizDataSet, queryParam);
        }
        this.uniqueRow = this.getUniqueRow();
        Map<String, Object> paramMap = this.transQueryParam(queryParam);
        DataSet exchangeDataSet = this.addExchangeRateAndCurrencyUnit(bizDataSet, paramMap);
        Long statCurrency = (Long)((DynamicObject)paramMap.get("filter_statcurrency")).getPkValue();
        DataSet bizDs = exchangeDataSet.addFields(new String[]{String.valueOf(statCurrency), "0"}, new String[]{"statcurrency", "sumlevel"});
        bizDs = this.addOrgViewTree(bizDs, paramMap, queryParam);
        bizDs = this.addSubRowDataSet(bizDs, paramMap);
        bizDs = this.addSumRowDataSet(bizDs, paramMap);
        bizDs = bizDs.updateField("statcurrency", String.valueOf(statCurrency));
        boolean openreportrebuild = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.FCS.getId(), (long)RequestContext.get().getOrgId(), (String)"openreportrebuild");
        if (openreportrebuild) {
            logger.info("\u91cd\u6784\u62a5\u8868");
            return this.rebuildRowIDAndPId(this.reDealResultDataSet(bizDs, queryParam));
        }
        return this.reDealResultDataSet(bizDs, queryParam);
    }

    protected DataSet addOrgViewTree(DataSet bizDs, Map<String, Object> paramMap, ReportQueryParam queryParam) {
        if (this.isNeedOrgTree()) {
            String queryWay = (String)paramMap.get("filter_queryway");
            boolean showStep = "step".equals(paramMap.get("filter_showttype"));
            if (showStep) {
                DataSet treeDateSet;
                DataSet orgDataSet;
                List<Long> orgIds = this.getQueryOrgIds(queryParam);
                if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay)) {
                    orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)DEFAULTORGVIEWID);
                } else {
                    DynamicObject orgView = (DynamicObject)paramMap.get("filter_orgview");
                    orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgView.getLong("id"));
                }
                if (EmptyUtil.isNoEmpty(orgIds)) {
                    orgDataSet = orgDataSet.copy().filter("orgid in (" + StringUtils.join(orgIds, (String)",") + ")");
                }
                DataSet tempDs = orgDataSet.copy().leftJoin(orgDataSet.copy().select(new String[]{"pid pidc", "rowid rowidc"})).on("pid", "rowidc").select(new String[]{"pid", "rowidc"}).finish();
                ArrayList pidList = new ArrayList(10);
                tempDs.iterator().forEachRemaining(v -> {
                    if (v.getLong("rowidc") == null) {
                        pidList.add(v.getLong("pid"));
                    }
                });
                String pidStr = "case when pid in (" + StringUtils.join(pidList, (String)",") + ") then 0 else pid end";
                String levelStr = "case when pid in (" + StringUtils.join(pidList, (String)",") + ") then 1 else level end";
                orgDataSet = orgDataSet.addField("orgname", (String)this.getBizAndReportOrgProp().getRight()).updateFields(new String[]{"pid", "level"}, new String[]{pidStr, levelStr});
                Pair<String, String> treeGroupField = this.treeGroupField();
                if (treeGroupField != null) {
                    String groupIDField = (String)treeGroupField.getLeft();
                    List<String> fieldNames = Arrays.stream(bizDs.getRowMeta().getFieldNames()).filter(s -> !"tarcurrency".equals(s) && !"rate".equals(s)).collect(Collectors.toList());
                    List<String> otherFields = fieldNames.stream().filter(v -> !this.amountFields().contains(v)).collect(Collectors.toList());
                    GroupbyDataSet groupDs = bizDs.copy().groupBy(new String[]{(String)this.getBizAndReportOrgProp().getLeft(), groupIDField});
                    for (String amountField : this.amountFields()) {
                        groupDs.sum(amountField);
                    }
                    bizDs = groupDs.finish().leftJoin(bizDs.select(otherFields.toArray(new String[0])).distinct()).on((String)this.getBizAndReportOrgProp().getLeft(), (String)this.getBizAndReportOrgProp().getLeft()).on(groupIDField, groupIDField).select(fieldNames.toArray(new String[0])).finish().distinct().addField((String)this.getBizAndReportOrgProp().getLeft() + "+'_'+" + groupIDField, (String)this.getBizAndReportOrgProp().getLeft() + "_" + groupIDField);
                    DataSet treeGroupDs = bizDs.copy().groupBy(new String[]{groupIDField, (String)treeGroupField.getRight()}).finish();
                    orgDataSet = this.getOrgGroupDs(treeGroupDs, orgDataSet, treeGroupField);
                    fieldNames.addAll(TREELIST);
                    treeDateSet = orgDataSet.leftJoin(bizDs.removeFields(new String[]{groupIDField})).on("rowid", (String)this.getBizAndReportOrgProp().getLeft() + "_" + groupIDField).select(new HashSet<String>(fieldNames).toArray(new String[0])).finish();
                } else {
                    List<String> fieldNames = Arrays.stream(bizDs.getRowMeta().getFieldNames()).filter(s -> !s.equals(this.getCurrencyField()) && !this.orinalAmountField().contains(s) && !"tarcurrency".equals(s) && !"rate".equals(s)).collect(Collectors.toList());
                    List<String> otherFields = fieldNames.stream().filter(v -> !this.amountFields().contains(v)).collect(Collectors.toList());
                    GroupbyDataSet groupDs = bizDs.copy().groupBy(new String[]{(String)this.getBizAndReportOrgProp().getLeft()});
                    for (String amountField : this.amountFields()) {
                        groupDs.sum(amountField);
                    }
                    bizDs = groupDs.finish().leftJoin(bizDs.select(otherFields.toArray(new String[0])).distinct()).on((String)this.getBizAndReportOrgProp().getLeft(), (String)this.getBizAndReportOrgProp().getLeft()).select(fieldNames.toArray(new String[0])).finish().distinct();
                    fieldNames.addAll(TREELIST);
                    treeDateSet = orgDataSet.leftJoin(bizDs).on("rowid", (String)this.getBizAndReportOrgProp().getLeft()).select(new HashSet<String>(fieldNames).toArray(new String[0])).finish();
                }
                treeDateSet = treeDateSet.updateFields(new String[]{"rowid", "pid", (String)this.getBizAndReportOrgProp().getRight(), this.sumField}, new String[]{"cast(rowid as String)", "cast(pid as String)", (String)this.getBizAndReportOrgProp().getRight(), "0"});
                DataSet sumDataSet = this.getSumDataSetByLevel(treeDateSet, this.amountFields(), this.getBizSelectFields(treeDateSet)).addField("1", "subsort");
                if (this.isOrgNeedAddRootNode()) {
                    DataSet subDataSet = this.getSubDataSet(treeDateSet, this.amountFields(), sumDataSet);
                    sumDataSet = sumDataSet.union(subDataSet.select(StringUtils.join((Object[])sumDataSet.getRowMeta().getFieldNames(), (String)",")));
                }
                bizDs = this.removeNoDataTreeDs(sumDataSet, this.amountFields()).orderBy(new String[]{"subsort"});
            } else {
                bizDs = bizDs.addFields(new String[]{this.uniqueRow, "'0'", "1"}, new String[]{"rowid", "pid", "level"});
            }
        } else {
            bizDs = bizDs.addFields(new String[]{this.uniqueRow, "'0'", "1"}, new String[]{"rowid", "pid", "level"});
        }
        return bizDs;
    }

    public List<Long> getQueryOrgIds(ReportQueryParam queryParam) {
        return this.getQueryOrgIds(queryParam, "filter_org", "filter_orgview");
    }

    public List<Long> getQueryOrgIds(ReportQueryParam queryParam, String orgField, String orgViewField) {
        List orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String formId = (String)queryParam.getCustomParam().get("formid");
        String appId = (String)queryParam.getCustomParam().get("appid");
        String queryWay = (String)queryParam.getFilter().getFilterItem("filter_queryway").getValue();
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)queryParam.getFilter().getFilterItem(orgViewField).getValue();
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = (List)queryParam.getFilter().getFilterItem(orgField).getValue();
                orgIds = EmptyUtil.isEmpty(orgIds) ? TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac", (boolean)true, (boolean)true) : TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIds, (boolean)true, (boolean)true);
            }
        } else {
            orgIds = (List)queryParam.getFilter().getFilterItem(orgField).getValue();
            if (EmptyUtil.isEmpty(orgIds)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
            }
            if (queryParam.getFilter().containProp("filter_isincludelower") && ((Boolean)queryParam.getFilter().getFilterItem("filter_isincludelower").getValue()).booleanValue()) {
                orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)DEFAULTORGVIEWID, orgIds, (boolean)true);
            }
        }
        return orgIds;
    }

    private String getUniqueRow() {
        StringBuilder uniqueRow = new StringBuilder(this.sumField);
        uniqueRow.append("+'_'");
        List<String> groupFields = this.groupFields();
        for (String groupField : groupFields) {
            uniqueRow.append("+'_'+").append(groupField);
        }
        return uniqueRow.toString();
    }

    protected String getBizSelectFields(DataSet bizDs) {
        String[] fields = bizDs.getRowMeta().getFieldNames();
        ArrayList<String> selectFields = new ArrayList<String>(fields.length + 1);
        for (String field : fields) {
            if (this.amountFields().contains(field) || TREELIST.contains(field) || selectFields.contains(field)) continue;
            selectFields.add(field);
        }
        selectFields.add("orgname");
        return String.join((CharSequence)",", selectFields.toArray(new String[0]));
    }

    protected DataSet addExchangeRateAndCurrencyUnit(DataSet bizDataSet, Map<String, Object> paramMap) {
        String unit = null;
        boolean isNeedCurrencyUnit = this.isNeedCurrencyUnit();
        boolean isNeedDimCurrency = this.isNeedDimCurrency();
        if (isNeedDimCurrency) {
            DataSet exchangeRateSet = this.getExChangeRateDs(bizDataSet, paramMap);
            if (isNeedCurrencyUnit) {
                unit = (String)paramMap.get("filter_currencyunit");
            }
            String[] selectFields = this.initSelectFields(bizDataSet, unit, isNeedCurrencyUnit, isNeedDimCurrency);
            return bizDataSet.leftJoin(exchangeRateSet).on(this.getCurrencyField(), "tarcurrency").select(selectFields).finish();
        }
        if (isNeedCurrencyUnit) {
            unit = (String)paramMap.get("filter_currencyunit");
            String[] selectFields = this.initSelectFields(bizDataSet, unit, isNeedCurrencyUnit, isNeedDimCurrency);
            return bizDataSet.select(selectFields);
        }
        return bizDataSet;
    }

    protected DataSet getExChangeRateDs(DataSet dataSet, Map<String, Object> paramMap) {
        Long tarCurrencyId = (Long)((DynamicObject)paramMap.get("filter_statcurrency")).getPkValue();
        DataSet currencySet = dataSet.copy().groupBy(new String[]{this.getCurrencyField()}).finish();
        ArrayList currencyIdList = new ArrayList(10);
        currencySet.iterator().forEachRemaining(v -> currencyIdList.add(v.getLong(this.getCurrencyField())));
        long orgId = 0L;
        String queryWay = (String)paramMap.get("filter_queryway");
        boolean orgQueryWay = ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay);
        if (orgQueryWay) {
            orgId = RequestContext.get().getOrgId();
        } else {
            DynamicObject orgView = (DynamicObject)paramMap.get("filter_orgview");
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgId = Long.parseLong(TmcOrgDataHelper.getOrgRootId((Long)orgView.getLong("id")));
            }
        }
        if (orgId != 0L) {
            return TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)tarCurrencyId, (long)orgId, (Date)this.getExChangeEffectdate(), (boolean)orgQueryWay);
        }
        String[] fieldNames = new String[]{"tarcurrency", "rate"};
        DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.BigDecimalType};
        return AbstractTmcTreeReportDataPlugin.createEmptyDataSet(fieldNames, dataTypes);
    }

    private String[] initSelectFields(DataSet bizDataSet, String unit, boolean isNeedCurrencyUnit, boolean isNeedDimCurrency) {
        List<String> amountFields = this.orinalAmountField();
        List<String> amountUnitFields = this.orinalUnitAmountField();
        String[] oralfields = bizDataSet.getRowMeta().getFieldNames();
        ArrayList<String> fieldList = new ArrayList<String>(oralfields.length);
        for (String field : oralfields) {
            if (fieldList.contains(field) || amountFields.contains(field) || amountUnitFields.contains(field)) continue;
            fieldList.add(field);
        }
        for (String field : amountUnitFields) {
            if (isNeedCurrencyUnit) {
                fieldList.add(String.format(field + " / %s " + field, unit));
                continue;
            }
            fieldList.add(field);
        }
        for (String field : amountFields) {
            if (!isNeedDimCurrency) continue;
            if (isNeedCurrencyUnit) {
                fieldList.add(String.format("(" + field + " * rate) / %s " + this.getReportField(field), unit));
                continue;
            }
            fieldList.add("(" + field + " * rate) " + this.getReportField(field));
        }
        if (isNeedDimCurrency) {
            fieldList.add("tarcurrency");
            fieldList.add("rate");
        }
        return fieldList.toArray(new String[0]);
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        Boolean isShowSubTotal = (Boolean)paramMap.get("filter_isshowsubtotal");
        if (isShowSubTotal.booleanValue()) {
            String subNameField = this.subNameField();
            List<String> groupFields = this.groupFields();
            DataSet subDs = this.addSubTotalDataSet(bizDs.copy().filter("pid = '0'"), groupFields, this.subAmountFields(), subNameField, this.subDisplayName()).updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"}).updateFields(new String[]{"rowid", "pid", "isgroupnode"}, new String[]{this.uniqueRow, "'0'", "'0'"});
            bizDs = bizDs.union(subDs).orderBy(this.orderByFields().toArray(new String[0]));
            if (groupFields.contains(subNameField)) {
                bizDs = bizDs.updateField(subNameField, "case when sumlevel = 1 then '" + this.subDisplayName() + "' else " + subNameField + " end");
            }
        }
        return bizDs;
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        Boolean isShowTotal = (Boolean)paramMap.get("filter_isshowtotal");
        if (isShowTotal.booleanValue()) {
            String sumNameField = this.sumNameField();
            boolean needOrgTree = this.isNeedOrgTree();
            boolean showStep = "step".equals(paramMap.get("filter_showttype"));
            DataSet totalDs = this.addAllTotalDataSet(bizDs.copy().filter(needOrgTree && this.isOrgNeedAddRootNode() && showStep ? "level=1 and subsort=1" : "level=1"), this.sumAmountFields(), null, sumNameField, this.sumDisplayName()).updateFields(new String[]{"rowid", "pid", "isgroupnode"}, new String[]{needOrgTree && showStep ? String.valueOf(DBServiceHelper.genGlobalLongId()) : this.uniqueRow + "+" + sumNameField, "0", "'0'"});
            bizDs = bizDs.union(totalDs.updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"}));
        }
        return bizDs;
    }

    private DataSet getOrgGroupDs(DataSet groupDs, DataSet orgDateSet, Pair<String, String> treeGroupField) {
        Pair<String, String> next;
        DataSet orgGroupDs = null;
        String groupIDField = (String)treeGroupField.getLeft();
        String groupTextField = (String)treeGroupField.getRight();
        while (groupDs.hasNext()) {
            next = groupDs.next();
            Object value = next.get(groupIDField);
            Object nameValue = next.get(groupTextField);
            DataSet tempDs = orgDateSet.addFields(new String[]{value.toString(), "'" + nameValue + "'"}, new String[]{groupIDField, groupTextField}).updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"}).updateFields(new String[]{"rowid", "pid"}, new String[]{"rowid+'_'+" + groupIDField, "case when pid in ('0') then pid else pid+'_'+" + groupIDField + " end"});
            orgGroupDs = orgGroupDs == null ? tempDs : orgGroupDs.union(tempDs);
        }
        if (orgGroupDs != null) {
            return orgGroupDs;
        }
        next = this.getGroupValue(groupDs.copy()).iterator().next();
        orgDateSet.addFields(new String[]{(String)next.getLeft(), "'" + (String)next.getRight() + "'"}, new String[]{groupIDField, groupTextField}).updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"}).updateFields(new String[]{"rowid", "pid"}, new String[]{"rowid+'_'+" + groupIDField, "case when pid in ('0') then pid else pid+'_'+" + groupIDField + " end"});
        return orgDateSet;
    }

    private Set<Pair<String, String>> getGroupValue(DataSet groupDs) {
        HashSet<Pair<String, String>> currencyIds = new HashSet<Pair<String, String>>();
        groupDs.forEach(o -> currencyIds.add(Pair.of((Object)o.get((String)this.treeGroupField().getLeft()).toString(), (Object)o.get((String)this.treeGroupField().getRight()).toString())));
        return currencyIds;
    }

    public DataSet getBaseDataSetOfChilds(Set<Long> bankIds, String entityName, String parentField) {
        return QueryServiceHelper.queryDataSet((String)("getBaseDataSetOfChilds_" + entityName), (String)entityName, (String)("id,name," + parentField + " pid"), (QFilter[])new QFilter[]{new QFilter("id", "in", bankIds)}, null).addField("id", "rowid").addField("case when pid=0 then '1' else '0' end ", "isgroupnode").addField("case when pid=0 then 1 else 2 end ", "level");
    }

    public static DataSet getBaseDataSetOfParent(Set<Long> Ids, String entityName) {
        return QueryServiceHelper.queryDataSet((String)("getBaseDataSetOfParent_" + entityName), (String)entityName, (String)"id, id rowid,name,0 pid", (QFilter[])new QFilter[]{new QFilter("id", "in", Ids)}, null).addField("'1'", "isgroupnode").addField("1", "level");
    }

    public DataSet rebuildRowIDAndPId(DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        boolean needRebuildRowid = false;
        for (Field field : fields) {
            if (!"rowid".equals(field.getName())) continue;
            needRebuildRowid = field.getDataType() instanceof StringType;
            break;
        }
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        if (needRebuildRowid) {
            long time = System.nanoTime();
            DataSetBuilder dsBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(dataSet.getRowMeta());
            for (Row row : dataSet) {
                Long newPid;
                Long newRowid;
                String oldRowid = row.getString("rowid");
                if (!map.containsKey(oldRowid)) {
                    newRowid = DBServiceHelper.genGlobalLongId();
                    map.put(oldRowid, newRowid);
                } else {
                    newRowid = (Long)map.get(oldRowid);
                }
                String oldpid = row.getString("pid");
                if (!"0".equals(oldpid) && !map.containsKey(oldpid)) {
                    newPid = DBServiceHelper.genGlobalLongId();
                    map.put(oldpid, newPid);
                } else {
                    newPid = map.get(oldpid) == null ? Long.valueOf(0L) : (Long)map.get(oldpid);
                }
                Object[] data = new Object[fields.length];
                for (int i = 0; i < fieldNames.length; ++i) {
                    data[i] = "rowid".equals(fieldNames[i]) ? newRowid : ("pid".equals(fieldNames[i]) ? newPid : row.get(fieldNames[i]));
                }
                dsBuilder.append(data);
            }
            DataSet build = dsBuilder.build();
            logger.info("\u65b9\u6cd5\u8017\u65f6\uff1a" + (System.nanoTime() - time) / 1000L / 1000L);
            return build;
        }
        return dataSet;
    }

    public abstract DataSet queryDataSet(ReportQueryParam var1);

    protected String getCurrencyField() {
        return "currency";
    }

    protected List<String> orinalAmountField() {
        return Collections.singletonList("amount");
    }

    protected List<String> orinalUnitAmountField() {
        return this.orinalAmountField();
    }

    protected String getReportField(String field) {
        return field + "_report";
    }

    protected Date getExChangeEffectdate() {
        return new Date();
    }

    protected boolean isNeedOrgTree() {
        return false;
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    protected boolean isNeedDimCurrency() {
        return true;
    }

    protected boolean isNeedCurrencyUnit() {
        return true;
    }

    public List<String> groupFields() {
        return new ArrayList<String>();
    }

    public List<String> orderByFields() {
        List<String> orderByField = this.groupFields();
        orderByField.add(this.sumField);
        return orderByField;
    }

    public List<String> subAmountFields() {
        return this.sumAmountFields();
    }

    public List<String> sumAmountFields() {
        return new ArrayList<String>(10);
    }

    public String sumNameField() {
        return (String)this.getBizAndReportOrgProp().getRight();
    }

    public String sumDisplayName() {
        return ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AbstractTmcTreeReportDataPlugin_1", (String)"tmc-fbp-report", (Object[])new Object[0]);
    }

    public String subNameField() {
        return this.sumNameField();
    }

    public String subDisplayName() {
        return ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AbstractTmcTreeReportDataPlugin_0", (String)"tmc-fbp-report", (Object[])new Object[0]);
    }

    public List<String> amountFields() {
        return this.sumAmountFields();
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)"orgtext");
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        return dataSet;
    }

    public Pair<String, String> treeGroupField() {
        return null;
    }
}

