/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.opplugin.transbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fca.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.fca.business.validate.transbill.SyncBankBillStatusValidator;

public class TransBillPaySyncBankBillStatusOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(TransBillPaySyncBankBillStatusOp.class);
    private List<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entrys.paychanel");
        e.getFieldKeys().add("entrys.paystatus");
        e.getFieldKeys().add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SyncBankBillStatusValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] payBillArr = e.getDataEntities();
        Map<Long, DynamicObject> payBillIdMap = Arrays.stream(payBillArr).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        String entityName = "";
        String beiEntityName = "";
        if (payBillArr.length > 0) {
            entityName = payBillArr[0].getDataEntityType().getName();
            beiEntityName = "fca_transupbill".equals(entityName) ? "bei_banktransupbill" : "bei_banktransdownbill";
        }
        if (EmptyUtil.isEmpty((String)entityName)) {
            return;
        }
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"ebService", (String)"sync", (Object[])new Object[]{beiEntityName, SerializationUtils.toJsonString(payBillIdMap.keySet())});
        logger.info("PaymentPaySyncBankBillStatusOp ebService sync return:  {}", (Object)resultStr);
        List syncInfoList = (List)JSON.parseObject((String)resultStr, (TypeReference)new TypeReference<List<SyncStatusInfo>>(){}, (Feature[])new Feature[0]);
        for (SyncStatusInfo syncStatusInfo : syncInfoList) {
            DynamicObject payBill;
            SyncStatusResult syncResult = EBServiceFacadeFactory.getBankService().syncPayBillStatus(entityName, syncStatusInfo);
            if (EBResultStatusCode.ROLLBACK != syncResult.getStatusCode() && EBResultStatusCode.ERROR != syncResult.getStatusCode() || (payBill = payBillIdMap.get(syncStatusInfo.getPayBillId())) == null) continue;
            logger.info("PaymentPaySyncBankBillStatusOp syncPayBillStatus syncResult:  {}", (Object)syncResult);
            if (!EmptyUtil.isNoEmpty((String)syncResult.getErrMsg())) continue;
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, payBill.getPkValue(), (Object)payBill.getDynamicObjectType().getName());
            operateErrorInfo.setMessage(payBill.get("billno") + ":" + syncResult.getErrMsg());
            this.errorInfoList.add(operateErrorInfo);
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        for (OperateErrorInfo operateErrorInfo : this.errorInfoList) {
            e.getOperationResult().addErrorInfo(operateErrorInfo);
        }
    }
}

