/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SplitThreadOperationExecutor<T, R> {
    private static final Log LOGGER = LogFactory.getLog(SplitThreadOperationExecutor.class);
    private static final int MaxThreadNum = 3;

    public List<R> doBatchOperation(List<T> dataList, int pageSize, Operation<T, R> operation) {
        LOGGER.info("SplitThreadOperationExecutor begin");
        int totalSize = dataList.size() / pageSize;
        if (totalSize > 3) {
            pageSize = dataList.size() / 3;
            pageSize = dataList.size() / 3 == 0 ? pageSize : pageSize + 1;
            totalSize = dataList.size() / pageSize;
        }
        totalSize = dataList.size() % pageSize == 0 ? totalSize : totalSize + 1;
        List<Object> resultList = new ArrayList();
        ArrayList<Future> futureList = new ArrayList<Future>(totalSize);
        if (totalSize > 1) {
            for (int pageNum = 0; pageNum < totalSize; ++pageNum) {
                int fromIndex = pageSize * pageNum;
                int toIndex = pageSize * (pageNum + 1);
                List splitDataList = dataList.subList(fromIndex, Math.min(toIndex, dataList.size()));
                RequestContext context = RequestContext.get();
                Future future = ThreadService.submit(() -> {
                    RequestContext.copyAndSet((RequestContext)context);
                    return operation.doOperation(splitDataList);
                }, (TaskType)TaskType.CAS_SPLIT_TASK);
                futureList.add(future);
            }
            for (Future future : futureList) {
                try {
                    List results = (List)future.get();
                    if (results == null) continue;
                    resultList.addAll(results);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error("SplitThreadOperationExecutor error:", (Throwable)e);
                    Thread.currentThread().interrupt();
                    throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                }
            }
        } else if (totalSize == 1) {
            resultList = operation.doOperation(dataList);
        }
        return resultList;
    }

    public static interface Operation<T, R> {
        public List<R> doOperation(List<T> var1);
    }
}

