/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fca.common.convert.IBillTranslateMapper;
import kd.tmc.fca.common.helper.DynamicObjectHelper;
import kd.tmc.fca.common.util.ComboKey;
import kd.tmc.fca.common.util.EntityMetadataUtils;
import kd.tmc.fca.common.util.NumberUtils;

public abstract class AbstractBillConverter
implements IBillTranslateMapper {
    protected abstract Map<String, String> getMapper();

    public DynamicObject convertToTargetBill(DynamicObject sourceBill) {
        MainEntityType targetDataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getTargetEntityKey());
        long pk = DB.genLongId((String)targetDataEntityType.getAlias());
        DynamicObject targetBill = new DynamicObject((DynamicObjectType)targetDataEntityType, (Object)pk);
        Map<String, String> fieldMapper = this.getMapper();
        MainEntityType sourceDataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getSourceEntityKey());
        boolean containsSourceEntry = EntityMetadataUtils.containsEntryField(fieldMapper.keySet(), sourceDataEntityType);
        boolean containsTargetEntry = EntityMetadataUtils.containsEntryField(fieldMapper.values(), targetDataEntityType);
        DynamicObjectCollection sourceEntry = new DynamicObjectCollection();
        if (containsSourceEntry) {
            sourceEntry = sourceBill.getDynamicObjectCollection(EntityMetadataUtils.getEntryProp((IDataEntityType)sourceDataEntityType).getName());
        }
        DynamicObjectType targetEntryDt = null;
        DynamicObjectCollection targetEntry = new DynamicObjectCollection();
        if (containsTargetEntry) {
            targetEntryDt = ((EntryProp)targetDataEntityType.getProperty(EntityMetadataUtils.getEntryProp((IDataEntityType)targetDataEntityType).getName())).getDynamicCollectionItemPropertyType();
            targetEntry = targetBill.getDynamicObjectCollection(EntityMetadataUtils.getEntryProp((IDataEntityType)targetDataEntityType).getName());
        }
        HashMap<DynamicObject, DynamicObject> entryMapper = new HashMap<DynamicObject, DynamicObject>();
        for (Map.Entry<String, String> mapEntry : fieldMapper.entrySet()) {
            String sourceFieldName = mapEntry.getKey();
            String targetFieldName = mapEntry.getValue();
            if (containsTargetEntry && EntityMetadataUtils.isEntryField(sourceDataEntityType, sourceFieldName)) {
                for (DynamicObject sEntryRow : sourceEntry) {
                    DynamicObject targetRow = (DynamicObject)entryMapper.get(sEntryRow);
                    if (targetRow == null) {
                        targetRow = new DynamicObject(targetEntryDt);
                        entryMapper.put(sEntryRow, targetRow);
                        targetEntry.add((Object)targetRow);
                        targetRow.set("seq", (Object)targetEntry.size());
                    }
                    targetRow.set(targetFieldName, DynamicObjectHelper.getValue(sEntryRow, sourceFieldName));
                }
                continue;
            }
            targetBill.set(targetFieldName, DynamicObjectHelper.getValue(sourceBill, sourceFieldName));
        }
        return targetBill;
    }

    public List<DynamicObject> convertToTargetBills(DynamicObject ... sourceBills) {
        List<String> groupByFields = this.getGroupFields();
        HashMap<ComboKey, ArrayList<DynamicObject>> groupedSourceBills = new HashMap<ComboKey, ArrayList<DynamicObject>>();
        for (DynamicObject bill : sourceBills) {
            ComboKey comboKey = new ComboKey(new Object[0]);
            for (String field : groupByFields) {
                Object temValue = DynamicObjectHelper.getValue(bill, field);
                if (temValue instanceof DynamicObject) {
                    comboKey.addKey(((DynamicObject)temValue).getPkValue());
                    continue;
                }
                comboKey.addKey(temValue);
            }
            ArrayList<DynamicObject> list2 = (ArrayList<DynamicObject>)groupedSourceBills.get(comboKey);
            if (list2 == null) {
                list2 = new ArrayList<DynamicObject>();
                groupedSourceBills.put(comboKey, list2);
            }
            list2.add(bill);
        }
        List<String> summaryFields = this.getSummaryFields();
        ArrayList<DynamicObject> targetBills = new ArrayList<DynamicObject>();
        groupedSourceBills.values().forEach(list -> {
            DynamicObject targetBill = this.convertToTargetBill((DynamicObject)list.get(0));
            HashMap<String, Number> summaryResult = new HashMap<String, Number>();
            for (DynamicObject bill : list) {
                for (String f : summaryFields) {
                    Object value2 = bill.get(f);
                    if (!(value2 instanceof Number)) {
                        throw new RuntimeException(ResManager.loadKDString((String)"\u53ea\u6709\u6570\u503c\u7c7b\u578b\u7684\u624d\u80fd\u5408\u8ba1\u3002", (String)"AbstractBillConverter_1", (String)"tmc-fca-common", (Object[])new Object[0]));
                    }
                    Number number = (Number)summaryResult.get(f);
                    number = number == null ? (Number)((Number)value2) : (Number)NumberUtils.sum(number, (Number)value2);
                    summaryResult.put(f, number);
                }
            }
            summaryResult.forEach((key, value) -> targetBill.set(this.getTargetField((String)key), value));
            targetBills.add(targetBill);
        });
        return targetBills;
    }

    @Override
    public Collection<String> getAllSourceFields() {
        return new ArrayList<String>(this.getMapper().keySet());
    }

    @Override
    public List<String> getGroupFields() {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getSummaryFields() {
        return new ArrayList<String>();
    }
}

