/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.helper;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fca.common.helper.TransBillHelper;

public class AcctGroupRelInnerAcctHelper {
    private static final String number = "BC-9999";

    public static void fillInnerAccounts(DynamicObject acctGroup) {
        if (acctGroup == null) {
            return;
        }
        DynamicObjectCollection rows = acctGroup.getDynamicObjectCollection("entrys");
        DynamicObject company = acctGroup.getDynamicObject("company");
        DynamicObject currency = acctGroup.getDynamicObject("currency");
        if (company != null && currency != null) {
            Set<Object> bankAccountIds = rows.stream().filter(r -> r.getDynamicObject("bankacct") != null).map(r -> (Long)r.getDynamicObject("bankacct").getPkValue()).collect(Collectors.toSet());
            Map<Object, Map<Object, DynamicObject>> orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
            for (DynamicObject row : rows) {
                DynamicObjectCollection currencies;
                List currencyIdList;
                row.set("inneracct", null);
                if (row.getDynamicObject("bankacct") == null || !orgInnerAccountMap.containsKey(company.getPkValue())) continue;
                DynamicObject innerAccount = orgInnerAccountMap.get(company.getPkValue()).get(row.getDynamicObject("bankacct").getPkValue());
                if (innerAccount != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                    innerAccount = null;
                }
                row.set("inneracct", (Object)innerAccount);
            }
        }
    }

    public static void fillInnerAccounts(IDataModel model) {
        DynamicObjectCollection rows = model.getEntryEntity("entrys");
        DynamicObject company = (DynamicObject)model.getValue("company");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (company != null && currency != null) {
            Set<Object> bankAccountIds = rows.stream().filter(r -> r.getDynamicObject("bankacct") != null).map(r -> (Long)r.getDynamicObject("bankacct").getPkValue()).collect(Collectors.toSet());
            Map<Object, Map<Object, DynamicObject>> orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObjectCollection currencies;
                List currencyIdList;
                DynamicObject row = (DynamicObject)rows.get(i);
                DynamicObject bankAcct = row.getDynamicObject("bankacct");
                row.set("inneracct", null);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"inneracct", null, (int)i);
                if (bankAcct == null || !orgInnerAccountMap.containsKey(company.getPkValue())) continue;
                DynamicObject innerAccount = orgInnerAccountMap.get(company.getPkValue()).get(row.getDynamicObject("bankacct").getPkValue());
                if (innerAccount != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                    innerAccount = null;
                }
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"inneracct", (Object)innerAccount, (int)i);
            }
        }
    }

    public static QFilter virtualAcctQfNew() {
        DynamicObject bdType = QueryServiceHelper.queryOne((String)"bd_bankcgsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (bdType != null) {
            return new QFilter("bank.bank_cate.id", "!=", (Object)bdType.getLong("id")).and(new QFilter("isvirtual", "=", (Object)"0"));
        }
        return new QFilter("isvirtual", "=", (Object)"0");
    }
}

