/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fca.common.bridge.MultiLangEnumBridge;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayChanEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.helper.AmtCalcHelper;
import kd.tmc.fca.common.helper.TransBillHelper;
import kd.tmc.fca.common.util.AmtUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AmtValidateHelper {
    private static Log logger = LogFactory.getLog(AmtValidateHelper.class);

    public static boolean needValidate(DynamicObject entryData, String opKey) {
        Object state = entryData.get("state");
        Object payStatus = entryData.get("paystatus");
        String payChanel = entryData.getString("paychanel");
        if (FcaTransDetailStatusEnum.DISCARD.getValue().equals(state)) {
            return false;
        }
        if (!FcaTransPayStatusEnum.INIT.getValue().equals(payStatus) && !FcaTransPayStatusEnum.PAYFAIL.getValue().equals(payStatus)) {
            return false;
        }
        if (opKey == null) {
            return true;
        }
        if ("barpaybei".equals(opKey) && FcaTransPayChanEnum.BEI.getValue().equals(payChanel)) {
            return true;
        }
        return "barpayconfirm".equals(opKey) && (FcaTransPayChanEnum.ONLINE.getValue().equals(payChanel) || FcaTransPayChanEnum.COUNTER.getValue().equals(payChanel));
    }

    public static Pair<ValidStatus, String> validTransUpSubAcctAmt(DynamicObject transBill, DynamicObject entryData, boolean isPay) {
        DynamicObject subAcct = entryData.getDynamicObject("subacct");
        return AmtValidateHelper.isTransBillValid(transBill, subAcct, entryData, AcctType.TYPE_SUBACCT, isPay);
    }

    public static Pair<ValidStatus, String> validTransDownSubInnerAcctAmt(DynamicObject transBill, DynamicObject entryData, boolean isPay) {
        DynamicObject subAcct = entryData.getDynamicObject("subacct");
        DynamicObject company = transBill.getDynamicObject("company");
        DynamicObject currency = transBill.getDynamicObject("currency");
        HashSet<Object> bankAccountIds = new HashSet<Object>(1);
        bankAccountIds.add(subAcct.getPkValue());
        Map<Object, Map<Object, DynamicObject>> orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
        DynamicObject subRefAcctBank = null;
        if (orgInnerAccountMap.containsKey(company.getPkValue())) {
            DynamicObjectCollection currencies;
            List currencyIdList;
            DynamicObject innerAccount = orgInnerAccountMap.get(company.getPkValue()).get(subAcct.getPkValue());
            if (innerAccount != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                innerAccount = null;
            }
            if (innerAccount != null) {
                subRefAcctBank = TmcAccountHelper.getBankAcctByInnerAcct((DynamicObject)innerAccount);
            }
        }
        if (subRefAcctBank == null) {
            return Pair.of((Object)((Object)ValidStatus.SUCCESS), null);
        }
        return AmtValidateHelper.isTransBillValid(transBill, subRefAcctBank, entryData, AcctType.TYPE_INNERACCT, isPay);
    }

    public static Pair<ValidStatus, String> validTransDownAcctAmt(DynamicObject transBill, DynamicObject entryData, boolean isPay) {
        DynamicObject acct = transBill.getDynamicObject("accountbank");
        return AmtValidateHelper.isTransBillValid(transBill, acct, null, AcctType.TYPE_ACCT, isPay);
    }

    public static Pair<ValidStatus, String> validTransUpApplySubAcctAmt(DynamicObject transBillApply, DynamicObject entryData, boolean isAudit) {
        DynamicObject acct = entryData.getDynamicObject("subacct");
        return AmtValidateHelper.isTransBillApplyValid(transBillApply, acct, entryData, AcctType.TYPE_SUBACCT, isAudit);
    }

    public static Pair<ValidStatus, String> validTransDownApplyInnerAcctAmt(DynamicObject transBillApply, DynamicObject entryData, boolean isAudit) {
        DynamicObject subAcct = entryData.getDynamicObject("subacct");
        if (subAcct == null) {
            return Pair.of((Object)((Object)ValidStatus.SUCCESS), null);
        }
        DynamicObject subInnerAcct = subAcct.getDynamicObject("inneracct");
        if (subInnerAcct == null) {
            return Pair.of((Object)((Object)ValidStatus.SUCCESS), null);
        }
        DynamicObject subInnerAcctBank = TmcAccountHelper.getBankAcctByInnerAcct((DynamicObject)subInnerAcct);
        return AmtValidateHelper.isTransBillApplyValid(transBillApply, subInnerAcctBank, entryData, AcctType.TYPE_SUBACCT, isAudit);
    }

    private static Pair<ValidStatus, String> isTransBillValid(DynamicObject transBill, DynamicObject acct, DynamicObject entryData, AcctType acctType, boolean isPay) {
        boolean isAcct = AcctType.TYPE_ACCT == acctType;
        DynamicObject currency = transBill.getDynamicObject("currency");
        BigDecimal amt = isAcct ? transBill.getBigDecimal("amount") : entryData.getBigDecimal("transamt");
        return AmtValidateHelper.isValid(acct, amt, currency, acctType, isPay);
    }

    private static Pair<ValidStatus, String> isTransBillApplyValid(DynamicObject transBillApply, DynamicObject acct, DynamicObject entryData, AcctType acctType, boolean isAudit) {
        DynamicObject currency = transBillApply.getDynamicObject("currency");
        BigDecimal amt = isAudit ? entryData.getBigDecimal("transamt") : entryData.getBigDecimal("applyamt");
        return AmtValidateHelper.isValid(acct, amt, currency, acctType, false);
    }

    public static DynamicObject getStrategy(DynamicObject accountGroup, DynamicObject subAcct) {
        if (accountGroup == null || subAcct == null) {
            return null;
        }
        logger.info("AmtValidateHelper.getStrategy: acctGrp:{}", accountGroup.getPkValue());
        DynamicObject strategy = accountGroup.getDynamicObjectCollection("entrys").stream().filter(o -> o.getDynamicObject("bankacct") != null && o.getDynamicObject("bankacct").getPkValue().equals(subAcct.getPkValue())).findFirst().map(o -> o.getDynamicObject("transtrategy")).orElse(null);
        if (strategy != null) {
            logger.info("AmtValidateHelper.getStrategy: stratg:{}", strategy.getPkValue());
            strategy = TmcDataServiceHelper.loadSingleFromCache((Object)strategy.getPkValue(), (String)"fca_transtrategy");
        }
        return strategy;
    }

    public static Pair<ValidStatus, String> isValid(DynamicObject bankAcct, BigDecimal amt, DynamicObject currency, AcctType acctType, boolean isPay) {
        Long currencyId;
        DynamicObject bankStratg;
        if (acctType == null) {
            acctType = AcctType.TYPE_OTHERACCT;
        }
        if ((bankStratg = AmtCalcHelper.getAcctStratg(bankAcct, currencyId = (Long)currency.getPkValue())) == null) {
            return Pair.of((Object)((Object)ValidStatus.SUCCESS), (Object)"");
        }
        boolean isOpenBei = bankAcct.getBoolean("issetbankinterface");
        BigDecimal balance = AmtCalcHelper.getA_CurrBalance(bankAcct, currencyId);
        BigDecimal b = AmtCalcHelper.getB_OverdrawBalance(bankStratg);
        BigDecimal c = AmtCalcHelper.getC_PayingAmt_1(bankAcct, currencyId, isPay);
        BigDecimal d = AmtCalcHelper.getD_MinRemainedAmt(bankStratg);
        BigDecimal am1 = balance.subtract(c).subtract(d);
        BigDecimal am2 = balance.add(b).subtract(c).subtract(d);
        boolean isAm2Valid = am2.compareTo(amt) < 0;
        boolean isAm1Valid = am1.compareTo(amt) < 0;
        logger.info("AmtValidateHelper.isValid method:  balance:" + balance + " b:" + b + " c:" + c + " d:" + d + " am1:" + am1 + " am2:" + am2 + " isAm2Valid:" + isAm2Valid + " isAm1Valid:" + isAm1Valid);
        if (!isAm2Valid && !isAm1Valid) {
            return Pair.of((Object)((Object)ValidStatus.SUCCESS), (Object)"");
        }
        BigDecimal[] acctAm2Arr = Arrays.asList(am2, balance, b, c, d, am1).toArray(new BigDecimal[0]);
        Pair<ValidStatus, String> msgPair = AmtValidateHelper.getAmValidMessage(bankAcct, currency, acctAm2Arr, acctType, isAm2Valid, isAm1Valid, isPay, isOpenBei);
        logger.info("AmtValidateHelper.isValid method:  Left:" + ((ValidStatus)((Object)msgPair.getLeft())).getValue() + " Right:" + (String)msgPair.getRight());
        return msgPair;
    }

    private static Pair<ValidStatus, String> getAmValidMessage(DynamicObject bankAcct, DynamicObject currency, BigDecimal[] amtArr, AcctType acctType, boolean isAm2, boolean isAm1, boolean isPay, boolean isOpenBei) {
        boolean isAcct = AcctType.TYPE_ACCT == acctType || AcctType.TYPE_OTHERACCT == acctType;
        String acctNum = bankAcct.getString("bankaccountnumber");
        String currencySign = currency.getString("sign");
        int amtprecision = currency.getInt("amtprecision");
        DynamicObject stratg = AmtCalcHelper.getAcctStratg(bankAcct, (Long)currency.getPkValue());
        if (stratg == null && !isPay) {
            Pair.of((Object)((Object)ValidStatus.SUCCESS), (Object)"");
        }
        String balanceMsg = ResManager.loadKDString((String)"\u8d26\u9762\u4f59\u989d", (String)"AmtValidateHelper_3", (String)"tmc-fca-common", (Object[])new Object[0]);
        if (isOpenBei) {
            balanceMsg = ResManager.loadKDString((String)"\u94f6\u884c\u4f59\u989d", (String)"AmtValidateHelper_4", (String)"tmc-fca-common", (Object[])new Object[0]);
        }
        boolean submitCtrl = false;
        boolean isConfirm = false;
        if (stratg != null) {
            submitCtrl = stratg.getBoolean("issubmit");
            isConfirm = stratg.getBoolean("isoverworn");
        }
        String msg01 = ResManager.loadKDString((String)"\u201c%1$s\uff08%2$s\uff09\u201d\u900f\u652f\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c \u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"AmtValidateHelper_5", (String)"tmc-fca-common", (Object[])new Object[0]) + ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u53ef\u7528\u91d1\u989d\uff08%3$s\uff09= ", (String)"AmtValidateHelper_6", (String)"tmc-fca-common", (Object[])new Object[0]) + balanceMsg + ResManager.loadKDString((String)"\uff08%4$s\uff09+ \u900f\u652f\u989d\u5ea6\uff08%5$s\uff09- \u5728\u9014\u8d44\u91d1\uff08%6$s\uff09- \u6700\u4f4e\u7559\u5b58\u91d1\u989d\uff08%7$s\uff09", (String)"AmtValidateHelper_7", (String)"tmc-fca-common", (Object[])new Object[0]);
        String msg02 = isPay ? ResManager.loadKDString((String)"\u4ed8\u6b3e\u5931\u8d25\u3002\u201c%1$s\uff08%2$s\uff09\u201d\u900f\u652f\u68c0\u67e5\u672a\u901a\u8fc7\u3002", (String)"AmtValidateHelper_8", (String)"tmc-fca-common", (Object[])new Object[0]) + ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u53ef\u7528\u91d1\u989d\uff08%3$s\uff09=", (String)"AmtValidateHelper_9", (String)"tmc-fca-common", (Object[])new Object[0]) + balanceMsg + ResManager.loadKDString((String)"\uff08%4$s\uff09+\u900f\u652f\u989d\u5ea6\uff08%5$s\uff09-\u5728\u9014\u8d44\u91d1\uff08%6$s\uff09-\u6700\u4f4e\u7559\u5b58\u91d1\u989d\uff08%7$s\uff09", (String)"AmtValidateHelper_10", (String)"tmc-fca-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c%1$s\uff08%2$s\uff09\u900f\u652f\u68c0\u67e5\u4e0d\u901a\u8fc7\u3002", (String)"AmtValidateHelper_11", (String)"tmc-fca-common", (Object[])new Object[0]) + ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u53ef\u7528\u91d1\u989d\uff08%3$s\uff09=", (String)"AmtValidateHelper_9", (String)"tmc-fca-common", (Object[])new Object[0]) + balanceMsg + ResManager.loadKDString((String)"\uff08%4$s\uff09+\u900f\u652f\u989d\u5ea6\uff08%5$s\uff09-\u5728\u9014\u8d44\u91d1\uff08%6$s\uff09-\u6700\u4f4e\u7559\u5b58\u91d1\u989d\uff08%7$s\uff09", (String)"AmtValidateHelper_10", (String)"tmc-fca-common", (Object[])new Object[0]);
        String msg03 = ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u900f\u652f\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u9700\u8981\u81ea\u52a8\u4f5c\u5e9f\u8be5\u660e\u7ec6\u884c\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"AmtValidateHelper_12", (String)"tmc-fca-common", (Object[])new Object[0]) + ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u53ef\u7528\u91d1\u989d\uff08%3$s\uff09= ", (String)"AmtValidateHelper_6", (String)"tmc-fca-common", (Object[])new Object[0]) + balanceMsg + ResManager.loadKDString((String)"\uff08%4$s\uff09+ \u900f\u652f\u989d\u5ea6\uff08%5$s\uff09- \u5728\u9014\u8d44\u91d1\uff08%6$s\uff09 - \u6700\u4f4e\u7559\u5b58\u91d1\u989d\uff08%7$s\uff09", (String)"AmtValidateHelper_13", (String)"tmc-fca-common", (Object[])new Object[0]);
        String msg = "";
        ValidStatus validStatus = ValidStatus.SUCCESS;
        if (isAm2) {
            if (isPay) {
                if (isAcct) {
                    msg = msg02;
                    validStatus = ValidStatus.ERROR;
                } else {
                    msg = msg03;
                    validStatus = ValidStatus.CONFIRM;
                }
            } else if (submitCtrl) {
                msg = msg02;
                validStatus = ValidStatus.ERROR;
            } else {
                msg = msg01;
                validStatus = ValidStatus.CONFIRM;
            }
            msg = String.format(msg, acctType.getType(), acctNum, AmtUtil.getFormatAmt(amtArr[0], currencySign, amtprecision), AmtUtil.getFormatAmt(amtArr[1], currencySign, amtprecision), AmtUtil.getFormatAmt(amtArr[2], currencySign, amtprecision), AmtUtil.getFormatAmt(amtArr[3], currencySign, amtprecision), AmtUtil.getFormatAmt(amtArr[4], currencySign, amtprecision));
        } else if (isConfirm && (isPay || submitCtrl) && isAm1) {
            msg = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u5c06\u53d1\u751f\u989d\u5ea6\u5185\u900f\u652f\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"AmtValidateHelper_14", (String)"tmc-fca-common", (Object[])new Object[0]) + ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u53ef\u7528\u91d1\u989d\uff08%3$s\uff09=", (String)"AmtValidateHelper_9", (String)"tmc-fca-common", (Object[])new Object[0]) + balanceMsg + ResManager.loadKDString((String)"\uff08%4$s\uff09-\u5728\u9014\u8d44\u91d1\uff08%5$s\uff09-\u6700\u4f4e\u7559\u5b58\u91d1\u989d\uff08%6$s\uff09", (String)"AmtValidateHelper_15", (String)"tmc-fca-common", (Object[])new Object[0]), acctType.getType(), acctNum, AmtUtil.getFormatAmt(amtArr[5], currencySign, amtprecision), AmtUtil.getFormatAmt(amtArr[1], currencySign, amtprecision), AmtUtil.getFormatAmt(amtArr[3], currencySign, amtprecision), AmtUtil.getFormatAmt(amtArr[4], currencySign, amtprecision));
            validStatus = ValidStatus.CONFIRM;
        }
        return Pair.of((Object)((Object)validStatus), (Object)msg);
    }

    private static enum AcctType {
        TYPE_SUBACCT(new MultiLangEnumBridge("\u5b50\u8d26\u6237", "AmtValidateHelper_0", "tmc-fca-common")),
        TYPE_INNERACCT(new MultiLangEnumBridge("\u5b50\u8d26\u6237\u5185\u90e8\u8d26\u6237", "AmtValidateHelper_1", "tmc-fca-common")),
        TYPE_ACCT(new MultiLangEnumBridge("\u6bcd\u8d26\u6237", "AmtValidateHelper_2", "tmc-fca-common")),
        TYPE_OTHERACCT(new MultiLangEnumBridge("\u8d26\u6237", "AmtValidateHelper_16", "tmc-fca-common"));

        private MultiLangEnumBridge type;

        private AcctType(MultiLangEnumBridge type) {
            this.type = type;
        }

        public String getType() {
            return this.type.loadKDString();
        }
    }

    public static enum ValidStatus {
        SUCCESS("SUCCESS", "SUCCESS"),
        ERROR("ERROR", "ERROR"),
        CONFIRM("CONFIRM", "CONFIRM"),
        INFO("INFO", "INFO");

        private String name;
        private String value;

        private ValidStatus(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static String getName(String value) {
            String name = null;
            for (ValidStatus status : ValidStatus.values()) {
                if (!status.getValue().equals(value)) continue;
                name = status.name;
                break;
            }
            return name;
        }

        public boolean isSuccess() {
            return this == SUCCESS;
        }
    }
}

