/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertServiceHelper;

public class FcaBotpHelper {
    private static final Log logger = LogFactory.getLog(FcaBotpHelper.class);

    public static DynamicObject[] push(DynamicObject[] srcBills, String targetEntity) {
        return FcaBotpHelper.push("", Arrays.stream(srcBills).map(DataEntityBase::getPkValue).toArray(), srcBills[0].getDataEntityType().getName(), targetEntity);
    }

    public static DynamicObject[] push(String ruleId, Object[] ids, String sourceEntity, String targetEntity) {
        ConvertOperationResult pushResult = FcaBotpHelper.pushPage(ruleId, ids, sourceEntity, targetEntity);
        if (!pushResult.isSuccess()) {
            String errMessage = pushResult.getMessage();
            logger.error("FcaBotpHelper.push pushresult error:" + errMessage);
            ErrorCode ec = new ErrorCode("", errMessage);
            throw new KDBizException(ec, new Object[0]);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)targetEntity);
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        return targetBillObjs.toArray(new DynamicObject[0]);
    }

    public static ConvertOperationResult pushPage(String ruleId, Object[] ids, String sourceEntity, String targetEntity) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceEntity);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setHasRight(true);
        pushArgs.setAppId("");
        pushArgs.setDefOrgId(Long.valueOf(0L));
        pushArgs.setRuleId(ruleId);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(ids.length);
        for (Object id : ids) {
            selectedRows.add(new ListSelectedRow(id));
        }
        pushArgs.setSelectedRows(selectedRows);
        return ConvertServiceHelper.push((PushArgs)pushArgs);
    }

    public static DynamicObject[] pushBySpecifiedEntry(DynamicObject[] srcBills, String entryPropName, Set<Object> entryIdSet, String targetEntity) {
        PushArgs pushArgs = new PushArgs();
        String srcEntityName = srcBills[0].getDataEntityType().getName();
        pushArgs.setSourceEntityNumber(srcEntityName);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setHasRight(true);
        pushArgs.setAppId("");
        pushArgs.setDefOrgId(Long.valueOf(0L));
        pushArgs.setRuleId("");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject srcBill : srcBills) {
            DynamicObjectCollection entries = srcBill.getDynamicObjectCollection(entryPropName);
            for (DynamicObject entry : entries) {
                if (!entryIdSet.contains(entry.getPkValue())) continue;
                ListSelectedRow row = new ListSelectedRow((Object)srcBill.getLong("id"));
                row.setEntryEntityKey("entrys");
                row.setEntryPrimaryKeyValue(entry.getPkValue());
                selectedRows.add(row);
            }
        }
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            String errMessage = pushResult.getMessage();
            logger.error("FcaBotpHelper.push pushresult error:" + errMessage);
            ErrorCode ec = new ErrorCode("", errMessage);
            throw new KDException(ec, new Object[0]);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)targetEntity);
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        return targetBillObjs.toArray(new DynamicObject[0]);
    }

    public static Long getTableIdByEntityId(String entityId) {
        Object[] parameters = new SqlParameter[1];
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId, FEntityKey, FTableId ");
        sBuilder.append("FROM T_META_EntityInfo ");
        sBuilder.append("WHERE FEntityId = ? ");
        parameters[0] = new SqlParameter(":FEntityId", 12, (Object)entityId);
        ResultSetHandler action = rs -> {
            TableDefine tableDefine = null;
            if (rs.next()) {
                tableDefine = new TableDefine();
                tableDefine.setEntityNumber(rs.getString("FId"));
                tableDefine.setEntityKey(entityId);
                tableDefine.setTableId(Long.valueOf(rs.getLong("FTableId")));
            }
            return tableDefine;
        };
        TableDefine tableDefine = (TableDefine)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        return tableDefine.getTableId();
    }
}

