/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;

public class HandLinkBillHelper {
    public static Set<Long> showBotpRtansDetails(ListSelectedRowCollection selectedRows, String entityId) {
        HashSet<Long> idsSetAll = new HashSet<Long>(10);
        if (selectedRows != null && selectedRows.size() > 0) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            ArrayList<Long> billIdsBankCheck = new ArrayList<Long>(10);
            for (Object primaryKeyValue : primaryKeyValues) {
                Long pkId = (Long)primaryKeyValue;
                Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
                if (idsSet.size() > 0) {
                    idsSetAll.addAll(idsSet);
                }
                if (idsSet.size() != 0) continue;
                billIdsBankCheck.add((Long)primaryKeyValue);
            }
            QFilter idQf = new QFilter("id", "in", billIdsBankCheck);
            DynamicObject[] bizBills = BusinessDataServiceHelper.load((String)entityId, (String)"id,entrys.bankcheckflag", (QFilter[])new QFilter[]{idQf});
            Set<Long> detailIds = HandLinkBillHelper.getDetailIds(bizBills);
            if (detailIds != null && detailIds.size() > 0) {
                idsSetAll.addAll(detailIds);
            }
        }
        return idsSetAll;
    }

    public static Set<Long> getBotpRtansDetails(Long pkId, String entityId) {
        Set<Long> oldRecsrcBill = HandLinkBillHelper.getSrcBillByDestBill(pkId, entityId, "bei_intelrec");
        Set<Long> oldPaysrcBill = HandLinkBillHelper.getSrcBillByDestBill(pkId, entityId, "bei_intelpay");
        Set<Long> newsrcBill = HandLinkBillHelper.getSrcBillByDestBill(pkId, entityId, "bei_transdetail");
        Set<Long> handsrcBill = HandLinkBillHelper.getSrcBillByDestBill(pkId, entityId, "bei_transdetail_cas");
        Set<Long> idsSet = HandLinkBillHelper.mergerSet(oldPaysrcBill, oldRecsrcBill, newsrcBill);
        if (handsrcBill != null && handsrcBill.size() > 0) {
            idsSet.addAll(handsrcBill);
        }
        return idsSet;
    }

    private static Set<Long> getDetailIds(DynamicObject[] bizBills) {
        if (bizBills == null || bizBills.length < 1) {
            return null;
        }
        List<String> list = new ArrayList<String>(bizBills.length);
        for (DynamicObject bizBill : bizBills) {
            String bankcheckflag = "";
            DynamicObjectCollection entrys = bizBill.getDynamicObjectCollection("entrys");
            for (DynamicObject row : entrys) {
                String e_bankcheckflag = row.getString("bankcheckflag");
                if (!EmptyUtil.isNoEmpty((String)e_bankcheckflag)) continue;
                list = HandLinkBillHelper.getbankcheckflagList(list, bankcheckflag);
            }
        }
        if (list.size() > 0) {
            QFilter bankcheckflagQf = new QFilter("bankcheckflag", "in", list);
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{bankcheckflagQf});
            Set<Long> collect = Arrays.stream(ids).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
            return collect;
        }
        return null;
    }

    private static List<String> getbankcheckflagList(List<String> list, String bankcheckflag) {
        if (EmptyUtil.isNoEmpty((String)bankcheckflag)) {
            if (bankcheckflag.contains(",")) {
                String[] split = bankcheckflag.split(",");
                Collections.addAll(list, split);
            } else {
                list.add(bankcheckflag);
            }
        }
        return list;
    }

    public static Set<Long> mergerSet(Set<Long> srcBillByDestBill, Set<Long> paysrcBillByDestBill, Set<Long> recsrcBillByDestBill) {
        HashSet<Long> set = new HashSet<Long>();
        if (EmptyUtil.isNoEmpty(srcBillByDestBill)) {
            set.addAll(srcBillByDestBill);
        }
        if (EmptyUtil.isNoEmpty(paysrcBillByDestBill)) {
            set.addAll(paysrcBillByDestBill);
        }
        if (EmptyUtil.isNoEmpty(recsrcBillByDestBill)) {
            set.addAll(recsrcBillByDestBill);
        }
        return set;
    }

    public static Set<Long> getSrcBillByDestBill(Long destBillId, String destEntityKey, String srcEntityKey) {
        Map srcBills = BFTrackerServiceHelper.findSourceBills((String)destEntityKey, (Long[])new Long[]{destBillId});
        Set entrySet = srcBills.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            HashSet value = (HashSet)entry.getValue();
            if (!srcEntityKey.equals(key)) continue;
            return value;
        }
        return null;
    }

    public static Set<Long> showBotpRtansDetails(DynamicObject bizBill, String entityId) {
        HashSet<Long> idsSetAll = new HashSet<Long>(10);
        if (EmptyUtil.isNoEmpty((DynamicObject)bizBill)) {
            QFilter bankcheckflagQf;
            DynamicObject[] ids;
            Set detailIds;
            Long pkId = (Long)bizBill.getPkValue();
            Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
            if (idsSet.size() > 0) {
                idsSetAll.addAll(idsSet);
                return idsSetAll;
            }
            List<String> list = new ArrayList<String>();
            DynamicObjectCollection entrys = bizBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entrys) {
                String bankcheckflag = entry.getString("bankcheckflag");
                list = HandLinkBillHelper.getbankcheckflagList(list, bankcheckflag);
            }
            if (list.size() > 0 && EmptyUtil.isNoEmpty(detailIds = Arrays.stream(ids = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{bankcheckflagQf = new QFilter("bankcheckflag", "in", list)})).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet())) && detailIds.size() > 0) {
                idsSetAll.addAll(detailIds);
            }
        }
        return idsSetAll;
    }

    public static List<String> getReceiptNoByDetails(DynamicObject bizBill, String entityId) {
        List<String> receiptNos = new ArrayList<String>(10);
        if (EmptyUtil.isNoEmpty((DynamicObject)bizBill)) {
            HashSet<Long> detailIds = new HashSet<Long>(10);
            Long pkId = (Long)bizBill.getPkValue();
            Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
            if (idsSet.size() <= 0) {
                return receiptNos;
            }
            detailIds.addAll(idsSet);
            DynamicObject[] details = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)"id,company,accountbank,currency,receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
            receiptNos = Stream.of(details).map(detail -> detail.getString("receiptno")).collect(Collectors.toList());
        }
        return receiptNos;
    }

    public static String getBankCheckFlagNoDetail(DynamicObject bizBill, String entityId) {
        String bankCheckFlag = null;
        if (EmptyUtil.isNoEmpty((DynamicObject)bizBill)) {
            bankCheckFlag = HandLinkBillHelper.getBankCheckFlagNoDetail(new Object[]{bizBill.getPkValue()}, entityId);
        }
        return bankCheckFlag;
    }

    public static List<String> getReceiptNoByDetails(ListSelectedRowCollection selectedRows, String entityId) {
        List<String> receiptNos = new ArrayList<String>(10);
        if (EmptyUtil.isNoEmpty((Object)selectedRows) && selectedRows.size() > 0) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            HashSet<Long> detailIds = new HashSet<Long>(10);
            for (Object primaryKeyValue : primaryKeyValues) {
                Long pkId = (Long)primaryKeyValue;
                Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
                if (idsSet.size() <= 0) continue;
                detailIds.addAll(idsSet);
            }
            DynamicObject[] details = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)"id,company,accountbank,currency,receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
            receiptNos = Stream.of(details).map(detail -> detail.getString("receiptno")).collect(Collectors.toList());
        }
        return receiptNos;
    }

    public static String getBankCheckFlagNoDetail(ListSelectedRowCollection selectedRows, String entityId) {
        String bankCheckFlag = "";
        if (EmptyUtil.isNoEmpty((Object)selectedRows) && selectedRows.size() > 0) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            bankCheckFlag = HandLinkBillHelper.getBankCheckFlagNoDetail(primaryKeyValues, entityId);
        }
        return bankCheckFlag;
    }

    public static List<String> getBankReceipts(DynamicObject[] selectBills, List<String> receiptNos, String bankName, Boolean isPay) {
        Object result;
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject bill : selectBills) {
            DynamicObject accountBankDy = bill.getDynamicObject(bankName);
            if (accountBankDy == null) continue;
            String finorgType = accountBankDy.getString("finorgtype");
            Boolean authQuerpt = accountBankDy.getBoolean("authquerpt");
            if (!"1".equalsIgnoreCase(finorgType) || !authQuerpt.booleanValue()) continue;
            long id = (Long)bill.getPkValue();
            ids.add(id);
        }
        if (ids.size() > 0 && (result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"ifm", (String)"queryBankReceiptService", (String)"getBankReceipts", (Object[])new Object[]{ids, isPay})) != null) {
            Set bankReceipts = (Set)result;
            receiptNos.addAll(bankReceipts);
        }
        return receiptNos;
    }

    public static String getBankCheckFlagNoDetail(Object[] primaryKeyValues, String entityId) {
        ArrayList<String> bankCheckFlags = new ArrayList<String>(10);
        if (EmptyUtil.isNoEmpty((Object[])primaryKeyValues) && primaryKeyValues.length > 0) {
            DynamicObject[] entityDyObjs;
            for (DynamicObject dyObj : entityDyObjs = BusinessDataServiceHelper.load((String)entityId, (String)"id,entrys.bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)})) {
                Long pkId = dyObj.getLong("id");
                Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
                if (idsSet != null && idsSet.size() != 0) continue;
                DynamicObjectCollection entryEntity = dyObj.getDynamicObjectCollection("entrys");
                for (DynamicObject entry : entryEntity) {
                    String[] split;
                    String entryBankCheckFlag = entry.getString("bankcheckflag");
                    if (!EmptyUtil.isNoEmpty((String)entryBankCheckFlag)) continue;
                    for (String item : split = entryBankCheckFlag.split(",")) {
                        if (!EmptyUtil.isNoEmpty((String)item)) continue;
                        bankCheckFlags.add(item);
                    }
                }
            }
        }
        String bankCheckFlag = StringUtils.join(bankCheckFlags, (String)",");
        return bankCheckFlag;
    }
}

