/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;

public class TransBillHelper {
    public static String getBankTransBillEntity(DynamicObject transBill) {
        String transBillName = transBill.getDataEntityType().getName();
        return StringUtils.equals((String)"fca_transupbill", (String)transBillName) ? "bei_banktransupbill" : "bei_banktransdownbill";
    }

    public static String getTransBillEntity(DynamicObject bankTransBill) {
        String bankTransBillName = bankTransBill.getDataEntityType().getName();
        return "bei_banktransupbill".equals(bankTransBillName) ? "fca_transupbill" : "fca_transdownbill";
    }

    public static boolean isInnerAcctTrans(DynamicObject tranBill) {
        if (!tranBill.getBoolean("ispushifm")) {
            return false;
        }
        DynamicObjectCollection entrys = (DynamicObjectCollection)tranBill.get("entrys");
        return EmptyUtil.isNoEmpty((Object)((DynamicObject)entrys.get(0)).get("inneracctbank"));
    }

    public static Map<Object, Map<Object, DynamicObject>> getInnerAccount(Set<Object> bankAccountIds) {
        bankAccountIds = TransBillHelper.filterAccountIds(bankAccountIds);
        HashMap<Object, Map<Object, DynamicObject>> orgInnerAccountMap = new HashMap<Object, Map<Object, DynamicObject>>(16);
        if (!bankAccountIds.isEmpty()) {
            DynamicObject[] innerAccounts;
            for (DynamicObject innerAccount : innerAccounts = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)"relationacc, org, currency", (QFilter[])new QFilter("relationacc.fbasedataid.id", "in", bankAccountIds).toArray())) {
                DynamicObjectCollection relationAccounts = innerAccount.getDynamicObjectCollection("relationacc");
                if (innerAccount.getDynamicObject("org") == null) continue;
                orgInnerAccountMap.computeIfAbsent(innerAccount.getDynamicObject("org").getPkValue(), k -> new HashMap(16));
                for (DynamicObject relationAcct : relationAccounts) {
                    orgInnerAccountMap.computeIfPresent(innerAccount.getDynamicObject("org").getPkValue(), (k, v) -> {
                        v.put(relationAcct.getDynamicObject("fbasedataid").getPkValue(), innerAccount);
                        return v;
                    });
                }
            }
        }
        return orgInnerAccountMap;
    }

    public static Map<Object, DynamicObject> getBankAcctByInnerAcct(Set<DynamicObject> innerAccounts) {
        if (EmptyUtil.isEmpty(innerAccounts)) {
            return new HashMap<Object, DynamicObject>(0);
        }
        Set innerAccountIds = innerAccounts.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        HashMap<Object, DynamicObject> innerAcctMap = new HashMap<Object, DynamicObject>(16);
        QFilter acctFlt = new QFilter("inneracct.id", "in", innerAccountIds);
        DynamicObjectCollection acc = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{acctFlt});
        if (!acc.isEmpty()) {
            Object[] pks = acc.stream().map(d -> d.get("id")).toArray();
            Map accountBankMap = BusinessDataServiceHelper.loadFromCache((Object[])pks, (String)"bd_accountbanks");
            for (Map.Entry entry : accountBankMap.entrySet()) {
                innerAcctMap.put(((DynamicObject)entry.getValue()).getDynamicObject("inneracct").getPkValue(), (DynamicObject)entry.getValue());
            }
        }
        return innerAcctMap;
    }

    private static Set<Object> filterAccountIds(Set<Object> bankAccountIds) {
        if (bankAccountIds == null || bankAccountIds.isEmpty()) {
            return new HashSet<Object>();
        }
        QFilter matherAccFilter = new QFilter("entrys.bankacct", "in", bankAccountIds);
        DynamicObjectCollection accountGroups = QueryServiceHelper.query((String)"fca_acctgroup", (String)"entrys.bankacct", (QFilter[])matherAccFilter.toArray());
        Set accountIds = accountGroups.stream().map(a -> a.get("entrys.bankacct")).collect(Collectors.toSet());
        HashSet<Object> intersectionAccountIds = new HashSet<Object>(bankAccountIds);
        intersectionAccountIds.retainAll(accountIds);
        return intersectionAccountIds;
    }
}

