/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.helper;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.helper.JournalEntryInfo;
import kd.tmc.fca.common.helper.JournalInfo;

public class TransBillPayBookJournalBuilder {
    private static final Log logger = LogFactory.getLog(TransBillPayBookJournalBuilder.class);

    public static List<JournalInfo> doJournalInfoList(List<DynamicObject> billList) {
        if (billList == null || billList.isEmpty()) {
            return new ArrayList<JournalInfo>(0);
        }
        ArrayList<JournalInfo> paySuccessInfos = new ArrayList<JournalInfo>();
        List sourceIdList = billList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        List sourceEntryIdList = billList.stream().map(b -> b.getDynamicObjectCollection("entrys")).flatMap(e -> e.stream().map(DataEntityBase::getPkValue)).collect(Collectors.toList());
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)billList.get(0).getDataEntityType().getName());
        filter.and("sourcebillid", "in", sourceIdList);
        filter.and("sourcebillentryid", "in", sourceEntryIdList);
        DynamicObjectCollection bankJournal = QueryServiceHelper.query((String)"cas_bankjournal", (String)"sourcebillentryid", (QFilter[])filter.toArray());
        List existsEntryIdList = bankJournal.stream().map(b -> b.get("sourcebillentryid")).collect(Collectors.toList());
        for (DynamicObject bill : billList) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entrys");
            Date bizdate = TransBillPayBookJournalBuilder.filltranbillDate(bill.getDate("createtime"));
            if (null != bill.getDate("transbilldate")) {
                bizdate = TransBillPayBookJournalBuilder.filltranbillDate(bill.getDate("transbilldate"));
            }
            for (DynamicObject entry : entries) {
                DynamicObject fundflowitem;
                if (!FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(entry.getString("paystatus")) || existsEntryIdList.contains(entry.getPkValue())) continue;
                JournalInfo journal = new JournalInfo();
                paySuccessInfos.add(journal);
                journal.setSourceBillEntryId(entry.getLong("id"));
                journal.setSourceBillType(bill.getDataEntityType().getName());
                journal.setOrgId(bill.getDynamicObject("company").getLong("id"));
                journal.setAccountBankId(bill.getDynamicObject("accountbank").getLong("id"));
                journal.setCurrencyId(bill.getDynamicObject("currency").getLong("id"));
                journal.setSourceBillNumber(bill.getString("billno"));
                journal.setSourceBillId(bill.getLong("id"));
                Long userId = RequestContext.get().getCurrUserId();
                DynamicObject user = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_user"), (Object)userId);
                journal.setCashierId(user.getLong("id"));
                journal.setSource(2);
                journal.setBankCheckFlag(entry.getString("bankcheckflag"));
                journal.setBizDate(bizdate);
                if (null != entry.getDate("paydate")) {
                    logger.info("paydate:" + entry.getDate("paydate"));
                    journal.setPd(entry.getDate("paydate"));
                    journal.setPayDate(entry.getDate("paydate"));
                } else {
                    logger.info("paydate is null");
                    journal.setPd(journal.getBizDate());
                    journal.setPayDate(journal.getBizDate());
                }
                if ("online".equalsIgnoreCase(entry.getString("paychanel"))) {
                    journal.setPaychannel("onlinebank");
                } else {
                    journal.setPaychannel(entry.getString("paychanel"));
                }
                Long subAcctId = null;
                if (entry.get("subacct") instanceof DynamicObject) {
                    subAcctId = entry.getDynamicObject("subacct").getLong("id");
                } else if (entry.get("subacct") instanceof Long) {
                    subAcctId = entry.getLong("subacct");
                }
                DynamicObject sonAcct = BusinessDataServiceHelper.loadSingle((Object)subAcctId, (String)"bd_accountbanks");
                journal.setOppUnit(sonAcct.getDynamicObject("company").getLocaleString("name").getLocaleValue());
                journal.setOppAcctNumber(sonAcct.getString("number"));
                DynamicObject bank = sonAcct.getDynamicObject("bank");
                journal.setOppBank(bank == null ? "" : bank.getString("name"));
                String billEntryName = bill.getDataEntityType().getName();
                if (StringUtils.equals((CharSequence)billEntryName, (CharSequence)"fca_transupbill")) {
                    journal.setCreditAmount(BigDecimal.ZERO);
                    journal.setDebitAmount(entry.getBigDecimal("transamt"));
                    journal.setDirection(1);
                    journal.setDescription(ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"TransBillPayBookJournalBuilder_0", (String)"tmc-fca-common", (Object[])new Object[0]));
                    fundflowitem = TmcDataServiceHelper.loadSingle((String)"cas_fundflowitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CF1.02.05.01")});
                    journal.setBatchNo(entry.getString("bankcheckflag"));
                } else {
                    journal.setCreditAmount(entry.getBigDecimal("transamt"));
                    journal.setDebitAmount(BigDecimal.ZERO);
                    journal.setDirection(0);
                    journal.setDescription(ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"TransBillPayBookJournalBuilder_1", (String)"tmc-fca-common", (Object[])new Object[0]));
                    fundflowitem = TmcDataServiceHelper.loadSingle((String)"cas_fundflowitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CF1.02.05.02")});
                    journal.setBatchNo(entry.getString("bankcheckflag"));
                }
                Long fundflowitemId = 0L;
                if (fundflowitem != null) {
                    fundflowitemId = (Long)fundflowitem.getPkValue();
                }
                ArrayList<JournalEntryInfo> journalEntryInfos = new ArrayList<JournalEntryInfo>();
                JournalEntryInfo journalEntry = new JournalEntryInfo();
                journalEntryInfos.add(journalEntry);
                journalEntry.setOppUnit(sonAcct.getDynamicObject("company").getLocaleString("name").getLocaleValue());
                journalEntry.setAmount(entry.getBigDecimal("transamt"));
                journalEntry.setLocalAmount(entry.getBigDecimal("transamt"));
                journalEntry.setFundFlowItemId(fundflowitemId);
                journal.setEntry(journalEntryInfos);
            }
        }
        return paySuccessInfos;
    }

    public static Date filltranbillDate(Date dealDate) {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sdf.parse(sdf.format(dealDate));
        }
        catch (ParseException parseException) {
            logger.error("filltranbillDate error:", (Throwable)parseException);
        }
        return date;
    }
}

