/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class VoucherCheckHepler {
    private static final String VCHECKED = "c";

    public static void doVoucherCheck(DynamicObject info) {
        boolean result = VoucherCheckHepler.vouCherCheck(info);
        if (!result) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u80fd\u81ea\u52a8\u590d\u6838\u51ed\u8bc1\uff0c\u53ef\u5230\u51ed\u8bc1\u67e5\u8be2\u5217\u8868\u624b\u5de5\u590d\u6838\u3002", (String)"VoucherCheckHepler_0", (String)"tmc-fca-common", (Object[])new Object[0]));
        }
    }

    public static void doCancelCoucherCheck(DynamicObject info) {
        boolean result = VoucherCheckHepler.cancelCoucherCheck(info);
        if (!result) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u80fd\u81ea\u52a8\u53cd\u590d\u6838\u51ed\u8bc1\uff0c\u53ef\u5230\u51ed\u8bc1\u67e5\u8be2\u5217\u8868\u624b\u5de5\u53cd\u590d\u6838\u3002", (String)"VoucherCheckHepler_1", (String)"tmc-fca-common", (Object[])new Object[0]));
        }
    }

    public static boolean vouCherCheck(DynamicObject info) {
        boolean result = true;
        Long sourceBillId = info.getLong("id");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)info.getDataEntityType().getName(), (String)"id,company");
        DynamicObject org = bill.getDynamicObject("company");
        if (org == null || !VoucherCheckHepler.isBillBookJournal(org.getLong("id"))) {
            return result;
        }
        ArrayList<Long> voucherIds = new ArrayList<Long>();
        QFilter filter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{filter});
        if (vouchersDaps != null && vouchersDaps.size() > 0) {
            DynamicObject[] vouchers;
            vouchersDaps.forEach(v -> voucherIds.add(v.getLong("voucherid")));
            if (voucherIds.size() > 0 && (vouchers = BusinessDataServiceHelper.load((Object[])voucherIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gl_voucher"))) != null && vouchers.length > 0) {
                voucherIds.clear();
                for (DynamicObject v2 : vouchers) {
                    if (VCHECKED.equals(v2.getString("ischeck")) || !VoucherCheckHepler.isCashBank(v2)) continue;
                    voucherIds.add(v2.getLong("id"));
                }
                if (voucherIds.size() > 0) {
                    DynamicObject typeObj = vouchers[0].getDynamicObject("sourcebilltype");
                    String type = typeObj.getString("number");
                    result = VoucherCheckHepler.operateCheck(voucherIds, type, sourceBillId, "vouchercheck");
                }
            }
        }
        return result;
    }

    public static boolean cancelCoucherCheck(DynamicObject info) {
        boolean result = true;
        Long sourceBillId = info.getLong("id");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)info.getDataEntityType().getName(), (String)"id,company");
        DynamicObject org = bill.getDynamicObject("company");
        if (org == null || !VoucherCheckHepler.isBillBookJournal(org.getLong("id"))) {
            return result;
        }
        ArrayList<Long> voucherIds = new ArrayList<Long>();
        QFilter filter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{filter});
        if (vouchersDaps != null && vouchersDaps.size() > 0) {
            vouchersDaps.forEach(v -> voucherIds.add(v.getLong("voucherid")));
            if (voucherIds.size() > 0) {
                QFilter covFilter = new QFilter("id", "in", voucherIds);
                covFilter.and(new QFilter("ischeck", "=", (Object)VCHECKED));
                DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,sourcebilltype", (QFilter[])new QFilter[]{covFilter});
                if (vouchers != null && vouchers.size() > 0) {
                    voucherIds.clear();
                    vouchers.forEach(v -> voucherIds.add(v.getLong("id")));
                    String type = ((DynamicObject)vouchers.get(0)).getString("sourcebilltype");
                    result = VoucherCheckHepler.operateCheck(voucherIds, type, sourceBillId, "voucheruncheck");
                }
            }
        }
        return result;
    }

    private static boolean operateCheck(List<Long> voucherIds, String sourceBillType, Long sourceBillId, String operKey) {
        boolean result = false;
        if (voucherIds.size() == 1) {
            QFilter filter = new QFilter("voucherid", "=", (Object)voucherIds.get(0));
            DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{filter});
            if (vouchersDaps != null) {
                if (vouchersDaps.size() == 1) {
                    result = VoucherCheckHepler.getOpResult(voucherIds, operKey);
                } else if (vouchersDaps.size() > 1) {
                    if (!"voucheruncheck".equals(operKey)) {
                        ArrayList sourceIds = new ArrayList(5);
                        vouchersDaps.forEach(s -> {
                            Long sId = s.getLong("sourcebillid");
                            if (!sourceBillId.equals(sId)) {
                                sourceIds.add(sId);
                            }
                        });
                        if (sourceIds.size() > 0) {
                            QFilter sFilter = new QFilter("id", "in", (Object)sourceIds.toArray());
                            DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)sourceBillType, (String)"id,billstatus", (QFilter[])new QFilter[]{sFilter});
                            for (DynamicObject sourceBill : sourceBills) {
                                if ("D".equals(sourceBill.getString("billstatus"))) continue;
                                result = true;
                            }
                        }
                    }
                    if (!result) {
                        result = VoucherCheckHepler.getOpResult(voucherIds, operKey);
                    }
                }
            }
        } else {
            QFilter filter = new QFilter("voucherid", "in", voucherIds);
            DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{filter});
            if (vouchersDaps != null) {
                ArrayList sourceIds = new ArrayList();
                vouchersDaps.forEach(v -> {
                    if (!sourceBillId.equals(v.getLong("sourcebillid"))) {
                        sourceIds.add(v.getLong("sourcebillid"));
                    }
                });
                if (sourceIds.size() > 0 && !"voucheruncheck".equals(operKey)) {
                    QFilter sFilter = new QFilter("fid", "in", (Object)sourceIds.toArray());
                    DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)sourceBillType, (String)"id,billstatus", (QFilter[])new QFilter[]{sFilter});
                    for (DynamicObject sourceBill : sourceBills) {
                        if ("D".equals(sourceBill.getString("billstatus"))) continue;
                        result = true;
                    }
                    if (result) {
                        return result;
                    }
                } else {
                    result = VoucherCheckHepler.getOpResult(voucherIds, operKey);
                }
            }
        }
        return result;
    }

    private static boolean getOpResult(List<Long> voucherIds, String operKey) {
        OperateOption oper = OperateOption.create();
        oper.setVariableValue("invokingApp", "cas");
        OperationResult result = TmcOperateServiceHelper.execOperate((String)operKey, (String)"gl_voucher", (Object[])voucherIds.toArray(), (OperateOption)oper);
        if (result != null) {
            return result.isSuccess();
        }
        return false;
    }

    private static boolean isCashBank(DynamicObject voucher) {
        DynamicObjectCollection ves = voucher.getDynamicObjectCollection("entries");
        boolean isCashBank = false;
        for (DynamicObject ve : ves) {
            DynamicObject accInfo = ve.getDynamicObject("account");
            if (!VoucherCheckHepler.isCashAcct(accInfo)) continue;
            isCashBank = true;
            break;
        }
        return isCashBank;
    }

    public static boolean isCashAcct(DynamicObject acct) {
        if (acct == null) {
            return false;
        }
        return acct.getBoolean("iscash") || acct.getBoolean("isbank") || acct.getBoolean("iscashequivalent");
    }

    public static boolean isBillBookJournal(long orgId) {
        Object cs105 = SystemParamServiceHelper.getAppParameter((String)"d2bb1733000000ac", (String)"08", (Long)orgId, (String)"cs105");
        return "0".equals(cs105);
    }
}

