/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.MetadataServiceHelper;

public class EntityMetadataUtils {
    public static DynamicProperty getProperty(String entityKey, String key) {
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entityKey);
        return EntityMetadataUtils.getProperty(dt, key);
    }

    public static DynamicProperty getProperty(MainEntityType dt, String key) {
        DynamicProperty property = dt.getProperty(key);
        if (property == null) {
            EntryProp entryProp = EntityMetadataUtils.getEntryProp((IDataEntityType)dt);
            if (entryProp != null) {
                property = entryProp._collectionItemPropertyType.getProperty(key);
            }
            if (property == null) {
                ErrorCode errCode = new ErrorCode("NoSuchProperty", ResManager.loadKDString((String)"%1$s\u4e2d\u4e0d\u5b58\u5728\u540d\u4e3a\u3010%2$s\u3011\u7684\u5c5e\u6027\u3002", (String)"EntityMetadataUtils_0", (String)"tmc-fca-common", (Object[])new Object[0]));
                throw new KDException(errCode, new Object[]{dt.getName(), key});
            }
        }
        return property;
    }

    public static boolean containsProperty(IDataEntityType dataEntityType, String fieldName) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty p : properties) {
            if (!p.getName().equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsEntryField(Collection<String> fields, MainEntityType dataEntityType) {
        for (String field : fields) {
            if (!EntityMetadataUtils.isEntryField(dataEntityType, field)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntryField(MainEntityType dt, String propName) {
        EntryProp entryProp = EntityMetadataUtils.getEntryProp((IDataEntityType)dt);
        if (entryProp == null) {
            return false;
        }
        String profix = EntityMetadataUtils.getPrefix(propName);
        if (entryProp.getName().equalsIgnoreCase(profix)) {
            return true;
        }
        DynamicProperty property = dt.getProperty(profix);
        return property == null;
    }

    private static String getPrefix(String str) {
        int index = str.indexOf(46);
        index = index > 0 ? index : str.length();
        return str.substring(0, index);
    }

    public static List<String> getProperties(DynamicObject bill) {
        ArrayList<String> props = new ArrayList<String>();
        DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
        for (IDataEntityProperty prop : properties) {
            if (prop instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)prop)._collectionItemPropertyType.getProperties();
                for (IDataEntityProperty eProp : entryProperties) {
                    props.add(eProp.getName());
                }
            }
            props.add(prop.getName());
        }
        return props;
    }

    public static EntryProp getEntryProp(IDataEntityType dataType) {
        DataEntityPropertyCollection properties = dataType.getProperties();
        for (IDataEntityProperty pro : properties) {
            if (!(pro instanceof EntryProp) || pro instanceof LinkEntryProp) continue;
            return (EntryProp)pro;
        }
        return null;
    }

    public static IDataEntityProperty getMainOrgProp(String entityKey) {
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entityKey);
        DataEntityPropertyCollection properties = dt.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof MainOrgProp)) continue;
            return prop;
        }
        return null;
    }
}

