/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.ebservice;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.isv.ISVService;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.tmc.ext.extpoint.committobe.IGenBankBillSDKService;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.TransDetail;
import kd.tmc.fbp.service.ebservice.bean.TransInfo;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;

public class TransInfoFactory {
    public static List<TransInfo> createTransInfo(List<DynamicObject> transBillList) {
        if (transBillList.size() == 0) {
            return Collections.emptyList();
        }
        String billName = transBillList.get(0).getDataEntityType().getName();
        if ("fca_transupbill".equals(billName) || "fca_transdownbill".equals(billName)) {
            return TransInfoFactory.createTransBill(transBillList, billName);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4ed8\u6b3e\u5355\u636e\u7c7b\u578b: %s", (String)"IPayBillSyncStatusService_0", (String)"tmc-fca-business", (Object[])new Object[0]), billName));
    }

    private static boolean canCommitToBe(DynamicObject entry) {
        String state = (String)entry.get("state");
        String payStatus = (String)entry.get("paystatus");
        return (FcaTransDetailStatusEnum.NORMAL.getValue().equals(state) || FcaTransDetailStatusEnum.BACK.getValue().equals(state)) && FcaTransPayStatusEnum.BEIPROC.getValue().equals(payStatus);
    }

    public static List<TransInfo> createTransBill(List<DynamicObject> transBillList, String entityName) {
        ArrayList<TransInfo> payInfoList = new ArrayList<TransInfo>(transBillList.size());
        HashSet<Long> acctIdSet = new HashSet<Long>();
        HashSet<Long> finOrgIdSet = new HashSet<Long>();
        for (DynamicObject transBill : transBillList) {
            DynamicObject monAcct = transBill.getDynamicObject("accountbank");
            if (monAcct != null) {
                long monAcctId = monAcct.getLong("id");
                acctIdSet.add(monAcctId);
                DynamicObject monFinOrg = monAcct.getDynamicObject("bank");
                if (monFinOrg != null) {
                    finOrgIdSet.add(monFinOrg.getLong("id"));
                }
            }
            DynamicObjectCollection entryList = transBill.getDynamicObjectCollection("entrys");
            Iterator<DynamicObject> iterator = entryList.iterator();
            while (iterator.hasNext()) {
                DynamicObject subAcct;
                DynamicObject entry = (DynamicObject)iterator.next();
                if (!TransInfoFactory.canCommitToBe(entry) || (subAcct = entry.getDynamicObject("subacct")) == null) continue;
                acctIdSet.add(subAcct.getLong("id"));
                DynamicObject subFinOrg = subAcct.getDynamicObject("bank");
                if (subFinOrg == null) continue;
                finOrgIdSet.add(subFinOrg.getLong("id"));
            }
        }
        Map bankAcctMap = TmcDataServiceHelper.loadDataAndMapById((String)"am_accountbank", acctIdSet);
        Map finOrgMap = TmcDataServiceHelper.loadDataAndMapById((String)"bd_finorginfo", finOrgIdSet);
        HashSet<Long> bankIdSet = new HashSet<Long>();
        for (DynamicObject finOrg : finOrgMap.values()) {
            DynamicObject beBank = finOrg.getDynamicObject("bebank");
            if (beBank == null) continue;
            bankIdSet.add(beBank.getLong("id"));
        }
        Map beBankMap = TmcDataServiceHelper.loadDataAndMapById((String)"bd_bebank", bankIdSet);
        for (DynamicObject transBill : transBillList) {
            DynamicObject monAcct = (DynamicObject)bankAcctMap.get(transBill.getDynamicObject("accountbank").getLong("id"));
            DynamicObject monFinOrg = (DynamicObject)finOrgMap.get(monAcct.getDynamicObject("bank").getLong("id"));
            TransInfo transInfo = new TransInfo();
            DynamicObject monOrg = transBill.getDynamicObject("company");
            transInfo.setMonAcctOrgId((Long)monOrg.getPkValue());
            transInfo.setMonAcctOrgName(monOrg.getString("name"));
            transInfo.setMonAcctId((Long)monAcct.getPkValue());
            DynamicObject cny = transBill.getDynamicObject("currency");
            if (cny != null) {
                transInfo.setMonAcctCurrencyId(Long.valueOf(cny.getLong("id")));
            } else {
                transInfo.setMonAcctCurrencyId(Long.valueOf(monAcct.getDynamicObject("defaultcurrency").getLong("id")));
            }
            transInfo.setMonAcctName(monAcct.getString("acctname"));
            transInfo.setMonAcctBankName(monFinOrg.getString("name"));
            transInfo.setMonAcctBankNum(monAcct.getString("bankaccountnumber"));
            if (monFinOrg.getDynamicObject("country") != null) {
                transInfo.setMonAcctCountry(Long.valueOf(monFinOrg.getDynamicObject("country").getLong("id")));
            }
            if (EmptyUtil.isNoEmpty((String)transBill.getString("province"))) {
                transInfo.setMonAcctProvince(transBill.getString("province"));
            } else if (monFinOrg.getDynamicObject("province") != null) {
                transInfo.setMonAcctProvince(monFinOrg.getDynamicObject("province").getString("name"));
            }
            if (EmptyUtil.isNoEmpty((String)transBill.getString("city"))) {
                transInfo.setMonAcctCity(transBill.getString("city"));
            } else if (monFinOrg.getDynamicObject("city") != null) {
                transInfo.setMonAcctCity(monFinOrg.getDynamicObject("city").getString("name"));
            }
            transInfo.setBillNo(transBill.getString("billno"));
            transInfo.setBillId((Long)transBill.getPkValue());
            transInfo.setBillType(entityName);
            transInfo.setBankId(Long.valueOf(monFinOrg.getLong("id")));
            transInfo.setPayBillCreatorId(Long.valueOf(transBill.getDynamicObject("creator").getLong("id")));
            DynamicObject auditor = transBill.getDynamicObject("auditor");
            if (EmptyUtil.isNoEmpty((DynamicObject)auditor)) {
                transInfo.setPayBillAuditorId(Long.valueOf(auditor.getLong("id")));
            }
            DynamicObjectCollection entryList = transBill.getDynamicObjectCollection("entrys");
            ArrayList<TransDetail> transDetailList = new ArrayList<TransDetail>();
            for (DynamicObject entry : entryList) {
                if (!TransInfoFactory.canCommitToBe(entry)) continue;
                DynamicObject subAcct = (DynamicObject)bankAcctMap.get(entry.getDynamicObject("subacct").getLong("id"));
                DynamicObject subFinOrg = (DynamicObject)finOrgMap.get(subAcct.getDynamicObject("bank").getLong("id"));
                TransDetail transDetail = new TransDetail();
                if (subFinOrg.getDynamicObject("bebank") != null) {
                    DynamicObject subBank = (DynamicObject)beBankMap.get(subFinOrg.getDynamicObject("bebank").getLong("id"));
                    transDetail.setSubAcctBankName(subBank.getString("name"));
                }
                transDetail.setSubAcctId(Long.valueOf(subAcct.getLong("id")));
                transDetail.setSubAcctOrgName(entry.getDynamicObject("subacct_company").getString("name"));
                transDetail.setSubAcctName(subAcct.getString("acctname"));
                transDetail.setSubAcctBankNum(subAcct.getString("bankaccountnumber"));
                if (subFinOrg.getDynamicObject("country") != null) {
                    transDetail.setSubAcctCountryId(Long.valueOf(subFinOrg.getDynamicObject("country").getLong("id")));
                }
                if (EmptyUtil.isNoEmpty((String)entry.getString("entryprovince"))) {
                    transDetail.setSubAcctProvince(entry.getString("entryprovince"));
                } else if (subFinOrg.getDynamicObject("province") != null) {
                    transDetail.setSubAcctProvince(subFinOrg.getDynamicObject("province").getString("name"));
                }
                if (EmptyUtil.isNoEmpty((String)entry.getString("entrycity"))) {
                    transDetail.setSubAcctCity(entry.getString("entrycity"));
                } else if (subFinOrg.getDynamicObject("city") != null) {
                    transDetail.setSubAcctCity(subFinOrg.getDynamicObject("city").getString("name"));
                }
                transDetail.setEntryId(Long.valueOf(entry.getLong("id")));
                transDetail.setRemark(entry.getString("remark"));
                transDetail.setUsage(entry.getString("usage"));
                transDetail.setComment(entry.getString("remark"));
                transDetail.setAmount(entry.getBigDecimal("transamt"));
                transDetailList.add(transDetail);
            }
            BigDecimal totalAmount = transDetailList.stream().map(TransDetail::getAmount).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
            transInfo.setTotalTransAmt(totalAmount);
            transInfo.setTotalLocalAmt(totalAmount);
            transInfo.setTransDetails(transDetailList);
            payInfoList.add(transInfo);
        }
        return payInfoList;
    }

    public static void dealExPropValue(String entityName, List<DynamicObject> bills, List<DynamicObject> bankBills) {
        PluginProxy pluginProxy = PluginProxy.create(IGenBankBillSDKService.class, (String)"kd.sdk.tmc.ext.extpoint.committobe.IGenBankBillSDKService.extFillBankBill");
        List changeProps = pluginProxy.callReplace(p -> p.extFillBankBill(entityName, bills));
        if (EmptyUtil.isNoEmpty((Object)changeProps) && changeProps.size() > 0 && EmptyUtil.isNoEmpty(changeProps.get(0))) {
            String isv = ISVService.getISVInfo().getId();
            for (DynamicObject one : bankBills) {
                Map extValue = (Map)((Map)changeProps.get(0)).get(one.getLong("sourcebillid"));
                if (!EmptyUtil.isNoEmpty((Object)extValue)) continue;
                for (Map.Entry oneExtValue : extValue.entrySet()) {
                    if (!((String)oneExtValue.getKey()).startsWith(isv)) continue;
                    one.set((String)oneExtValue.getKey(), oneExtValue.getValue());
                }
            }
        }
    }

    public static List<DynamicObject> generateBankTransBill(String entityName, List<TransInfo> transInfos) {
        ArrayList<DynamicObject> bankTransBillList = new ArrayList<DynamicObject>(transInfos.size());
        if (!CollectionUtils.isEmpty(transInfos)) {
            MainEntityType bankTransEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            Long currUser = RequestContext.get().getCurrUserId();
            Timestamp currDate = DateUtils.getCurrentTime();
            for (TransInfo transInfo : transInfos) {
                long pkId = DB.genLongId((String)bankTransEntityType.getAlias());
                DynamicObject bankTransBill = new DynamicObject((DynamicObjectType)bankTransEntityType, (Object)pkId);
                bankTransBill.set("bizdate", (Object)currDate);
                bankTransBill.set("creator", (Object)currUser);
                bankTransBill.set("createtime", (Object)currDate);
                bankTransBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
                bankTransBill.set("auditdate", (Object)currDate);
                bankTransBill.set("auditor", (Object)currUser);
                bankTransBill.set("paystate", (Object)BeBillStatusEnum.OP.getValue());
                bankTransBill.set("company", (Object)transInfo.getMonAcctOrgId());
                bankTransBill.set("accountbank", (Object)transInfo.getMonAcctId());
                bankTransBill.set("bank", (Object)transInfo.getBankId());
                bankTransBill.set("currency", (Object)transInfo.getMonAcctCurrencyId());
                bankTransBill.set("exchangerate", (Object)transInfo.getExchangeRate());
                bankTransBill.set("amount", (Object)transInfo.getTotalTransAmt());
                bankTransBill.set("sourcebillid", (Object)transInfo.getBillId());
                bankTransBill.set("payunique", (Object)-1L);
                bankTransBill.set("sourcetype", (Object)transInfo.getBillType());
                bankTransBill.set("locamt", (Object)transInfo.getTotalLocalAmt());
                bankTransBill.set("transbillno", (Object)transInfo.getBillNo());
                bankTransBill.set("expectdealtime", (Object)transInfo.getExpectDealTime());
                bankTransBill.set("ispersonpay", (Object)transInfo.isPersonalPay());
                bankTransBill.set("paybillcreator", (Object)transInfo.getPayBillCreatorId());
                Long auditorId = transInfo.getPayBillAuditorId();
                if (EmptyUtil.isNoEmpty((Long)auditorId)) {
                    bankTransBill.set("paybillauditor", (Object)auditorId);
                }
                bankTransBill.set("monacctname", (Object)transInfo.getMonAcctName());
                bankTransBill.set("monacctorg", (Object)transInfo.getMonAcctOrgName());
                bankTransBill.set("monacctnumber", (Object)transInfo.getMonAcctBankNum());
                bankTransBill.set("monacctbankname", (Object)transInfo.getMonAcctBankName());
                bankTransBill.set("monacctcity", (Object)transInfo.getMonAcctCity());
                bankTransBill.set("monacctprovince", (Object)transInfo.getMonAcctProvince());
                DynamicObjectCollection entry = bankTransBill.getDynamicObjectCollection("entrys");
                List transDetails = transInfo.getTransDetails();
                int seq = 1;
                BigDecimal totalAmount = BigDecimal.ZERO;
                for (TransDetail transDetail : transDetails) {
                    DynamicObject newEntry = entry.addNew();
                    newEntry.set("seq", (Object)seq++);
                    newEntry.set("sourceentryid", (Object)transDetail.getEntryId());
                    newEntry.set("subacct", (Object)transDetail.getSubAcctId());
                    newEntry.set("remark", (Object)transDetail.getUsage());
                    newEntry.set("comment", (Object)transDetail.getRemark());
                    newEntry.set("transamt", (Object)transDetail.getAmount());
                    newEntry.set("status", (Object)BeBillStatusEnum.OP.getValue());
                    totalAmount = totalAmount.add(newEntry.getBigDecimal("transamt"));
                    newEntry.set("sonacctname", (Object)transDetail.getSubAcctName());
                    newEntry.set("sonacctorg", (Object)transDetail.getSubAcctOrgName());
                    newEntry.set("sonacctnumber", (Object)transDetail.getSubAcctBankNum());
                    newEntry.set("sonacctbankname", (Object)transDetail.getSubAcctBankName());
                    newEntry.set("sonacctcity", (Object)transDetail.getSubAcctCity());
                    newEntry.set("sonacctprovince", (Object)transDetail.getSubAcctProvince());
                }
                if (entry.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6b63\u5e38\u4e14\u4ed8\u6b3e\u6210\u529f/\u88ab\u6253\u56de\u4e14\u4ed8\u6b3e\u5931\u8d25\u90e8\u5206\u7684\u5212\u62e8\u5355\u5206\u5f55\u3002", (String)"AbstractTransBillCommitBeOp_3", (String)"tmc-fca-opplugin", (Object[])new Object[0]));
                }
                bankTransBill.set("count", (Object)entry.size());
                bankTransBill.set("amount", (Object)totalAmount);
                bankTransBillList.add(bankTransBill);
            }
        }
        return bankTransBillList;
    }
}

