/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.applytransbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.business.service.match.bean.MatchResultBean;
import kd.tmc.fca.business.service.match.impl.MatchRuleServiceImpl;
import kd.tmc.fca.business.service.match.transfer.DetailMatchDataTransfer;
import kd.tmc.fca.common.helper.TransBillHelper;

public class ApplyTransBillSaveService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ApplyTransBillSaveService.class);
    private Map<Object, Map<Object, DynamicObject>> orgInnerAccountMap = null;

    public void process(DynamicObject[] dataEntities) throws KDException {
        List list = Arrays.stream(dataEntities).map(d -> d.getDynamicObjectCollection("entrys")).flatMap(e -> e.stream().filter(d -> d.getDynamicObject("subacct") != null)).collect(Collectors.toList());
        if (!list.isEmpty()) {
            Set bankAccountIds = list.stream().map(r -> r.getDynamicObject("subacct").getPkValue()).collect(Collectors.toSet());
            this.orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
        }
        for (DynamicObject applyTransBill : dataEntities) {
            DynamicObject currency = applyTransBill.getDynamicObject("currency");
            DynamicObjectCollection entityList = applyTransBill.getDynamicObjectCollection("entrys");
            DynamicObject parentOrg = applyTransBill.getDynamicObject("parentorg");
            BigDecimal transSumAmt = entityList.stream().filter(Objects::nonNull).map(o -> o.getBigDecimal("transamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            applyTransBill.set("transamount", (Object)transSumAmt);
            BigDecimal transApplySumAmt = entityList.stream().filter(Objects::nonNull).map(o -> o.getBigDecimal("applyamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            applyTransBill.set("amount", (Object)transApplySumAmt);
            this.fullInnerAccount(applyTransBill);
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        List<MatchResultBean> matchResultBeanList;
        if ("fca_applytransupbill".equals(dataEntities[0].getDataEntityType().getName())) {
            return;
        }
        Object[] mathBillId = Arrays.stream(dataEntities).filter(d -> EmptyUtil.isNoEmpty((Object)d.get("sourcebillid"))).map(DataEntityBase::getPkValue).toArray();
        logger.info("match size {}", (Object)mathBillId.length);
        if (mathBillId.length != 0 && (matchResultBeanList = new MatchRuleServiceImpl(new DetailMatchDataTransfer(mathBillId)).match()) != null) {
            DynamicObject[] applyTransBills;
            Map<Object, Object> matchMap = matchResultBeanList.stream().filter(m -> !m.getData().isEmpty()).collect(Collectors.toMap(MatchResultBean::getId, m -> m.getData().get("e_acctgroup"), (e1, e2) -> e1));
            HashSet<Object> ids = new HashSet<Object>(16);
            for (Object object : matchMap.values()) {
                DynamicObject acctGroup = (DynamicObject)object;
                ids.add(acctGroup.getPkValue());
            }
            logger.info("ids :{}", ids);
            Map<Object, Object> acctGroupMap = new HashMap(16);
            if (!ids.isEmpty()) {
                QFilter qFilter = new QFilter("id", "in", ids).and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
                DynamicObjectCollection acctGroups = QueryServiceHelper.query((String)"fca_acctgroup", (String)"id,entrys.bankacct", (QFilter[])qFilter.toArray());
                acctGroupMap = acctGroups.stream().collect(Collectors.toMap(d -> d.getLong("id"), each -> Collections.singletonList(each.getLong("entrys.bankacct")), (value1, value2) -> {
                    ArrayList union = new ArrayList(value1);
                    union.addAll(value2);
                    return union;
                }));
            }
            logger.info("acctGroupMap {}", acctGroupMap);
            for (DynamicObject applyTransBill : applyTransBills = BusinessDataServiceHelper.load((String)dataEntities[0].getDataEntityType().getName(), (String)"id,company, parentorg, accountbank, currency, entrys.acctgrp, entrys.subacct, entrys.pbankacct, entrys.inneracct ", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)mathBillId)})) {
                if (matchMap.get(applyTransBill.getPkValue()) != null) {
                    DynamicObject entry;
                    DynamicObject acctGroup = (DynamicObject)matchMap.get(applyTransBill.getPkValue());
                    DynamicObjectCollection entries = applyTransBill.getDynamicObjectCollection("entrys");
                    boolean isSet = false;
                    Iterator iterator = entries.iterator();
                    while (iterator.hasNext() && (entry = (DynamicObject)iterator.next()).get("acctgrp") == null) {
                        List bankAcctIds;
                        if (entry.getDynamicObject("subacct") != null && ((bankAcctIds = (List)acctGroupMap.get(acctGroup.getPkValue())) == null || !bankAcctIds.contains(entry.getDynamicObject("subacct").getPkValue()))) continue;
                        entry.set("acctgrp", (Object)acctGroup);
                        if (acctGroup.getDynamicObject("accountbank") != null) {
                            entry.set("pbankacct", (Object)acctGroup.getDynamicObject("accountbank"));
                        }
                        isSet = true;
                    }
                    if (isSet && acctGroup.getDynamicObject("company") != null) {
                        applyTransBill.set("parentorg", (Object)acctGroup.getDynamicObject("company"));
                    }
                }
                this.fullInnerAccount(applyTransBill);
            }
            SaveServiceHelper.update((DynamicObject[])applyTransBills);
        }
    }

    private void fullInnerAccount(DynamicObject applyTransBill) {
        DynamicObject currency = applyTransBill.getDynamicObject("currency");
        DynamicObjectCollection entityList = applyTransBill.getDynamicObjectCollection("entrys");
        DynamicObject parentOrg = applyTransBill.getDynamicObject("parentorg");
        if (currency != null && this.orgInnerAccountMap != null && this.orgInnerAccountMap.containsKey(parentOrg.getPkValue())) {
            for (DynamicObject detail : entityList) {
                DynamicObjectCollection currencies;
                List currencyIdList;
                if (detail.getDynamicObject("subacct") == null) continue;
                DynamicObject innerAccount = this.orgInnerAccountMap.get(parentOrg.getPkValue()).get(detail.getDynamicObject("subacct").getPkValue());
                if (innerAccount != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                    innerAccount = null;
                }
                detail.set("inneracct", (Object)innerAccount);
            }
        }
    }
}

