/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.applytransbill;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.helper.FcaBotpHelper;

public class PullPayBillService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(PullPayBillService.class);
    private static final int MAX_PULL_SIZE = 100000;
    private static final String SYSTEM_TYPE = "tmc-fca-business";
    private final String targetEntityNumber;
    private Object fcaPullRule;

    public PullPayBillService(String targetEntityNumber) {
        this.targetEntityNumber = targetEntityNumber;
    }

    public PullPayBillService(String targetEntityNumber, Object fcaPullRule) {
        this.targetEntityNumber = targetEntityNumber;
        this.fcaPullRule = fcaPullRule;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        LOGGER.info("PullPayBillService begin");
        if (StringUtils.isBlank((CharSequence)this.targetEntityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PullPayBillService_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        Date currentDay = DateUtils.getCurrentDate();
        boolean lock = MutexServiceHelper.request((String)"pullbill", (String)this.targetEntityNumber, (String)"pullbill");
        if (!lock) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6b63\u5728\u91c7\u96c6\u4e2d\u3002", (String)"PullPayBillService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        StringBuilder message = new StringBuilder();
        try {
            QFilter filter = new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C")).and(new QFilter("targetentity.number", "=", (Object)this.targetEntityNumber));
            if (EmptyUtil.isNoEmpty((Object)this.fcaPullRule)) {
                filter.and(new QFilter("id", "=", this.fcaPullRule));
            }
            DynamicObjectCollection pullRules = QueryServiceHelper.query((String)"fca_pullrule", (String)"number,sourceentity.number,sourceentity.name,sourceentity.dentityid,targetentity.number,targetentity.dentityid,datafilter,datafilter_TAG,rule", (QFilter[])filter.toArray());
            LOGGER.info("pullRules size:{}", (Object)pullRules.size());
            if (pullRules.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u91c7\u96c6\u65b9\u6848\u3002", (String)"PullPayBillService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            int pushCount = 0;
            for (DynamicObject pullRule : pullRules) {
                String number = pullRule.getString("number");
                String sourceEntity = pullRule.getString("sourceentity.dentityid");
                String targetEntity = pullRule.getString("targetentity.dentityid");
                String sourceEntityNumber = pullRule.getString("sourceentity.number");
                String sourceEntityName = pullRule.getString("sourceentity.name");
                String filterStr = StringUtils.isNotBlank((CharSequence)pullRule.getString("datafilter_TAG")) ? pullRule.getString("datafilter_TAG") : pullRule.getString("datafilter");
                if (StringUtils.isBlank((CharSequence)sourceEntity) && StringUtils.isBlank((CharSequence)targetEntity) || StringUtils.isBlank((CharSequence)filterStr)) continue;
                CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
                MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)sourceEntityNumber);
                FilterBuilder fb = new FilterBuilder(dataType, crCondition.getFilterCondition(), true);
                fb.buildFilter(true);
                QFilter archiveFilter = fb.getQFilter();
                if (archiveFilter == null) continue;
                DataSet billCount = QueryServiceHelper.queryDataSet((String)sourceEntityNumber, (String)sourceEntityNumber, (String)"count(distinct id) as billCount", (QFilter[])archiveFilter.toArray(), (String)"");
                for (Row row : billCount) {
                    if (row.getInteger("billCount") <= 100000) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u91c7\u96c6\u7f16\u7801\u3010%1$s\u3011\u6765\u6e90\u5355\u636e\u3010%2$s\u3011\uff1a\u67e5\u8be2\u51fa\u5355\u636e%1$d\u5f20\uff0c\u6700\u5927\u652f\u6301%2$d\u5f20\uff0c\u8bf7\u4fee\u6539\u91c7\u96c6\u65b9\u6848\u3002", (String)"PullPayBillService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), row.getInteger("billCount"), 100000));
                }
                DynamicObjectCollection bills = QueryServiceHelper.query((String)sourceEntityNumber, (String)"id", (QFilter[])archiveFilter.toArray(), (String)"id");
                LOGGER.info("push bill size:{}", (Object)bills.size());
                pushCount += this.getPushCount(sourceEntityNumber, currentDay);
                if (!bills.isEmpty()) {
                    Set<Long> ids = bills.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
                    this.duplicateRemoval(sourceEntity, targetEntity, sourceEntityNumber, ids);
                    int successCount = 0;
                    int failCount = 0;
                    if (!ids.isEmpty()) {
                        int resultSuccessPkIdCount;
                        ConvertOperationResult convertOperationResult = FcaBotpHelper.pushPage((String)pullRule.getString("rule"), (Object[])ids.toArray(), (String)sourceEntityNumber, (String)"fca_applytransdownbill");
                        if (!convertOperationResult.isSuccess()) {
                            this.copyConvertOperationResult(this.operationResult, convertOperationResult);
                        }
                        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)this.targetEntityNumber);
                        List targetBillObject = convertOperationResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
                        DynamicObject[] pushBills = targetBillObject.toArray(new DynamicObject[0]);
                        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)this.targetEntityNumber, (DynamicObject[])pushBills, (OperateOption)OperateOption.create());
                        successCount = resultSuccessPkIdCount = result.getSuccessPkIds().size();
                        failCount = result.getBillCount() - resultSuccessPkIdCount;
                        pushCount += resultSuccessPkIdCount;
                        message.append(String.format(ResManager.loadKDString((String)"\u91c7\u96c6\u7f16\u7801\u3010%1$s\u3011\u6765\u6e90\u5355\u636e\u3010%2$s\u3011\uff1a\u672c\u6b21\u91c7\u96c6\u6210\u529f%3$d\u5f20\uff0c\u4fdd\u5b58\u5931\u8d25%4$d\u5f20\u3002", (String)"PullPayBillService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, sourceEntityName, successCount, failCount)).append("\r\n");
                        if (result.isSuccess()) continue;
                        this.copyOperationResult(this.operationResult, result);
                        continue;
                    }
                    message.append(String.format(ResManager.loadKDString((String)"\u91c7\u96c6\u7f16\u7801\u3010%1$s\u3011\u6765\u6e90\u5355\u636e\u3010%2$s\u3011\uff1a\u672c\u6b21\u91c7\u96c6\u6210\u529f%3$d\u5f20\uff0c\u4fdd\u5b58\u5931\u8d25%4$d\u5f20\u3002", (String)"PullPayBillService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, sourceEntityName, successCount, failCount, pushCount)).append("\r\n");
                    continue;
                }
                message.append(String.format(ResManager.loadKDString((String)"\u91c7\u96c6\u7f16\u7801\u3010%1$s\u3011\u6765\u6e90\u5355\u636e\u3010%2$s\u3011\uff1a\u672c\u6b21\u91c7\u96c6\u6210\u529f%3$d\u5f20\uff0c\u4fdd\u5b58\u5931\u8d25%4$d\u5f20\u3002", (String)"PullPayBillService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, sourceEntityName, 0, 0, pushCount)).append("\r\n");
            }
            message.append(String.format(ResManager.loadKDString((String)"\u4eca\u65e5\u7d2f\u8ba1\u91c7\u96c6%1$d\u5f20\u3002", (String)"PullPayBillService_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), pushCount));
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                this.operationResult.setShowMessage(true);
                this.operationResult.setMessage(message.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error("pullBill error", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u91c7\u96c6\u53d1\u751f\u5f02\u5e38\uff1a%1$s", (String)"PullPayBillService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            MutexServiceHelper.release((String)"pullbill", (String)this.targetEntityNumber, (String)"pullbill");
        }
        LOGGER.info("PullPayBillService end");
    }

    private void duplicateRemoval(String sourceEntity, String targetEntity, String sourceEntityNumber, Set<Long> ids) {
        Long tTableId = FcaBotpHelper.getTableIdByEntityId((String)targetEntity);
        Long sTableId = FcaBotpHelper.getTableIdByEntityId((String)sourceEntity);
        QFilter qFilter = new QFilter("sbillid", "in", ids).and(new QFilter("stableid", "=", (Object)sTableId)).and(new QFilter("ttableid", "=", (Object)tTableId));
        DynamicObjectCollection billTracker = QueryServiceHelper.query((String)"botp_billtracker", (String)"sbillid", (QFilter[])qFilter.toArray());
        Set sourceIds = billTracker.stream().map(d -> d.getLong("sbillid")).collect(Collectors.toSet());
        LOGGER.info("push sourceIds exist size:{}", (Object)billTracker.size());
        ids.removeAll(sourceIds);
        QFilter qFilter1 = new QFilter("sourcebillentry.sbillid", "in", ids).and(new QFilter("sourcebillentry.sourceentity", "=", (Object)sourceEntityNumber));
        DynamicObjectCollection source = QueryServiceHelper.query((String)this.targetEntityNumber, (String)"sourcebillentry.sbillid", (QFilter[])qFilter1.toArray());
        Set sBillIds = source.stream().map(d -> d.getLong("sourcebillentry.sbillid")).collect(Collectors.toSet());
        LOGGER.info("push sBillIds exist size:{}", (Object)billTracker.size());
        ids.removeAll(sBillIds);
    }

    private int getPushCount(String sourceEntity, Date begin) {
        int pushCount = 0;
        QFilter qFilter = new QFilter("sourcebillentry.sourceentity", "=", (Object)sourceEntity).and(new QFilter("sourcebillentry.pushdate", "=", (Object)begin));
        DataSet billCount = QueryServiceHelper.queryDataSet((String)this.targetEntityNumber, (String)this.targetEntityNumber, (String)"count(distinct id) as billCount", (QFilter[])qFilter.toArray(), (String)"");
        for (Row row : billCount) {
            pushCount = row.getInteger("billCount");
        }
        return pushCount;
    }

    private void copyOperationResult(OperationResult result1, OperationResult result2) {
        ValidateResultCollection validateResultCollection = result2.getValidateResult();
        if (validateResultCollection != null && !validateResultCollection.getValidateErrors().isEmpty()) {
            for (ValidateResult vr : validateResultCollection.getValidateErrors()) {
                result1.getAllErrorOrValidateInfo().addAll(vr.getAllErrorInfo());
            }
            result1.getValidateResult().getValidateErrors().addAll(validateResultCollection.getValidateErrors());
        }
        result1.getAllErrorInfo().addAll(result2.getAllErrorInfo());
    }

    private void copyConvertOperationResult(OperationResult result, ConvertOperationResult convertOperationResult) {
        List sourceBillReports = convertOperationResult.getBillReports();
        ValidateResult validateResult = new ValidateResult();
        List errorInfoList = validateResult.getAllErrorInfo();
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Warning, (Object)"");
        operateErrorInfo.setMessage(convertOperationResult.getMessage());
        for (SourceBillReport sourceBillReport : sourceBillReports) {
            if (!StringUtils.isNotBlank((CharSequence)sourceBillReport.getFailMessage())) continue;
            operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Warning, (Object)"");
            operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\u3010%1$s\u3011\u5355\u636e\u7f16\u53f7\u3010%2$s\u3011\u4e0b\u63a8\u5f02\u5e38\uff1a%3$s", (String)"PullPayBillService_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), sourceBillReport.getRuleName(), sourceBillReport.getBillNo(), sourceBillReport.getFailMessage()));
            errorInfoList.add(operateErrorInfo);
        }
        result.getValidateResult().getValidateErrors().add(validateResult);
    }
}

