/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.autotrans;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class AutoTransCommService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        Map operVariMap = this.getOperationVariable();
        String operateName = (String)operVariMap.get("operName");
        String enable = operateName.equals("disable") ? "1" : "0";
        List intelligentExecuteIds = Stream.of(dataEntities).map(v -> v.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection intelligentExecutes = QueryServiceHelper.query((String)"gl_intellexecschema", (String)"id, sheduleplanid, enable", (QFilter[])new QFilter[]{new QFilter("id", "in", intelligentExecuteIds)});
        Map<Object, DynamicObject> intellExcesIndexMap = intelligentExecutes.stream().collect(Collectors.toMap(p -> p.get("id"), p -> p));
        ArrayList<Object> operateIntelligentExecuteIds = new ArrayList<Object>(dataEntities.length);
        ArrayList<Object> successPkIds = new ArrayList<Object>(dataEntities.length);
        for (DynamicObject autoTrans : dataEntities) {
            DynamicObject intelligentExecute = intellExcesIndexMap.getOrDefault(autoTrans.getPkValue(), null);
            if (null == intelligentExecute) continue;
            if (intelligentExecute.getString("enable").equals(enable)) {
                operateIntelligentExecuteIds.add(autoTrans.getPkValue());
                continue;
            }
            successPkIds.add(autoTrans.getPkValue());
        }
        if (!CollectionUtils.isEmpty(operateIntelligentExecuteIds)) {
            try (TXHandle tx = TX.requiresNew();){
                OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)operateName, (String)"gl_intellexecschema", (Object[])operateIntelligentExecuteIds.toArray(), (OperateOption)OperateOption.create());
                successPkIds.addAll(operationResult.getSuccessPkIds());
            }
        }
        if (!CollectionUtils.isEmpty(successPkIds)) {
            this.handleScheduleAndJobStatus(successPkIds, operateName);
        }
    }

    private void handleScheduleAndJobStatus(List<Object> successPkIds, String operateKey) {
        if (successPkIds != null && !successPkIds.isEmpty()) {
            HashSet<String> scheduleIds = new HashSet<String>(10);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fi_iep_intellaccountschema", (String)"gl_intellexecschema", (String)"id,sheduleplanid", (QFilter[])new QFilter[]{new QFilter("id", "in", successPkIds)}, null);){
                for (DynamicObject[] row : ds) {
                    String scheduleId = row.getString("sheduleplanid");
                    if (!StringUtils.isNotEmpty((CharSequence)scheduleId)) continue;
                    scheduleIds.add(scheduleId);
                }
            }
            if (!scheduleIds.isEmpty()) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sch_schedule");
                DynamicObject[] dySchedules = BusinessDataServiceHelper.load((Object[])scheduleIds.toArray(), (DynamicObjectType)type);
                String status = "enable".equals(operateKey) ? "1" : "0";
                for (DynamicObject dySchedule : dySchedules) {
                    dySchedule.set("status", (Object)status);
                    ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                    boolean isEnable = "enable".equals(operateKey);
                    String scheduleId = (String)dySchedule.getPkValue();
                    if (isEnable) {
                        scheduleManager.enableSchedule(scheduleId);
                        continue;
                    }
                    scheduleManager.disableSchedule(scheduleId);
                }
                try (TXHandle tx = TX.requiresNew();){
                    OperationServiceHelper.executeOperate((String)"save", (String)"sch_schedule", (DynamicObject[])dySchedules, (OperateOption)OperateOption.create());
                }
            }
        }
    }
}

