/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.autotrans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class AutoTransExecService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        List<Object> intellExceIds = Stream.of(dataEntities).map(v -> v.get("id")).collect(Collectors.toList());
        this.excutePlanAsyn(intellExceIds);
    }

    private void excutePlanAsyn(List<Object> schemaIdList) {
        RequestContext rc = RequestContext.get();
        for (Object schemaId : schemaIdList) {
            ArrayList<Object> schemaIdListNew = new ArrayList<Object>();
            schemaIdListNew.add(schemaId);
            DynamicObject schemaDb = QueryServiceHelper.queryOne((String)"gl_intellexecschema", (String)"executor", (QFilter[])new QFilter("id", "=", schemaId).toArray());
            JobInfo job = new JobInfo();
            job.setRunByLang(Lang.get());
            job.setJobType(JobType.BIZ);
            job.setName(rc.getUserName() + " execute job");
            job.setId(Uuid16.create().toString());
            if (schemaDb == null || schemaDb.getLong("executor") == 0L) {
                job.setRunByUserId(Long.parseLong(rc.getUserId()));
            } else {
                job.setRunByUserId(schemaDb.getLong("executor"));
            }
            job.setTaskClassname("kd.fi.iep.task.IntellExceTask");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("intellSchemaidList", this.createJobParam(schemaIdListNew));
            params.put("type", "1");
            job.setParams(params);
            job.setAppId("iep");
            JobClient.dispatch((JobInfo)job);
        }
    }

    private List<Map<String, Object>> createJobParam(List<Object> schemaIdList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(schemaIdList.size());
        for (Object id : schemaIdList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Id", id);
            list.add(map);
        }
        return list;
    }
}

