/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.enums.ExecstatusEnum;
import kd.tmc.fca.common.enums.FcaOperNameEnum;
import kd.tmc.fca.common.enums.FcaTransTypeEnum;
import kd.tmc.fca.common.resource.FcaBizResource;

public class TransBillAutoTransferService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TransBillAutoTransferService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("opername");
        selector.add("number");
        selector.add("type");
        selector.add("name");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        DynamicObject autoTrans = dataEntities[0];
        if (FcaTransTypeEnum.TRANSFER.getValue().equals(autoTrans.getString("type"))) {
            if (FcaOperNameEnum.SAVE_TRANSFER_APPLY.getValue().equals(autoTrans.getString("opername"))) {
                this.createTransferApply(autoTrans);
            } else if (FcaOperNameEnum.SUBMIT_TRANSFER_APPLY.getValue().equals(autoTrans.getString("opername"))) {
                this.createTransferApply(autoTrans);
            } else if (FcaOperNameEnum.SAVE_TRANSFER.getValue().equals(autoTrans.getString("opername"))) {
                this.createTransfer(autoTrans);
            } else if (FcaOperNameEnum.SAVE_TRANSFER_SUBMIT_BEI.getValue().equals(autoTrans.getString("opername"))) {
                // empty if block
            }
        }
    }

    private void createTransferApply(DynamicObject autoTrans) {
        logger.info("\u81ea\u52a8\u5212\u62e8\uff1a\u6267\u884c\u521b\u5efa\u8c03\u62e8\u7533\u8bf7\u5355\uff0c\u53c2\u6570:{}", (Object)autoTrans);
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"fca_autotranslog");
        DynamicObjectCollection entries = this.getEntry(autoTrans);
        if (entries.size() > 0) {
            try (TXHandle tx = TX.requiresNew();){
                List resultList = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"FundTransPushService", (String)"pushTransferApply", (Object[])new Object[]{entries, autoTrans.getString("opername")});
                AtomicInteger index = new AtomicInteger(0);
                AtomicInteger failCount = new AtomicInteger(0);
                this.getEntry(autoTrans).forEach(entry -> {
                    Map result = (Map)resultList.get(index.getAndIncrement());
                    Object pkId = result.get("billno");
                    String message = ResManager.loadKDString((String)"\u8c03\u62e8\u7533\u8bf7\u5355\u5df2\u6210\u529f\u751f\u6210\u3002", (String)"AutoTransResource_0", (String)"tmc-fca-common", (Object[])new Object[0]);
                    Object errorMessage = result.get("errorMessage");
                    if (pkId == null) {
                        failCount.incrementAndGet();
                        message = errorMessage == null ? null : (String)result.get("errorMessage");
                    }
                    this.saveLogEntry(log, (DynamicObject)entry, pkId, message);
                });
                this.saveLog(autoTrans, log, entries.size() - failCount.get(), failCount.get());
            }
        }
    }

    private DynamicObject createTransfer(DynamicObject autoTrans) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"fca_autotranslog");
        DynamicObjectCollection entries = this.getEntry(autoTrans);
        if (entries.size() > 0) {
            entries.forEach(entry -> this.saveLogEntry(log, (DynamicObject)entry, null, null));
            this.saveLog(autoTrans, log, 0, 0);
        }
        return null;
    }

    private void commitBei(DynamicObject transfer) {
        this.createTransfer(transfer);
    }

    private DynamicObjectCollection getEntry(DynamicObject transfer) {
        DynamicObject transferDetail = TmcDataServiceHelper.loadSingle((Object)transfer.getPkValue(), (String)"fca_autotrans");
        return transferDetail.getDynamicObjectCollection("entry");
    }

    private void saveLog(DynamicObject autoTrans, DynamicObject log, int successCount, int failCount) {
        log.set("autotrans", (Object)autoTrans.getString("number"));
        log.set("opername", (Object)autoTrans.getString("opername"));
        log.set("excetime", (Object)new Date());
        log.set("execstatus", (Object)ExecstatusEnum.SUCCESS.getValue());
        log.set("type", (Object)autoTrans.getString("type"));
        log.set("execdetl", (Object)new LocaleString(new FcaBizResource().getAutoTransferLogMain(successCount, failCount, FcaTransTypeEnum.TRANSFER.getName())));
        TmcOperateServiceHelper.execOperate((String)"save", (String)"fca_autotranslog", (DynamicObject[])new DynamicObject[]{log}, (OperateOption)OperateOption.create());
    }

    private void saveLogEntry(DynamicObject log, DynamicObject autoEntry, Object billNo, String msg) {
        DynamicObjectCollection entries = log.getDynamicObjectCollection("entry2");
        DynamicObject entry = entries.addNew();
        entry.set("e_payorg", autoEntry.get("e_payorg"));
        entry.set("e_payeraccbank", autoEntry.get("e_payeraccbank"));
        entry.set("e_paycurrency", autoEntry.get("e_paycurrency"));
        entry.set("e_payee", autoEntry.get("e_payee"));
        entry.set("e_payeeaccbank", autoEntry.get("e_payeeaccbank"));
        entry.set("e_retainedamt", autoEntry.get("e_retainedamt"));
        entry.set("e_transferamt", autoEntry.get("e_transferamt"));
        entry.set("e_status", (Object)(billNo == null ? ExecstatusEnum.FAIL.getValue() : ExecstatusEnum.SUCCESS.getValue()));
        if (!EmptyUtil.isEmpty((String)msg) && msg.length() > 255) {
            msg = msg.substring(0, 255);
        }
        entry.set("e_detail", (Object)msg);
        entry.set("e_billno", billNo);
    }
}

