/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.business.opservice.transbill.observer.BillSyncInfoObservable;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayChanEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.property.DetailStatus;

public class TransBillBeiBackWriteService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TransBillBeiBackWriteService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        long currTime = System.currentTimeMillis();
        String resultStr = (String)this.getOperationVariable().get("result");
        Map res = (Map)SerializationUtils.fromJsonString((String)resultStr, Map.class);
        Map entryRes = (Map)res.get("payDetail");
        boolean hasOfRecord = false;
        if (!EmptyUtil.isEmpty((Object)entryRes) && entryRes.size() > 0) {
            for (Map.Entry en : entryRes.entrySet()) {
                logger.info("TransBillBeiBackWriteService--time: " + currTime + "  key:" + (String)en.getKey() + "  value:" + en.getValue());
            }
            hasOfRecord = entryRes.values().stream().map(o -> (Map)SerializationUtils.fromJsonString((String)o.toString(), Map.class)).anyMatch(o -> BeBillStatusEnum.OF.getValue().equals(o.get("bankPayState")));
        }
        String transBillEntity = dataEntities[0].getDataEntityType().getName();
        Object srcBillId = res.get("srcBillId");
        DynamicObject transBill = BusinessDataServiceHelper.loadSingle(srcBillId, (String)transBillEntity);
        if (hasOfRecord) {
            this.doFcaOnBankBillFail(transBill, entryRes);
        } else {
            HashMap<String, Map> payDetail = new HashMap<String, Map>(entryRes.size());
            for (Map.Entry resEntry : entryRes.entrySet()) {
                String entryId = (String)resEntry.getKey();
                Map entryResMap = (Map)SerializationUtils.fromJsonString((String)resEntry.getValue().toString(), Map.class);
                payDetail.put(entryId, entryResMap);
                if (entryResMap == null || entryResMap.size() <= 0) continue;
                for (Map.Entry en : entryResMap.entrySet()) {
                    logger.info("TransBillBeiBackWriteService--time: " + currTime + "  key:" + (String)en.getKey() + "  value:" + (String)en.getValue());
                }
            }
            Map payDetailMap = DetailStatus.transfor(payDetail);
            new BillSyncInfoObservable(Collections.singletonList(transBill), payDetailMap).syncInfo();
        }
    }

    private void doFcaOnBankBillFail(DynamicObject transBill, Map<String, Object> entryRes) {
        DynamicObjectCollection entries = transBill.getDynamicObjectCollection("entrys");
        HashMap<String, DetailStatus> payDetailMap = new HashMap<String, DetailStatus>();
        for (DynamicObject entry : entries) {
            String state = (String)entry.get("state");
            String payStatus = (String)entry.get("paystatus");
            String paychanel = (String)entry.get("paychanel");
            if (!entryRes.containsKey(entry.getPkValue().toString()) || !FcaTransDetailStatusEnum.NORMAL.getValue().equals(state) || !FcaTransPayStatusEnum.BEIPROC.getValue().equals(payStatus) || !FcaTransPayChanEnum.BEI.getValue().equals(paychanel)) continue;
            DetailStatus ds = new DetailStatus(FcaTransPayStatusEnum.INIT.getValue(), null);
            ds.submitPayTime = null;
            payDetailMap.put(String.valueOf(entry.getPkValue()), ds);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("detailMap", JSON.toJSONString(payDetailMap));
        option.setVariableValue("dateType", transBill.getDataEntityType().getName());
        option.setVariableValue("source", "writeBack");
        TmcOperateServiceHelper.execOperate((String)"sync", (String)transBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{transBill}, (OperateOption)option);
    }
}

