/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fca.business.opservice.transbill.observer.BillCancelPayObserver;
import kd.tmc.fca.business.opservice.transbill.observer.BillSyncInfoObservable;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayChanEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.property.DetailStatus;

public class TransBillCancelPayService
extends AbstractTmcBizOppService {
    private Set<String> selectorStr;

    public TransBillCancelPayService(Set<String> selectorStr) {
        this.selectorStr = selectorStr;
    }

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("state");
        selector.add("paystatus");
        selector.add("paychanel");
        selector.add("iscashbill");
        selector.add("currency");
        selector.add("accountbank");
        selector.add("paydate");
        selector.add("payuser");
        selector.add("subacct");
        selector.add("billstatus");
        selector.add("transsuccount");
        selector.add("transsucamt");
        selector.add("transamt");
        selector.add("submitpaytime");
        selector.add("payreturntime");
        selector.add("payreturninfo");
        selector.add("discard_reason");
        selector.add("discard_user");
        selector.add("discard_time");
        selector.add("discard_time_str");
        selector.add("company");
        selector.add("bizdate");
        selector.add("acctgrpid");
        selector.add("bankcheckflag");
        selector.add("isifmbill");
        selector.add("isinneracccashbill");
        selector.addAll(this.selectorStr);
        selector.add("entrys.isifmbill");
        selector.add("entrys.isinneracccashbill");
        selector.add("entrys.iscashbill");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        if (dataEntities.length == 0) {
            return;
        }
        HashMap<String, DetailStatus> payDetailMap = new HashMap<String, DetailStatus>(16);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
            boolean cancelFlag = false;
            for (DynamicObject entry : entries) {
                String state = entry.getString("state");
                String payStatus = entry.getString("paystatus");
                String paychanel = entry.getString("paychanel");
                entry.set("iscashbill", null);
                entry.set("iscashbill", (Object)"0");
                entry.set("isifmbill", null);
                entry.set("isifmbill", (Object)"0");
                entry.set("isinneracccashbill", null);
                entry.set("isinneracccashbill", (Object)"0");
                if (FcaTransDetailStatusEnum.DISCARD.getValue().equals(state) || FcaTransPayChanEnum.BEI.getValue().equals(paychanel) || !FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus)) continue;
                DetailStatus ds = new DetailStatus();
                payDetailMap.put(entry.getPkValue().toString(), ds);
                ds.setPayStatus(FcaTransPayStatusEnum.INIT.getValue());
                ds.setSubmitPayTime(null);
                ds.setPayDate(null);
                ds.setPayUserId(Long.valueOf(0L));
                cancelFlag = true;
            }
            if (cancelFlag) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u53d6\u6d88\u4ed8\u6b3e\u660e\u7ec6\u3002", (String)"TransBillCancelPayService_0", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
        BillSyncInfoObservable billPayObservable = new BillSyncInfoObservable(Arrays.asList(dataEntities), payDetailMap);
        billPayObservable.addObserver(new BillCancelPayObserver());
        billPayObservable.syncInfo();
    }
}

