/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;

public class TransBillDiscardDetailService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("paychanel");
        selector.add("ischangepaych");
        selector.add("entrys,paystatus");
        selector.add("entrys,discard_reason");
        selector.add("entrys,discard_user");
        selector.add("entrys,discard_time");
        selector.add("entrys,discard_time_str");
        selector.add("entrys,state");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String[] discardIndexs = ((String)this.operationVariable.get("discardIndex")).split(",");
        String reason = (String)this.operationVariable.get("reason");
        HashMap discardIndexMap = new HashMap(discardIndexs.length);
        Date currTime = new Date();
        DynamicObject discardUser = BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        for (String string : discardIndexs) {
            discardIndexMap.put(Integer.valueOf(string), null);
        }
        for (String string : dataEntities) {
            String status = string.getString("billstatus");
            boolean isAllDiscard = true;
            boolean flag = true;
            boolean hasSuccess = false;
            DynamicObjectCollection dbEntities = string.getDynamicObjectCollection("entrys");
            int curIndx = 0;
            for (DynamicObject entity : dbEntities) {
                if (discardIndexMap.containsKey(curIndx++)) {
                    entity.set("discard_reason", (Object)reason);
                    entity.set("discard_user", (Object)discardUser);
                    entity.set("discard_time", (Object)currTime);
                    entity.set("discard_time_str", (Object)DateUtils.formatString((Date)currTime, (String)"yyyyMMdd"));
                    entity.set("state", (Object)FcaTransDetailStatusEnum.DISCARD.getValue());
                    continue;
                }
                String payStatusE = entity.getString("paystatus");
                Object state = entity.get("state");
                if ("back".equals(state)) {
                    status = BillStatusEnum.AUDIT.getValue();
                } else if (!"discard".equals(state)) {
                    isAllDiscard = false;
                }
                if (!FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatusE) && !"discard".equals(state)) {
                    flag = false;
                }
                if (!FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatusE)) continue;
                hasSuccess = true;
            }
            if (BillStatusEnum.AUDIT.getValue().equals(status)) {
                string.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            }
            if (isAllDiscard) {
                string.set("billstatus", (Object)BillStatusEnum.DISCARD.getValue());
            }
            if (!hasSuccess || !flag) continue;
            string.set("billstatus", (Object)BillStatusEnum.PAYED.getValue());
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("discardFlag", "1");
        TmcOperateServiceHelper.execOperate((String)"save", (String)dataEntities[0].getDataEntityType().getName(), (DynamicObject[])dataEntities, (OperateOption)op);
    }
}

