/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.business.service.WriteDetailParam;
import kd.tmc.fca.common.enums.ReceredWayEnum;
import kd.tmc.fca.common.helper.TransBillHelper;

public class TransBillSaveService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(TransBillSaveService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("transamt");
        selector.add("amount");
        selector.add("createtime");
        selector.add("modifytime");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        LOGGER.info("TransBillSaveService begin");
        HashMap<Long, HashMap<String, Object>> recInfo = new HashMap<Long, HashMap<String, Object>>(4);
        List list = Arrays.stream(dataEntities).map(d -> d.getDynamicObjectCollection("entrys")).flatMap(e -> e.stream().filter(d -> d.getDynamicObject("inneracctbank") == null && d.getDynamicObject("subacct") != null)).collect(Collectors.toList());
        Map orgInnerAccountMap = new HashMap(16);
        Map innerAcctMap = new HashMap(1);
        if (!list.isEmpty()) {
            Set set = list.stream().map(r -> r.getDynamicObject("subacct").getPkValue()).collect(Collectors.toSet());
            orgInnerAccountMap = TransBillHelper.getInnerAccount(set);
            HashSet innerAccounts = new HashSet(16);
            for (Map map : orgInnerAccountMap.values()) {
                map.forEach((k, v) -> innerAccounts.add(v));
            }
            innerAcctMap = TransBillHelper.getBankAcctByInnerAcct(innerAccounts);
        }
        for (DynamicObject data : dataEntities) {
            boolean isPush;
            if ("true".equals(this.operationVariable.get("byAutoTrans"))) {
                data.set("createtime", data.get("modifytime"));
            }
            DynamicObjectCollection details = data.getDynamicObjectCollection("entrys");
            BigDecimal amount = details.stream().filter(Objects::nonNull).map(o -> o.getBigDecimal("transamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            data.set("amount", (Object)amount);
            Long acctSonId = this.fillByWork(data, recInfo);
            DynamicObjectCollection entryCol = data.getDynamicObjectCollection("entrys");
            DynamicObject company = data.getDynamicObject("company");
            DynamicObject currency = data.getDynamicObject("currency");
            BigDecimal payAmount = data.getBigDecimal("amount");
            String source = data.getString("sourcetype");
            boolean bl = isPush = "paypassive".equals(source) || "recinitiative".equals(source);
            if (isPush) {
                data.set("matchamount", (Object)payAmount);
                data.set("unmatchamount", (Object)BigDecimal.ZERO);
                data.set("matchflag", (Object)"1");
            } else if (data.getString("matchflag") == null || data.getString("matchflag").trim().length() < 1 || "0".equals(data.getString("matchflag"))) {
                data.set("matchamount", (Object)BigDecimal.ZERO);
                data.set("unmatchamount", (Object)payAmount);
                data.set("matchflag", (Object)"0");
            }
            for (DynamicObject entry : entryCol) {
                DynamicObjectCollection currencies;
                List currencyIdList;
                BigDecimal transAmount = entry.getBigDecimal("transamt");
                if (isPush) {
                    entry.set("entrymatchamount", (Object)transAmount);
                    entry.set("entryunmatchamount", (Object)BigDecimal.ZERO);
                    entry.set("entrymatchflag", (Object)"1");
                } else if (entry.getString("entrymatchflag") == null || entry.getString("entrymatchflag").trim().length() < 1 || "0".equals(entry.getString("entrymatchflag"))) {
                    entry.set("entrymatchamount", (Object)BigDecimal.ZERO);
                    entry.set("entryunmatchamount", (Object)transAmount);
                    entry.set("entrymatchflag", (Object)"0");
                }
                DynamicObject subAccount = acctSonId == null ? entry.getDynamicObject("subacct") : BusinessDataServiceHelper.loadSingle((Object)acctSonId, (String)"bd_accountbanks");
                if (company == null || currency == null || !orgInnerAccountMap.containsKey(company.getPkValue()) || subAccount == null || entry.get("inneracctbank") != null) continue;
                DynamicObject innerAccount = (DynamicObject)((Map)orgInnerAccountMap.get(company.getPkValue())).get(subAccount.getPkValue());
                if (innerAccount != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                    innerAccount = null;
                }
                if (innerAccount == null || innerAcctMap == null) continue;
                entry.set("inneracctbank", innerAcctMap.get(innerAccount.getPkValue()));
            }
        }
        if (recInfo.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(recInfo.size());
            for (Map.Entry entry : recInfo.entrySet()) {
                arrayList.add(String.valueOf(entry.getKey()));
            }
            WriteDetailParam param = new WriteDetailParam();
            param.setRecInfo(recInfo);
            ECGlobalSession.begin((String)"WRITE_DETAIL_FCA", (DBRoute)DBRoute.of((String)"tmc"), (boolean)true);
            ECGlobalSession.setAsync((boolean)true);
            ECGlobalSession.setBusinessType((String)"workbench");
            ECGlobalSession.setBusinessInfo(arrayList);
            ECGlobalSession.register((String)"tmc", (String)"fca", (String)"WriteDetailService", (Param)param, null, (String)"");
        }
        LOGGER.info("TransBillSaveService end");
    }

    private Long fillByWork(DynamicObject data, HashMap<Long, HashMap<String, Object>> recInfo) {
        String source = data.getString("sourcetype");
        boolean isPush = "paypassive".equals(source) || "recinitiative".equals(source);
        boolean isFromDB = data.getDataEntityState().getFromDatabase();
        if (!isPush || isFromDB) {
            return null;
        }
        if (data.getDynamicObjectCollection("entrys").isEmpty()) {
            return null;
        }
        String ruleWay = "";
        String ruleName = "";
        String entityName = data.getDataEntityType().getName();
        String type = "pay";
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"fca_transupbill")) {
            type = "rec";
        }
        DynamicObject currency = data.getDynamicObject("currency");
        DynamicObject detail = (DynamicObject)data.getDynamicObjectCollection("entrys").get(0);
        Long sonAccId = null;
        if (detail.getDynamicObject("subacct") != null) {
            sonAccId = detail.getDynamicObject("subacct").getLong("id");
        }
        QFilter currencyQFilter = null;
        if (currency != null) {
            currencyQFilter = new QFilter("currency", "=", currency.getPkValue());
        }
        Long group = null;
        if (this.getOperationVariable().containsKey("returnDataByOpHand")) {
            DynamicObject acctGroup;
            Long id;
            ruleWay = ReceredWayEnum.HAND.getValue();
            String returnDataByOpHand = (String)this.getOperationVariable().get("returnDataByOpHand");
            HashMap map = (HashMap)SerializationUtils.fromJsonString((String)returnDataByOpHand, Map.class);
            if (map.containsKey("e_remark") && EmptyUtil.isNoEmpty(map.get("e_remark"))) {
                detail.set("remark", map.get("e_remark"));
            }
            if (map.containsKey("sonacct") && (id = (Long)map.get("sonacct")) != null && id != 0L) {
                sonAccId = id;
            }
            DynamicObject sonAcct = BusinessDataServiceHelper.loadSingle((Object)sonAccId, (String)"bd_accountbanks");
            detail.set("subacct", (Object)sonAcct);
            if (sonAcct != null) {
                detail.set("subacct_company", (Object)sonAcct.getDynamicObject("company"));
            }
            if (map.containsKey("group")) {
                group = (Long)map.get("group");
                acctGroup = BusinessDataServiceHelper.loadSingle((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)group)});
                data.set("acctgrpid", (Object)acctGroup);
            }
            if (group == null) {
                acctGroup = BusinessDataServiceHelper.loadSingle((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("entrys.bankacct", "=", (Object)sonAccId), currencyQFilter});
                data.set("acctgrpid", (Object)acctGroup);
            }
        } else {
            DynamicObject acctGroup;
            DynamicObject sonAcct = BusinessDataServiceHelper.loadSingle((Object)sonAccId, (String)"bd_accountbanks");
            detail.set("subacct", (Object)sonAcct);
            if (sonAcct != null) {
                detail.set("subacct_company", (Object)sonAcct.getDynamicObject("company"));
            }
            if ((acctGroup = BusinessDataServiceHelper.loadSingle((String)"fca_acctgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("entrys.bankacct", "=", (Object)sonAccId), currencyQFilter})) != null) {
                data.set("acctgrpid", (Object)acctGroup);
            }
            ruleWay = ReceredWayEnum.RULE.getValue();
            ruleName = detail.getString("e_rule_name");
        }
        this.writeInfoBeiRecInfoBei(ruleWay, ruleName, data, detail, type, recInfo);
        return sonAccId;
    }

    private void writeInfoBeiRecInfoBei(String ruleWay, String ruleName, DynamicObject bill, DynamicObject detail, String type, HashMap<Long, HashMap<String, Object>> recInfo) {
        if (0L == detail.getLong("id")) {
            detail.set("id", (Object)DB.genLongId((String)"t_fca_transdownbill_entry"));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("recedbilltype", bill.getDataEntityType().getName());
        map.put("recedbillnumber", bill.getString("billno"));
        map.put("recedbillid", bill.getLong("id"));
        map.put("recedbillentryid", detail.getLong("id"));
        map.put("amttype", "");
        map.put("ruleWay", ruleWay);
        map.put("ruleName", ruleName);
        map.put("way", type);
        recInfo.put(bill.getLong("sourcebillid"), map);
    }
}

