/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fca.business.opservice.transbill.observer.BillSyncInfoObservable;
import kd.tmc.fca.business.opservice.transbill.observer.BillSyncObserver;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.helper.TransBillPushHelper;
import kd.tmc.fca.common.property.DetailStatus;

public class TransBillSyncStateService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(TransBillSyncStateService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.addAll(TransBillPushHelper.buildSelectors());
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String detail = (String)this.getOperationVariable().get("detailMap");
        Map payDetailMap = (Map)JSON.parseObject((String)detail, (TypeReference)new TypeReference<Map<String, DetailStatus>>(){}, (Feature[])new Feature[0]);
        for (DynamicObject data : dataEntities) {
            for (DynamicObject entry : data.getDynamicObjectCollection("entrys")) {
                if (payDetailMap.get(entry.getPkValue().toString()) == null) continue;
                String payStatus = ((DetailStatus)payDetailMap.get(entry.getPkValue().toString())).getPayStatus();
                boolean isBitBack = ((DetailStatus)payDetailMap.get(entry.getPkValue().toString())).isBitBack();
                String bitBackOpinion = ((DetailStatus)payDetailMap.get(entry.getPkValue().toString())).getBitbackopinion();
                LOGGER.info("isrepulsed\uff1a{};repulsedreason\uff1a{}", (Object)isBitBack, (Object)bitBackOpinion);
                data.set("isrepulsed", (Object)isBitBack);
                data.set("repulsedreason", (Object)bitBackOpinion);
                if (!FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus) && "1".equals(entry.getString("iscashbill"))) {
                    entry.set("iscashbill", (Object)"0");
                }
                if (!FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus) && "1".equals(entry.getString("isifmbill"))) {
                    entry.set("isifmbill", (Object)"0");
                }
                if (FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus) || !"1".equals(entry.getString("isinneracccashbill"))) continue;
                entry.set("isinneracccashbill", (Object)"0");
            }
        }
        BillSyncInfoObservable billPayObservable = new BillSyncInfoObservable(Arrays.asList(dataEntities), payDetailMap);
        billPayObservable.addObserver(new BillSyncObserver());
        billPayObservable.syncInfo();
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        TmcOperateServiceHelper.execOperate((String)"synctrigger", (String)dataEntities[0].getDataEntityType().getName(), (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
    }
}

