/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill.observer;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fca.business.opservice.transbill.observer.BillSyncInfoObservable;
import kd.tmc.fca.business.opservice.transbill.tx.BranchCodeEnum;
import kd.tmc.fca.business.opservice.transbill.tx.branch.TransferBillSyncMainBranch;
import kd.tmc.fca.common.helper.TransBillHelper;

public class BillPayObserver
implements Observer {
    private static final Log LOGGER = LogFactory.getLog(BillPayObserver.class);
    private static final String SCENES_CODE = "fca_pay";

    @Override
    public void update(Observable o, Object arg) {
        LOGGER.info("BillPayObserver update begin");
        List<DynamicObject> billList = ((BillSyncInfoObservable)o).getBillList();
        if (billList != null && !billList.isEmpty()) {
            List<DynamicObject> isInnerAccountList = billList.stream().filter(TransBillHelper::isInnerAcctTrans).collect(Collectors.toList());
            List<DynamicObject> noInnerAccountList = billList.stream().filter(b -> !TransBillHelper.isInnerAcctTrans((DynamicObject)b)).collect(Collectors.toList());
            if (!isInnerAccountList.isEmpty()) {
                new TransferBillSyncMainBranch(BranchCodeEnum.PUSH_IFM).invoke(isInnerAccountList, (String)null);
                new TransferBillSyncMainBranch(BranchCodeEnum.PUSH_INNER_CAS).invoke(isInnerAccountList, SCENES_CODE);
            }
            if (!noInnerAccountList.isEmpty()) {
                new TransferBillSyncMainBranch(BranchCodeEnum.BOOK_JOURNAL).invoke(noInnerAccountList, SCENES_CODE);
            }
            new TransferBillSyncMainBranch(BranchCodeEnum.PUSH_CAS).invoke(billList, SCENES_CODE);
        }
        LOGGER.info("BillPayObserver update end");
    }
}

