/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill.tx;

import java.util.EnumMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fca.business.opservice.transbill.tx.BranchCodeEnum;
import kd.tmc.fca.business.opservice.transbill.tx.branch.BookJournalBranchService;
import kd.tmc.fca.business.opservice.transbill.tx.branch.Branch;
import kd.tmc.fca.business.opservice.transbill.tx.branch.DeleteCasBranchService;
import kd.tmc.fca.business.opservice.transbill.tx.branch.DeleteIfmBranchService;
import kd.tmc.fca.business.opservice.transbill.tx.branch.DeleteInnerCasBranchService;
import kd.tmc.fca.business.opservice.transbill.tx.branch.DeleteJournalBranchService;
import kd.tmc.fca.business.opservice.transbill.tx.branch.PushCasBranchService;
import kd.tmc.fca.business.opservice.transbill.tx.branch.PushIfmBranchService;
import kd.tmc.fca.business.opservice.transbill.tx.branch.PushInnerCasBranchService;

public class BranchServiceFactory {
    private static final EnumMap<BranchCodeEnum, Branch<List<DynamicObject>>> BRANCH_MAP = new EnumMap(BranchCodeEnum.class);

    public static Branch<List<DynamicObject>> getBranchService(BranchCodeEnum branchEnum) {
        return BRANCH_MAP.get(branchEnum);
    }

    private BranchServiceFactory() {
        throw new IllegalStateException("Utility class");
    }

    static {
        BRANCH_MAP.put(BranchCodeEnum.PUSH_CAS, new PushCasBranchService());
        BRANCH_MAP.put(BranchCodeEnum.PUSH_INNER_CAS, new PushInnerCasBranchService());
        BRANCH_MAP.put(BranchCodeEnum.PUSH_IFM, new PushIfmBranchService());
        BRANCH_MAP.put(BranchCodeEnum.BOOK_JOURNAL, new BookJournalBranchService());
        BRANCH_MAP.put(BranchCodeEnum.DELETE_CAS, new DeleteCasBranchService());
        BRANCH_MAP.put(BranchCodeEnum.DELETE_INNER_CAS, new DeleteInnerCasBranchService());
        BRANCH_MAP.put(BranchCodeEnum.DELETE_IFM, new DeleteIfmBranchService());
        BRANCH_MAP.put(BranchCodeEnum.DELETE_JOURNAL, new DeleteJournalBranchService());
    }
}

