/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill.tx;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fca.business.opservice.transbill.bean.CallbackParam;
import kd.tmc.fca.business.opservice.transbill.bean.SyncParam;
import kd.tmc.fca.business.opservice.transbill.tx.BranchServiceFactory;
import kd.tmc.fca.business.opservice.transbill.tx.LockService;
import kd.tmc.fca.business.opservice.transbill.tx.branch.Branch;

public class SyncTxService
extends EventualConsistencyService {
    private static final Log LOGGER = LogFactory.getLog(SyncTxService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DtxResponse execute(Object param, Object lastReturn) {
        LOGGER.info("SyncTxService execute begin");
        if (param == null) {
            return new CommonDtxResponse();
        }
        SyncParam p = (SyncParam)param;
        LOGGER.info("SyncTxService execute SyncParam:{}", (Object)p.toString());
        Set<String> successIds = null;
        boolean isInterrupt = !"fca_transupbill".equals(p.getEntityName());
        LockService lockService = new LockService(isInterrupt);
        try {
            successIds = lockService.startNetworkCtrl(p.getPkIdList().stream().map(String::valueOf).collect(Collectors.toSet()), p.getEntityName(), p.getBranchCode().getValue(), p.getBranchCode().getName());
            Branch<List<DynamicObject>> branch = BranchServiceFactory.getBranchService(p.getBranchCode());
            if (branch != null) {
                branch.transactionInvoke(p);
            }
        }
        finally {
            LOGGER.info("branchCode:{},mutex successIds:{}", (Object)p.getBranchCode().getValue(), successIds);
            if (successIds != null && !successIds.isEmpty()) {
                lockService.releaseDataMutex(successIds, p.getEntityName(), p.getBranchCode().getValue());
            }
        }
        CommonDtxResponse response = new CommonDtxResponse();
        response.put((Object)"param", (Object)SerializationUtils.toJsonString((Object)new CallbackParam(p)));
        LOGGER.info("SyncTxService end ");
        return response;
    }
}

