/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill.tx.branch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fca.business.opservice.transbill.bean.SyncParam;
import kd.tmc.fca.business.opservice.transbill.tx.BranchCodeEnum;
import kd.tmc.fca.business.opservice.transbill.tx.branch.Branch;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.helper.TransBillHelper;
import kd.tmc.fca.common.helper.TransBillPushHelper;

public class DeleteInnerCasBranchService
implements Branch<List<DynamicObject>> {
    private static final Log LOGGER = LogFactory.getLog(DeleteInnerCasBranchService.class);

    @Override
    public void operation(List<DynamicObject> billList, String scenesCode) {
        String entityName;
        String targetEntityName;
        DynamicObjectCollection casBills;
        List<Object> toCancelledBillIds;
        LOGGER.info("DeleteInnerCasBranchService operation begin");
        if (billList == null || billList.isEmpty()) {
            return;
        }
        HashSet<Object> pkIdList = new HashSet<Object>(10);
        HashSet<String> pkIdStringList = new HashSet<String>(10);
        ArrayList<Object> cancelledEntryIds = new ArrayList<Object>(10);
        for (DynamicObject transBill : billList) {
            if (!TransBillHelper.isInnerAcctTrans((DynamicObject)transBill)) continue;
            DynamicObjectCollection entries = transBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                String payStatus = (String)entry.get("paystatus");
                if (!FcaTransPayStatusEnum.PAYFAIL.getValue().equals(payStatus) && !FcaTransPayStatusEnum.INIT.getValue().equals(payStatus) || !"0".equals(entry.getString("isinneracccashbill"))) continue;
                cancelledEntryIds.add(entry.getPkValue());
                pkIdList.add(transBill.getPkValue());
                pkIdStringList.add(String.valueOf(transBill.getPkValue()));
            }
        }
        if (!cancelledEntryIds.isEmpty() && !(toCancelledBillIds = (casBills = QueryServiceHelper.query((String)(targetEntityName = TransBillPushHelper.getInnerAccTransCasTargetEntityName((String)(entityName = billList.get(0).getDataEntityType().getName()))), (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)entityName), new QFilter("sourcebillid", "in", pkIdList), new QFilter("entry.e_sourcebillentryid", "in", cancelledEntryIds)})).stream().map(d -> d.get("id")).distinct().collect(Collectors.toList())).isEmpty()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("byfca", "true");
            operateOption.setVariableValue("currbizappid", "cas");
            operateOption.setVariableValue("ishasright", "true");
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)this.getOpKey(targetEntityName), (String)targetEntityName, (Object[])toCancelledBillIds.toArray(), (OperateOption)operateOption);
            if (!operationResult.isSuccess()) {
                throw new KDBizException(operationResult.getMessage());
            }
            SyncParam syncParam = new SyncParam(new ArrayList<Object>(pkIdList), cancelledEntryIds, entityName, toCancelledBillIds, targetEntityName, this.getBranchCodeEnum());
            if (StringUtils.isNotBlank((CharSequence)scenesCode)) {
                ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)"tmc"), (boolean)true);
                ECGlobalSession.setBusinessType((String)"transfer_sync");
                ECGlobalSession.setAsync((boolean)true);
                ECGlobalSession.setBusinessInfo(new ArrayList(pkIdStringList));
                ECGlobalSession.register((String)"tmc", (String)"fca", (String)"syncTxService", (Param)syncParam, (String)this.getBranchCodeEnum().getValue(), new ArrayList(pkIdStringList));
            } else {
                try {
                    LOGGER.info("DeleteInnerCasBranchService operation SyncParam:{}", (Object)syncParam.toString());
                    this.transactionInvoke(syncParam);
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
            }
        }
        LOGGER.info("DeleteInnerCasBranchService operation end");
    }

    @Override
    public void transactionInvoke(Param param) {
        SyncParam p = (SyncParam)param;
        Long[] billIds = p.getTargetPkIdList().toArray(new Long[0]);
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"FundTransPushService", (String)"cancelPay", (Object[])new Object[]{p.getTargetEntityName(), billIds});
    }

    @Override
    public void callBack(Param param) {
    }

    @Override
    public BranchCodeEnum getBranchCodeEnum() {
        return BranchCodeEnum.DELETE_INNER_CAS;
    }

    private String getOpKey(String entityNumber) {
        return "cas_paybill".equals(entityNumber) ? "validcancelpay" : "validvancelrec";
    }
}

