/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill.tx.branch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fca.business.opservice.transbill.tx.BranchCodeEnum;
import kd.tmc.fca.business.opservice.transbill.tx.BranchServiceFactory;
import kd.tmc.fca.business.opservice.transbill.tx.branch.AbstractBranch;

public class TransferBillSyncMainBranch
extends AbstractBranch<List<DynamicObject>> {
    private static final Log LOGGER = LogFactory.getLog(AbstractBranch.class);
    private boolean isInterrupt = true;

    public TransferBillSyncMainBranch(BranchCodeEnum branchCodeEnum) {
        super(BranchServiceFactory.getBranchService(branchCodeEnum));
    }

    public TransferBillSyncMainBranch(BranchCodeEnum branchCodeEnum, boolean isInterrupt) {
        super(BranchServiceFactory.getBranchService(branchCodeEnum));
        this.isInterrupt = isInterrupt;
    }

    @Override
    public void invoke(List<DynamicObject> billList, String scenesCode) {
        LOGGER.info("AbstractBranch syncInvoker begin");
        if (billList == null || billList.isEmpty()) {
            return;
        }
        if (this.isInterrupt) {
            String entityName = billList.get(0).getDataEntityType().getName();
            Map<String, String> pkIdNumberMap = billList.stream().collect(Collectors.toMap(b -> String.valueOf(b.getPkValue()), b -> b.getString("billno")));
            ArrayList<String> pkIdList = new ArrayList<String>(pkIdNumberMap.keySet());
            ArrayList<String> requestIds = new ArrayList<String>();
            ArrayList<String> requestFailIds = new ArrayList<String>();
            try {
                Map lockResultMap = MutexServiceHelper.batchRequest(pkIdList, (String)entityName, (String)this.branch.getBranchCodeEnum().getValue());
                for (Map.Entry entry : lockResultMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (Boolean.TRUE.equals(entry.getValue())) {
                        requestIds.add(key);
                        continue;
                    }
                    requestFailIds.add(key);
                }
                if (!requestFailIds.isEmpty()) {
                    StringBuilder requestFailBuild = new StringBuilder();
                    for (String requestFailId : requestFailIds) {
                        requestFailBuild.append(pkIdNumberMap.get(requestFailId));
                        requestFailBuild.append(",");
                    }
                    String string = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\uff0c\u5355\u636e\u3010%2$s\u3011 \u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BillPayBranch_0", (String)"tmc-fca-business", (Object[])new Object[0]), this.branch.getBranchCodeEnum().getName(), requestFailBuild.substring(0, requestFailBuild.length() - 1));
                    throw new KDBizException(string);
                }
                this.branch.operation(billList, scenesCode);
            }
            catch (Exception e) {
                LOGGER.error("AbstractSynchronous invoker error:", (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\uff0c\u5206\u652f\u4e8b\u52a1\u6267\u884c\u5f02\u5e38\uff1a\u3010%2$s\u3011\u3002", (String)"BillPayBranch_1", (String)"tmc-fca-business", (Object[])new Object[0]), this.branch.getBranchCodeEnum().getName(), e.getMessage()));
            }
            finally {
                MutexServiceHelper.batchRelease(requestIds, (String)entityName, (String)this.branch.getBranchCodeEnum().getValue());
            }
        }
        try {
            this.branch.operation(billList, scenesCode);
        }
        catch (Exception e) {
            LOGGER.error("AbstractSynchronous invoker error:", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\uff0c\u5206\u652f\u4e8b\u52a1\u6267\u884c\u5f02\u5e38\uff1a\u3010%2$s\u3011\u3002", (String)"BillPayBranch_1", (String)"tmc-fca-business", (Object[])new Object[0]), this.branch.getBranchCodeEnum().getName(), e.getMessage()));
        }
    }
}

