/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill.tx.branch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fca.business.opservice.transbill.tx.BranchCodeEnum;
import kd.tmc.fca.business.opservice.transbill.tx.BranchServiceFactory;
import kd.tmc.fca.business.opservice.transbill.tx.LockService;
import kd.tmc.fca.business.opservice.transbill.tx.branch.AbstractBranch;

public class TransferBillSyncWaitMainBranch
extends AbstractBranch<List<DynamicObject>> {
    private static final Log LOGGER = LogFactory.getLog(AbstractBranch.class);
    private final BranchCodeEnum branchCodeEnum;
    private boolean isInterrupt = true;

    public TransferBillSyncWaitMainBranch(BranchCodeEnum branchCodeEnum) {
        super(BranchServiceFactory.getBranchService(branchCodeEnum));
        this.branchCodeEnum = branchCodeEnum;
    }

    public TransferBillSyncWaitMainBranch(BranchCodeEnum branchCodeEnum, boolean isInterrupt) {
        super(BranchServiceFactory.getBranchService(branchCodeEnum));
        this.branchCodeEnum = branchCodeEnum;
        this.isInterrupt = isInterrupt;
    }

    @Override
    public void invoke(List<DynamicObject> billList, String scenesCode) {
        LOGGER.info("AbstractBranch syncInvoker begin");
        if (billList == null || billList.isEmpty()) {
            return;
        }
        Set<String> successIds = null;
        String entityName = billList.get(0).getDataEntityType().getName();
        LockService lockService = new LockService(this.isInterrupt);
        try {
            Map<String, String> pkIdNumberMap = billList.stream().collect(Collectors.toMap(b -> String.valueOf(b.getPkValue()), b -> b.getString("billno")));
            ArrayList<String> pkIdList = new ArrayList<String>(pkIdNumberMap.keySet());
            successIds = lockService.startNetworkCtrl(new HashSet<String>(pkIdList), entityName, this.branchCodeEnum.getValue(), this.branchCodeEnum.getName());
            this.branch.operation(billList, scenesCode);
        }
        catch (Exception e) {
            try {
                LOGGER.error("AbstractSynchronous invoker error:", (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\uff0c\u5206\u652f\u4e8b\u52a1\u6267\u884c\u5f02\u5e38\uff1a\u3010%2$s\u3011\u3002", (String)"BillPayBranch_1", (String)"tmc-fca-business", (Object[])new Object[0]), this.branch.getBranchCodeEnum().getName(), e.getMessage()));
            }
            catch (Throwable throwable) {
                LOGGER.info("branchCode:{},mutex successIds:{}", (Object)this.branchCodeEnum.getValue(), successIds);
                if (successIds != null && !successIds.isEmpty()) {
                    lockService.releaseDataMutex(successIds, entityName, this.branchCodeEnum.getValue());
                }
                throw throwable;
            }
        }
        LOGGER.info("branchCode:{},mutex successIds:{}", (Object)this.branchCodeEnum.getValue(), successIds);
        if (successIds != null && !successIds.isEmpty()) {
            lockService.releaseDataMutex(successIds, entityName, this.branchCodeEnum.getValue());
        }
    }
}

