/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.service.match.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.builder.FormulaGetHandle;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.SingleTaskContext;
import kd.tmc.fca.business.service.match.IMatchDataTransfer;
import kd.tmc.fca.business.service.match.IMatchRuleService;
import kd.tmc.fca.business.service.match.bean.MatchBean;
import kd.tmc.fca.business.service.match.bean.MatchResultBean;
import kd.tmc.fca.common.concurrent.SplitThreadOperationExecutor;

public class MatchRuleServiceImpl
implements IMatchRuleService {
    private static final Log LOGGER = LogFactory.getLog(MatchRuleServiceImpl.class);
    private final IMatchDataTransfer transfer;

    public MatchRuleServiceImpl(IMatchDataTransfer transfer) {
        this.transfer = transfer;
    }

    @Override
    public List<MatchResultBean> match() {
        LOGGER.info("match begin");
        return this.matchProcess(this.transfer.buildMatchBean());
    }

    private List<MatchResultBean> matchProcess(List<MatchBean> matchBeanList) {
        LOGGER.info("matchProcess begin matchBeanList:{}", matchBeanList);
        ArrayList<MatchResultBean> matchResultList = new ArrayList<MatchResultBean>();
        if (matchBeanList == null) {
            return matchResultList;
        }
        SplitThreadOperationExecutor splitThreadOperationExecutor = new SplitThreadOperationExecutor();
        for (MatchBean bean : matchBeanList) {
            List list = splitThreadOperationExecutor.doBatchOperation(bean.getBillList(), 100, billList -> {
                LOGGER.info("splitThreadOperationExecutor doBatchOperation begin");
                ArrayList resultList = new ArrayList();
                billList.forEach(bill -> {
                    DynamicObject accountGroup;
                    DynamicObject matchRule;
                    MatchResultBean matchResultBean = new MatchResultBean(bill.getLong("id"));
                    if (bean.getMainOrgRule() != null) {
                        matchRule = this.getMatchRule((DynamicObject)bill, bean.getMainOrgRule());
                        if (matchRule != null) {
                            matchResultBean.setRuleId(bean.getMainOrgRule().getPkValue());
                            matchResultBean.setEntryRuleId(matchRule.getPkValue());
                            if (matchRule.getDynamicObject("e_acctgroup") != null) {
                                matchResultBean.getData().put("e_acctgroup", matchRule.getDynamicObject("e_acctgroup"));
                            }
                        }
                    } else if (bean.getCommonRule() != null && (matchRule = this.getMatchRule((DynamicObject)bill, bean.getCommonRule())) != null) {
                        matchResultBean.setRuleId(bean.getCommonRule().getPkValue());
                        matchResultBean.setEntryRuleId(matchRule.getPkValue());
                        if (matchRule.getDynamicObject("e_acctgroup") != null) {
                            matchResultBean.getData().put("e_acctgroup", matchRule.getDynamicObject("e_acctgroup"));
                        }
                    }
                    if (matchResultBean.getData().isEmpty() && (accountGroup = this.findAccountGroup((DynamicObject)bill)) != null) {
                        matchResultBean.getData().put("e_acctgroup", accountGroup);
                    }
                    resultList.add(matchResultBean);
                });
                return resultList;
            });
            matchResultList.addAll(list);
        }
        LOGGER.info("matchProcess end result:{}", matchResultList);
        return matchResultList;
    }

    private DynamicObject getMatchRule(DynamicObject bill, DynamicObject rule) {
        if (rule != null && rule.getBoolean("enable")) {
            DynamicObjectCollection entryEntity = rule.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                Map<String, DynamicProperty> fldProperties;
                String filterString = this.transfer.getFilterStringMap().get(entry.getPkValue());
                if (!this.isMatchRule(filterString, bill, fldProperties = this.buildFilterProperties(bill))) continue;
                return entry;
            }
        }
        return null;
    }

    private boolean isMatchRule(String filterString, DynamicObject detailDy, Map<String, DynamicProperty> fldProperties) {
        boolean isMatchRule = false;
        if (StringUtils.isNotBlank((CharSequence)filterString)) {
            try {
                SingleTaskContext taskContext = new SingleTaskContext();
                taskContext.setSrcEntityType((MainEntityType)this.transfer.getBillEntityType());
                FormulaGetHandle baseBillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, filterString, (Object)Boolean.FALSE);
                boolean baseBoolean = (Boolean)baseBillFilterHandle.GetVchFldValue(fldProperties, detailDy, null);
                if (baseBoolean) {
                    isMatchRule = true;
                }
            }
            catch (Exception e) {
                LOGGER.error("match error:", (Throwable)e);
            }
        } else {
            isMatchRule = true;
        }
        return isMatchRule;
    }

    public Map<String, DynamicProperty> buildFilterProperties(DynamicObject bill) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(bill.getDataEntityType().getProperties().size());
        DynamicObjectType dType = bill.getDynamicObjectType();
        DataEntityPropertyCollection dataEntityProperties = bill.getDataEntityType().getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityProperties) {
            fldProperties.put(dataEntityProperty.getName(), dType.getProperty(dataEntityProperty.getName()));
        }
        return fldProperties;
    }

    private DynamicObject findAccountGroup(DynamicObject bill) {
        LOGGER.info("findAccountGroup begin bill:{}", (Object)bill.getLong("id"));
        long currency = bill.getLong("currency.id");
        long sonAcct = bill.getLong("entrys.subacct.id");
        if (currency != 0L && sonAcct != 0L) {
            Optional<DynamicObject> optional;
            QFilter enableFilter;
            QFilter currFilter;
            QFilter accountFilter = new QFilter("entrys.bankacct", "=", (Object)sonAcct);
            DynamicObject[] acctGroups = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"id, company, accountbank, isdefault", (QFilter[])new QFilter[]{accountFilter, currFilter = new QFilter("currency", "=", (Object)currency), enableFilter = new QFilter("enable", "=", (Object)"1")}, (String)"isdefault desc");
            if (acctGroups.length == 1) {
                return acctGroups[0];
            }
            if (acctGroups.length > 1 && (optional = Arrays.stream(acctGroups).filter(a -> a.getBoolean("isdefault")).findFirst()).isPresent()) {
                return optional.get();
            }
        }
        LOGGER.info("findAccountGroup end bill:{}", (Object)bill.getLong("id"));
        return null;
    }
}

