/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.service.match.transfer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.ext.tmc.utils.helper.ConditionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.compiler.ConvertRuleCompiler;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fca.business.service.match.IMatchDataTransfer;
import kd.tmc.fca.business.service.match.bean.MatchBean;

public abstract class AbstractMatchDataTransfer
implements IMatchDataTransfer {
    private static final Log LOGGER = LogFactory.getLog(AbstractMatchDataTransfer.class);
    protected String number;
    protected DynamicObject rule;
    private List<DynamicObject> billList;
    protected BillEntityType srcMainType;
    protected ConvertContext context;
    protected Set<String> fields = new HashSet<String>(16);
    protected Map<Object, String> filterStringMap = new HashMap<Object, String>(16);

    protected AbstractMatchDataTransfer(String number, DynamicObject rule, List<DynamicObject> billList) {
        this.number = number;
        this.srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)number);
        this.rule = rule;
        this.billList = billList;
        ConvertContext context = new ConvertContext();
        context.setSourceMainType(this.srcMainType);
        this.context = context;
    }

    @Override
    public String getNumber() {
        return this.number;
    }

    @Override
    public Map<Object, String> getFilterStringMap() {
        return this.filterStringMap;
    }

    @Override
    public BillEntityType getBillEntityType() {
        return this.srcMainType;
    }

    @Override
    public List<MatchBean> buildMatchBean() {
        LOGGER.info("buildMatchBean begin");
        ArrayList<MatchBean> matchBeanList = new ArrayList<MatchBean>(10);
        if (this.rule == null) {
            return matchBeanList;
        }
        this.fields.add("company.id");
        this.fields.add("currency.id");
        this.fields.add("entrys.subacct.id");
        this.fields.add(this.srcMainType.getPrimaryKey().getName());
        DynamicObjectCollection entryEntity = this.rule.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            String filterStr = entry.containsProperty("e_datafilter_TAG") && StringUtils.isNotBlank((CharSequence)entry.getString("e_datafilter_TAG")) ? entry.getString("e_datafilter_TAG") : entry.getString("e_datafilter");
            if (!StringUtils.isNotBlank((CharSequence)filterStr)) continue;
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            String baseFilterStr = condition.buildFullFormula((MainEntityType)this.srcMainType);
            this.filterStringMap.put(entry.getPkValue(), baseFilterStr);
            this.addSourceFields(condition, this.fields);
        }
        this.billList = this.getBillList();
        MatchBean matchBean = new MatchBean();
        matchBean.setBillList(this.billList);
        if (this.rule.getDynamicObjectCollection("org_entry").isEmpty()) {
            matchBean.setCommonRule(this.rule);
        } else {
            matchBean.setMainOrgRule(this.rule);
        }
        matchBeanList.add(matchBean);
        return matchBeanList;
    }

    protected List<DynamicObject> getBillList() {
        if (this.billList == null || this.billList.isEmpty()) {
            return this.billList;
        }
        if (!"PlainObject".equals(this.billList.get(0).getDataEntityType().getName())) {
            ArrayList<DynamicObject> plainObjectList = new ArrayList<DynamicObject>(this.billList.size());
            ConditionFactory conditionFactory = new ConditionFactory();
            for (DynamicObject bill : this.billList) {
                conditionFactory.convertToPlainObject(bill, new ArrayList<String>(this.fields));
            }
            this.billList = plainObjectList;
            return plainObjectList;
        }
        return this.billList;
    }

    protected void setBillList(List<DynamicObject> billList) {
        this.billList = billList;
    }

    protected DynamicObject getCommonRule() {
        DynamicObject[] commonRule = this.getMatchingRule(null, true);
        return commonRule.length > 0 ? commonRule[0] : null;
    }

    protected DynamicObject[] getMatchingRule(Set<Object> companyIds, boolean commonRule) {
        QFilter ruleCommonFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C"));
        if (!commonRule) {
            ruleCommonFilter.and(new QFilter("org_entry.u_org", "in", companyIds));
        } else {
            ruleCommonFilter.and(QFilter.isNull((String)"org_entry.u_org"));
        }
        DynamicObjectCollection matchRule = QueryServiceHelper.query((String)"fca_downrule", (String)"id", (QFilter[])new QFilter[]{ruleCommonFilter});
        return BusinessDataServiceHelper.load((Object[])matchRule.stream().map(d -> d.getLong("id")).distinct().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fca_downrule"));
    }

    protected void addSourceFields(CRCondition condition, Set<String> selectFldStrings) {
        ConvertRuleElement rule = new ConvertRuleElement();
        rule.setRunCondition(condition);
        SingleRuleContext ruleContext = new SingleRuleContext();
        ruleContext.setContext(this.context);
        ruleContext.setRule(rule);
        ConvertRuleCompiler ruleCompiler = new ConvertRuleCompiler(ruleContext);
        ruleContext.setRuleCompiler(ruleCompiler);
        CRConditionCompiler runCondCompiler = ruleCompiler.compileRunCondition();
        IGetValueMode gridFilterExecutor = ruleCompiler.getRuleCondCompiler().getGridFilterExecuter();
        IGetValueMode expressExecutor = runCondCompiler.getExpressionExecuter();
        ArrayList vars = new ArrayList(gridFilterExecutor.getVars());
        vars.addAll(expressExecutor.getVars());
        for (IVariableMode var : vars) {
            if (!(var instanceof SourceFieldVariable)) continue;
            SourceFieldVariable srcField = (SourceFieldVariable)var;
            String selectFldString = srcField.getFullPropName();
            selectFldStrings.add(selectFldString);
        }
    }
}

