/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.service.match.transfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fca.business.service.match.bean.MatchBean;
import kd.tmc.fca.business.service.match.transfer.AbstractMatchDataTransfer;

public class DetailMatchDataTransfer
extends AbstractMatchDataTransfer {
    public DetailMatchDataTransfer(List<DynamicObject> bills) {
        super("fca_applytransdownbill", null, bills);
    }

    public DetailMatchDataTransfer(Object[] billIds) {
        super("fca_applytransdownbill", null, null);
        DynamicObjectCollection detailList = QueryServiceHelper.query((String)this.getNumber(), (String)"id, company.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)});
        this.setBillList((List<DynamicObject>)detailList);
    }

    @Override
    public List<MatchBean> buildMatchBean() {
        ArrayList<MatchBean> matchBeanList = new ArrayList<MatchBean>(10);
        DynamicObjectCollection bills = this.getBillList();
        if (bills.isEmpty()) {
            return matchBeanList;
        }
        this.fields.add("company.id");
        this.fields.add("currency.id");
        this.fields.add("entrys.subacct.id");
        this.fields.add(this.srcMainType.getPrimaryKey().getName());
        DynamicObject commonRule = this.getCommonRule();
        Set<Object> companyIds = bills.stream().map(b -> b.get("company.id")).collect(Collectors.toSet());
        Object[] billIds = bills.stream().map(b -> b.get("id")).toArray();
        DynamicObject[] matchingRules = this.getMatchingRule(companyIds, false);
        if (commonRule == null && matchingRules.length == 0) {
            MatchBean matchBean = new MatchBean();
            String selectString = StringUtils.join((Object[])this.fields.toArray(new Object[0]), (String)",");
            bills = QueryServiceHelper.query((String)this.number, (String)selectString, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)});
            matchBean.setBillList((List<DynamicObject>)bills);
            matchBeanList.add(matchBean);
            return matchBeanList;
        }
        ArrayList<DynamicObject> matchingRuleList = new ArrayList<DynamicObject>(matchingRules.length + 1);
        if (matchingRules.length != 0) {
            matchingRuleList.addAll(Arrays.asList(matchingRules));
        }
        if (commonRule != null) {
            matchingRuleList.add(commonRule);
        }
        for (DynamicObject matchingRule : matchingRuleList) {
            DynamicObjectCollection entryEntity = matchingRule.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryEntity) {
                String filterStr = dynamicObject.containsProperty("e_datafilter_TAG") && StringUtils.isNotBlank((CharSequence)dynamicObject.getString("e_datafilter_TAG")) ? dynamicObject.getString("e_datafilter_TAG") : dynamicObject.getString("e_datafilter");
                if (!StringUtils.isNotBlank((CharSequence)filterStr)) continue;
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
                String baseFilterStr = condition.buildFullFormula((MainEntityType)this.srcMainType);
                this.filterStringMap.put(dynamicObject.getPkValue(), baseFilterStr);
                super.addSourceFields(condition, this.fields);
            }
        }
        String selectString = StringUtils.join((Object[])this.fields.toArray(new Object[0]), (String)",");
        bills = QueryServiceHelper.query((String)this.number, (String)selectString, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)});
        Map<Object, List<DynamicObject>> billMap = bills.stream().collect(Collectors.groupingBy(b -> b.get("company.id")));
        ArrayList<Object> haveRuleCompanyId = new ArrayList<Object>(10);
        for (DynamicObject matchingRule : matchingRules) {
            ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(10);
            DynamicObjectCollection orgList = matchingRule.getDynamicObjectCollection("org_entry");
            for (DynamicObject org : orgList) {
                if (!billMap.containsKey(org.getDynamicObject("u_org").getPkValue())) continue;
                haveRuleCompanyId.add(org.getDynamicObject("u_org").getPkValue());
                billList.addAll((Collection<DynamicObject>)billMap.get(org.getDynamicObject("u_org").getPkValue()));
            }
            MatchBean matchBean = new MatchBean();
            matchBean.setBillList(billList);
            matchBean.setMainOrgRule(matchingRule);
            matchBeanList.add(matchBean);
        }
        for (Map.Entry entry : billMap.entrySet()) {
            if (haveRuleCompanyId.contains(entry.getKey())) continue;
            MatchBean matchBean = new MatchBean();
            matchBean.setCommonRule(commonRule);
            matchBean.setBillList((List)entry.getValue());
            matchBeanList.add(matchBean);
        }
        return matchBeanList;
    }
}

