/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.upgrade;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fca.common.helper.TransBillHelper;

public class TransEntryInnerAcctUpgradeService {
    public String upgrade() {
        RpcResult rpcResult = new RpcResult();
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                QFilter qFilter = new QFilter("inneracctbank.id", "=", (Object)0);
                ArrayList<String> stat = new ArrayList<String>(5);
                stat.add("A");
                stat.add("B");
                stat.add("C");
                stat.add("D");
                stat.add("P");
                qFilter.and("billstatus", "in", stat);
                DynamicObject[] transUpBills = BusinessDataServiceHelper.load((String)"fca_transupbill", (String)"currency, entrys.subacct,entrys.inneracctbank", (QFilter[])qFilter.toArray());
                List<DynamicObject> upgradeUpList = this.setInnerAcct(transUpBills);
                DynamicObject[] transDownBills = BusinessDataServiceHelper.load((String)"fca_transdownbill", (String)"currency, entrys.subacct,entrys.inneracctbank", (QFilter[])qFilter.toArray());
                List<DynamicObject> upgradeDownList = this.setInnerAcct(transDownBills);
                if (!upgradeUpList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])upgradeUpList.toArray(new DynamicObject[upgradeUpList.size()]));
                }
                if (!upgradeDownList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])upgradeDownList.toArray(new DynamicObject[upgradeDownList.size()]));
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                String exception = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                rpcResult.setStatusCode(RpcResultStatusCode.ERROR);
                rpcResult.setMessage(exception);
            }
        }
        return JSON.toJSONString((Object)rpcResult);
    }

    private List<DynamicObject> setInnerAcct(DynamicObject[] transBills) {
        List list;
        ArrayList<DynamicObject> upgradeList = new ArrayList<DynamicObject>(transBills.length);
        if (transBills.length > 0 && !(list = Arrays.stream(transBills).map(d -> d.getDynamicObjectCollection("entrys")).flatMap(e -> e.stream().filter(d -> d.getDynamicObject("inneracctbank") == null && d.getDynamicObject("subacct") != null)).collect(Collectors.toList())).isEmpty()) {
            Set bankAccountIds = list.stream().map(r -> r.getDynamicObject("subacct").getPkValue()).collect(Collectors.toSet());
            Map orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
            HashSet innerAccounts = new HashSet(16);
            for (Map map : orgInnerAccountMap.values()) {
                map.forEach((k, v) -> innerAccounts.add(v));
            }
            Map innerAcctMap = TransBillHelper.getBankAcctByInnerAcct(innerAccounts);
            for (DynamicObject transBill : transBills) {
                DynamicObject company = transBill.getDynamicObject("company");
                DynamicObject currency = transBill.getDynamicObject("currency");
                if (company == null || currency == null) continue;
                DynamicObjectCollection details = transBill.getDynamicObjectCollection("entrys");
                if (orgInnerAccountMap.containsKey(company.getPkValue())) {
                    for (DynamicObject detail : details) {
                        DynamicObjectCollection currencies;
                        List currencyIdList;
                        DynamicObject subAccount = detail.getDynamicObject("subacct");
                        if (subAccount == null) continue;
                        DynamicObject innerAccount = (DynamicObject)((Map)orgInnerAccountMap.get(company.getPkValue())).get(subAccount.getPkValue());
                        if (innerAccount != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                            innerAccount = null;
                        }
                        if (innerAccount == null) continue;
                        detail.set("inneracctbank", innerAcctMap.get(innerAccount.getPkValue()));
                    }
                }
                upgradeList.add(transBill);
            }
        }
        return upgradeList;
    }
}

