/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.applytransbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fca.common.resource.FcaBizResource;

public class ApplyTransBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("transamt");
        selector.add("billstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        FcaBizResource fcaBizResource = new FcaBizResource();
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject applyTransBill = data.getDataEntity();
            DynamicObjectCollection entrys = applyTransBill.getDynamicObjectCollection("entrys");
            String billStatus = applyTransBill.getString("billstatus");
            ArrayList<String> errorIndexs = new ArrayList<String>();
            if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
                int len = entrys.size();
                for (int i = 0; i < len; ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    BigDecimal transAmt = entry.getBigDecimal("transamt");
                    if (null != transAmt && transAmt.compareTo(Constants.ZERO) != 0) continue;
                    errorIndexs.add(String.valueOf(i + 1));
                }
            }
            if (errorIndexs.size() <= 0) continue;
            String errorMsg = String.format(fcaBizResource.getTipTransamtlot(), StringUtils.join((Object[])errorIndexs.toArray(new String[errorIndexs.size()]), (String)","));
            this.addErrorMessage(data, errorMsg);
        }
    }
}

