/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.applytransbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fca.common.helper.TransBillHelper;
import kd.tmc.fca.common.resource.FcaBizResource;

public class ApplyTransBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applyamt");
        selector.add("currency");
        selector.add("transamt");
        selector.add("subacct");
        selector.add("pbankacct");
        selector.add("inneracct");
        selector.add("amount");
        selector.add("parentorg");
        selector.add("billstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        FcaBizResource fcaBizResource = new FcaBizResource();
        List list = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).map(d -> d.getDynamicObjectCollection("entrys")).flatMap(e -> e.stream().filter(d -> d.getDynamicObject("subacct") != null)).collect(Collectors.toList());
        Map orgInnerAccountMap = null;
        if (!list.isEmpty()) {
            Set bankAccountIds = list.stream().map(r -> r.getDynamicObject("subacct").getPkValue()).collect(Collectors.toSet());
            orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
        }
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject applyTransBill = data.getDataEntity();
            String billStatus = applyTransBill.getString("billstatus");
            if (!billStatus.equals(BillStatusEnum.SAVE.getValue())) {
                this.addErrorMessage(data, fcaBizResource.getErrorSubstatus());
                continue;
            }
            DynamicObject parentOrg = applyTransBill.getDynamicObject("parentorg");
            if (parentOrg == null) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyTransBillSubmitValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject currency = applyTransBill.getDynamicObject("currency");
            if (currency == null) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyTransBillSubmitValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection applyTransBillDetl = applyTransBill.getDynamicObjectCollection("entrys");
            BigDecimal applySumAmt = applyTransBill.getBigDecimal("amount");
            if (applySumAmt.compareTo(Constants.ZERO) <= 0) {
                this.addErrorMessage(data, fcaBizResource.getTipApplysumamtNull());
            }
            int innerAccountCount = 0;
            for (DynamicObject detail : applyTransBillDetl) {
                DynamicObjectCollection currencies;
                List currencyIdList;
                DynamicObject innerAccount;
                if (orgInnerAccountMap != null && orgInnerAccountMap.containsKey(parentOrg.getPkValue()) && detail.getDynamicObject("subacct") != null && (innerAccount = (DynamicObject)((Map)orgInnerAccountMap.get(parentOrg.getPkValue())).get(detail.getDynamicObject("subacct").getPkValue())) != null && (currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                    ++innerAccountCount;
                }
                DynamicObject pAccount = detail.getDynamicObject("pbankacct");
                DynamicObject subAccount = detail.getDynamicObject("subacct");
                this.validateAccountStatus(data, pAccount, subAccount);
            }
            if (innerAccountCount == 0 || innerAccountCount == applyTransBillDetl.size()) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5212\u62e8\u5355\u5185\u94f6\u884c\u8d26\u6237\u5fc5\u987b\u5168\u90e8\u4e0e\u5185\u90e8\u8d26\u6237\u6709\u5173\u6216\u8005\u5168\u90e8\u65e0\u5173\u3002", (String)"AbsTransBillValidator_18", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
    }

    public void validateAccountStatus(ExtendedDataEntity data, DynamicObject pAccount, DynamicObject subAccount) {
        String entityName = data.getDataEntity().getDataEntityType().getName();
        if (pAccount != null) {
            String pAccountStatus = pAccount.getString("acctstatus");
            if (StringUtils.equals((CharSequence)pAccountStatus, (CharSequence)BankAcctStatusEnum.CLOSED.getValue())) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_23", (String)"tmc-fca-business", (Object[])new Object[0]), pAccount.getString("bankaccountnumber")));
            }
            if (StringUtils.equals((CharSequence)pAccountStatus, (CharSequence)BankAcctStatusEnum.FREEZE.getValue()) && StringUtils.equals((CharSequence)"fca_applytransdownbill", (CharSequence)entityName)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_24", (String)"tmc-fca-business", (Object[])new Object[0]), pAccount.getString("bankaccountnumber")));
            }
        }
        if (subAccount != null) {
            String subAccountStatus = subAccount.getString("acctstatus");
            if (StringUtils.equals((CharSequence)subAccountStatus, (CharSequence)BankAcctStatusEnum.CLOSED.getValue())) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_25", (String)"tmc-fca-business", (Object[])new Object[0]), subAccount.getString("bankaccountnumber")));
            }
            if (StringUtils.equals((CharSequence)subAccountStatus, (CharSequence)BankAcctStatusEnum.FREEZE.getValue()) && StringUtils.equals((CharSequence)"fca_applytransupbill", (CharSequence)entityName)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_26", (String)"tmc-fca-business", (Object[])new Object[0]), subAccount.getString("bankaccountnumber")));
            }
        }
    }
}

