/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.setting;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class DownRuleSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selectorList = super.getSelector();
        selectorList.add("org_entry.u_org");
        selectorList.add("entryentity");
        return selectorList;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entryentity");
            if (entry.isEmpty()) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u62e8\u89c4\u5219\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DownRuleSaveValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            QFilter filter = new QFilter("enable", "=", (Object)"1").and(new QFilter("id", "!=", bill.getPkValue()));
            DynamicObjectCollection useOrg = bill.getDynamicObjectCollection("org_entry");
            if (useOrg.isEmpty()) {
                filter.and(QFilter.isNull((String)"org_entry.u_org"));
                boolean isExists = QueryServiceHelper.exists((String)"fca_downrule", (QFilter[])filter.toArray());
                if (!isExists) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u3010\u9002\u7528\u5168\u7ec4\u7ec7\u3011\u7684\u4e0b\u62e8\u89c4\u5219\u3002", (String)"DownRuleSaveValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            Object[] orgIds = useOrg.stream().map(d -> d.getDynamicObject("u_org").getPkValue()).toArray();
            filter.and("org_entry.u_org", "in", (Object)orgIds);
            DynamicObjectCollection orgList = QueryServiceHelper.query((String)"fca_downrule", (String)"number, org_entry.u_org.name", (QFilter[])filter.toArray());
            for (DynamicObject org : orgList) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u3010%1$s\u3011\u5df2\u5b58\u5728\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684\u4e0b\u62e8\u89c4\u5219\u3002", (String)"DownRuleSaveValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]), org.getString("org_entry.u_org.name"), org.getString("number")));
            }
        }
    }
}

