/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayChanEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.enums.FcaTransSourceTypeEnum;
import kd.tmc.fca.common.helper.TransBillHelper;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbsTransBillValidator
extends AbstractTmcBizOppValidator {
    private static final Log LOGGER = LogFactory.getLog(AbsTransBillValidator.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("currency");
        selector.add("amount");
        selector.add("accountbank");
        selector.add("subacct");
        selector.add("transamt");
        selector.add("discard_reason");
        selector.add("discard_user");
        selector.add("discard_time");
        selector.add("discard_time_str");
        selector.add("paystatus");
        selector.add("payuser");
        selector.add("discard_user");
        selector.add("state");
        selector.add("payreturninfo");
        selector.add("paychanel");
        selector.add("acctgrpid");
        selector.add("inneracct");
        selector.add("inneracctbank");
        selector.add("subacct_company");
        selector.add("usage");
        selector.add("payflag");
        selector.add("sourcetype");
        selector.add("company");
        selector.add("country");
        selector.add("province");
        selector.add("city");
        selector.add("entrycountry");
        selector.add("entryprovince");
        selector.add("entrycity");
        return selector;
    }

    protected Map<ExtendedDataEntity, Pair<Boolean, String>> validateEntryRule(ExtendedDataEntity[] dataEntity) {
        HashMap<ExtendedDataEntity, Pair<Boolean, String>> validateMap = new HashMap<ExtendedDataEntity, Pair<Boolean, String>>(10);
        DynamicObject[] bankAccts = BusinessDataServiceHelper.load((Object[])Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).filter(v -> !EmptyUtil.isEmpty((DynamicObject)v.getDynamicObject("accountbank"))).map(p -> p.getDynamicObject("accountbank").getPkValue()).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
        Map bankAcctMap = Arrays.stream(bankAccts).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (o1, o2) -> o1, HashMap::new));
        Set subAcctIds = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(v -> v.getDynamicObjectCollection("entrys")).flatMap(s -> s.stream().filter(v -> v.getDynamicObject("subacct") != null).map(o -> o.getDynamicObject("subacct").getPkValue())).collect(Collectors.toSet());
        Set bankAccountIds = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(v -> v.getDynamicObjectCollection("entrys")).flatMap(s -> s.stream().filter(v -> v.getDynamicObject("inneracctbank") == null && v.getDynamicObject("subacct") != null).map(o -> o.getDynamicObject("subacct").getPkValue())).collect(Collectors.toSet());
        DynamicObject[] subAccts = BusinessDataServiceHelper.load((Object[])subAcctIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
        Map subAcctMap = Arrays.stream(subAccts).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (o1, o2) -> o1, HashMap::new));
        Map orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject transBill = entity.getDataEntity();
            String sourceType = transBill.getString("sourcetype");
            if (FcaTransSourceTypeEnum.RECINITIATIVE.getValue().equals(sourceType) || FcaTransSourceTypeEnum.PAYPASSIVE.getValue().equals(sourceType)) continue;
            DynamicObject company = transBill.getDynamicObject("company");
            DynamicObject currency = transBill.getDynamicObject("currency");
            String billStatus = transBill.getString("billstatus");
            int innerAccountCount = 0;
            DynamicObjectCollection entries = transBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                DynamicObject subAccount = entry.getDynamicObject("subacct");
                DynamicObject innerAccountBank = entry.getDynamicObject("inneracctbank");
                if (innerAccountBank == null) {
                    DynamicObjectCollection currencies;
                    List currencyIdList;
                    DynamicObject innerAccount;
                    if (!BillStatusEnum.SAVE.getValue().equals(billStatus) || subAccount == null || company == null || currency == null || !orgInnerAccountMap.containsKey(company.getPkValue()) || (innerAccount = (DynamicObject)((Map)orgInnerAccountMap.get(company.getPkValue())).get(subAccount.getPkValue())) == null || !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) continue;
                    ++innerAccountCount;
                    continue;
                }
                ++innerAccountCount;
            }
            if (innerAccountCount != 0 && innerAccountCount != entries.size()) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5212\u62e8\u5355\u5185\u94f6\u884c\u8d26\u6237\u5fc5\u987b\u5168\u90e8\u4e0e\u5185\u90e8\u8d26\u6237\u6709\u5173\u6216\u8005\u5168\u90e8\u65e0\u5173\u3002", (String)"AbsTransBillValidator_18", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
            Pair<Boolean, String> validEntryRuleResult = this.validEntryRule(entity, bankAcctMap, subAcctMap);
            validateMap.put(entity, validEntryRuleResult);
        }
        return validateMap;
    }

    protected Pair<Boolean, String> validEntryRule(ExtendedDataEntity entity, Map<Object, DynamicObject> bankAcctMap, Map<Object, DynamicObject> subAcctMap) {
        DynamicObject transBill = entity.getDataEntity();
        DynamicObject acct = EmptyUtil.isEmpty((DynamicObject)transBill.getDynamicObject("accountbank")) ? null : bankAcctMap.get(transBill.getDynamicObject("accountbank").getPkValue());
        Object currency = transBill.get("currency");
        Object company = transBill.get("company");
        if (company == null) {
            return Pair.of((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6bcd\u8d26\u6237\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"AbsTransBillValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
        if (acct == null) {
            return Pair.of((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u6bcd\u8d26\u53f7\u94f6\u884c\u8d26\u53f7\u672a\u9009\u62e9\uff0c\u8bf7\u9009\u62e9\u3002", (String)"AbsTransBillValidator_3", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
        if (currency == null) {
            return Pair.of((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u5e01\u79cd\u672a\u9009\u62e9\uff0c\u8bf7\u9009\u62e9\u3002", (String)"AbsTransBillValidator_4", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
        boolean motherIsOpenBei = acct.getBoolean("issetbankinterface");
        DynamicObjectCollection entries = transBill.getDynamicObjectCollection("entrys");
        ArrayList<DynamicObject> deleteEntryList = new ArrayList<DynamicObject>(10);
        HashMap<String, Integer> acctCountMap = new HashMap<String, Integer>(16);
        if (entries == null || entries.isEmpty()) {
            return Pair.of((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5212\u62e8\u660e\u7ec6\u4fe1\u606f\u3002", (String)"AbsTransBillValidator_5", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
        String onePaychanel = "";
        StringBuilder payChanelMsg = new StringBuilder();
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            String state = entry.getString("state");
            String payStatus = entry.getString("paystatus");
            String paychanel = entry.getString("paychanel");
            DynamicObject subAcct = EmptyUtil.isEmpty((DynamicObject)entry.getDynamicObject("subacct")) ? null : subAcctMap.get(entry.getDynamicObject("subacct").getPkValue());
            BigDecimal transamt = entry.getBigDecimal("transamt");
            if (null == subAcct) {
                return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5b50\u8d26\u6237\u94f6\u884c\u8d26\u6237\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u3002", (String)"AbsTransBillValidator_6", (String)"tmc-fca-business", (Object[])new Object[0]), i + 1));
            }
            boolean subIsOpenBei = subAcct.getBoolean("issetbankinterface");
            BigDecimal transAmt = entry.getBigDecimal("transamt");
            String acctNum = subAcct.getString("bankaccountnumber");
            if (transAmt == null || BigDecimal.ZERO.compareTo(transAmt) == 0) {
                deleteEntryList.add(entry);
            } else {
                Integer count = (Integer)acctCountMap.get(acctNum);
                if (count != null) {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                } else {
                    count = 1;
                }
                acctCountMap.put(acctNum, count);
            }
            if (FcaTransDetailStatusEnum.DISCARD.getValue().equals(state) || !FcaTransPayStatusEnum.INIT.getValue().equals(payStatus)) continue;
            if (EmptyUtil.isEmpty((String)onePaychanel)) {
                onePaychanel = paychanel;
            } else if (!onePaychanel.trim().equals(paychanel.trim())) {
                payChanelMsg.append(i + 1).append(',');
            }
            if (EmptyUtil.isEmpty((String)paychanel)) {
                return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u652f\u4ed8\u6e20\u9053\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u3002", (String)"AbsTransBillValidator_8", (String)"tmc-fca-business", (Object[])new Object[0]), i + 1));
            }
            if (transamt.compareTo(BigDecimal.ZERO) == 0) {
                return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5212\u62e8\u91d1\u989d\u4e0d\u5141\u8bb8\u4e3a\u96f6\uff0c\u8bf7\u8f93\u5165\u3002", (String)"AbsTransBillValidator_9", (String)"tmc-fca-business", (Object[])new Object[0]), i + 1));
            }
            if (transamt.compareTo(BigDecimal.ZERO) < 0) {
                return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5212\u62e8\u91d1\u989d\u5c0f\u4e8e\u96f6\uff0c\u8bf7\u8f93\u5165\u3002", (String)"AbsTransBillValidator_10", (String)"tmc-fca-business", (Object[])new Object[0]), i + 1));
            }
            if (!FcaTransPayChanEnum.BEI.getValue().equals(paychanel)) continue;
            if (!motherIsOpenBei && "fca_transdownbill".equals(transBill.getDataEntityType().getName())) {
                return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e3a[%s]\uff0c\u4f46\u662f\u6bcd\u8d26\u6237\u94f6\u884c\u8d26\u53f7\u672a\u5f00\u901a\u94f6\u4f01\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_12", (String)"tmc-fca-business", (Object[])new Object[0]), FcaTransPayChanEnum.BEI.getName()));
            }
            if (subIsOpenBei || !"fca_transupbill".equals(transBill.getDataEntityType().getName())) continue;
            return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e3a[%1$s]\uff0c\u4f46\u662f\u5b50\u8d26\u6237\u94f6\u884c\u8d26\u53f7\u672a\u5f00\u901a\u94f6\u4f01\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_15", (String)"tmc-fca-business", (Object[])new Object[0]), FcaTransPayChanEnum.BEI.getName()));
        }
        if (payChanelMsg.length() > 0) {
            return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u652f\u4ed8\u6e20\u9053\u4e0e\u7b2c\u4e00\u884c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AbsTransBillValidator_13", (String)"tmc-fca-business", (Object[])new Object[0]), payChanelMsg.substring(0, payChanelMsg.length() - 1)));
        }
        if (!deleteEntryList.isEmpty()) {
            entries.removeAll(deleteEntryList);
        }
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    public boolean validPayChanel(ExtendedDataEntity entity, String opKey) {
        DynamicObject transBill = entity.getDataEntity();
        DynamicObjectCollection entries = transBill.getDynamicObjectCollection("entrys");
        if ("commitbei".equals(opKey) || "autocommitbei".equals(opKey)) {
            opKey = "barpaybei";
        }
        for (DynamicObject entry : entries) {
            String paychanel = entry.getString("paychanel");
            String payStatus = entry.getString("paystatus");
            String state = entry.getString("state");
            if (FcaTransDetailStatusEnum.DISCARD.getValue().equals(state) || FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus)) continue;
            if ("barpaybei".equals(opKey) && FcaTransPayChanEnum.BEI.getValue().equals(paychanel)) {
                return true;
            }
            if (!"barpayconfirm".equals(opKey) || !FcaTransPayChanEnum.ONLINE.getValue().equals(paychanel) && !FcaTransPayChanEnum.COUNTER.getValue().equals(paychanel)) continue;
            return true;
        }
        if ("barpaybei".equals(opKey)) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u652f\u4ed8\u6e20\u9053\u4e3a[%s]\u5e76\u4e14\u9700\u8981\u4ed8\u6b3e\u7684\u660e\u7ec6\u3002", (String)"AbsTransBillValidator_16", (String)"tmc-fca-business", (Object[])new Object[0]), FcaTransPayChanEnum.BEI.getName()));
        } else {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u652f\u4ed8\u6e20\u9053\u4e3a[%1$s]\u6216[%2$s]\u5e76\u4e14\u9700\u8981\u4ed8\u6b3e\u7684\u660e\u7ec6\u3002", (String)"AbsTransBillValidator_17", (String)"tmc-fca-business", (Object[])new Object[0]), FcaTransPayChanEnum.ONLINE.getName(), FcaTransPayChanEnum.COUNTER.getName()));
        }
        return false;
    }

    protected void discardEntry(List<DynamicObject> rows, String reason, String returnInfo, DynamicObject opUser) {
        for (DynamicObject rowInfo : rows) {
            Date currTime = new Date();
            rowInfo.set("discard_reason", (Object)reason);
            rowInfo.set("discard_user", (Object)opUser);
            rowInfo.set("discard_time", (Object)currTime);
            rowInfo.set("discard_time_str", (Object)DateUtils.formatString((Date)currTime, (String)"yyyyMMdd"));
            rowInfo.set("state", (Object)FcaTransDetailStatusEnum.DISCARD.getValue());
            rowInfo.set("payreturninfo", (Object)returnInfo);
        }
    }

    public Set<Long> getAllOrgIds(ExtendedDataEntity[] dataEntity) {
        HashSet<Long> accountIdSet = new HashSet<Long>(8);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject transBill = extendedDataEntity.getDataEntity();
            accountIdSet.add(transBill.getDynamicObject("company").getLong("id"));
            DynamicObjectCollection dynamicObjectCol = transBill.getDynamicObjectCollection("entrys");
            for (DynamicObject dynamicObject : dynamicObjectCol) {
                if (!EmptyUtil.isNoEmpty((DynamicObject)dynamicObject) || !EmptyUtil.isNoEmpty((DynamicObject)dynamicObject.getDynamicObject("subacct_company"))) continue;
                accountIdSet.add(dynamicObject.getDynamicObject("subacct_company").getLong("id"));
            }
        }
        return accountIdSet;
    }

    public Set<Long> getAllOrgIsInnit(Set<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashSet<Long>();
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"org ", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("isfinishinit", "=", (Object)"1")});
        if (coll == null || coll.isEmpty()) {
            return new HashSet<Long>();
        }
        return coll.stream().map(e -> e.getLong("org")).collect(Collectors.toSet());
    }

    public Map<Long, Boolean> loadBatchAppParameterByOrg(Set<Long> orgIds) {
        HashMap<Long, Boolean> stringBooleanMap = new HashMap<Long, Boolean>(8);
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashMap<Long, Boolean>(8);
        }
        AppParam param = new AppParam();
        param.setViewType("08");
        param.setAppId("d2bb1733000000ac");
        Map map = SystemParamServiceHelper.loadBatchAppParameterByOrg((AppParam)param, new ArrayList<Long>(orgIds));
        for (Long org : orgIds) {
            Map stringObjectMap = (Map)map.get(String.valueOf(org));
            if (Objects.isNull(stringObjectMap)) continue;
            Object cs105 = stringObjectMap.get("cs105");
            stringBooleanMap.put(org, "0".equals(cs105));
        }
        return stringBooleanMap;
    }
}

