/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fca.business.validate.transbill.AbsTransBillValidator;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.helper.TransBillHelper;
import kd.tmc.fca.common.helper.TransBillPushHelper;

public class ManualBookBillValidator
extends AbsTransBillValidator {
    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.addAll(TransBillPushHelper.buildSelectors());
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            if (!BillStatusEnum.PAYED.getValue().equals(bill.getString("billstatus"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5212\u62e8\u5355\u975e\u5df2\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"TransBillPayPushCasValidator_10", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entrys");
            if (TransBillHelper.isInnerAcctTrans((DynamicObject)bill)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u4e0d\u9700\u8981\u767b\u8d26\uff0c\u5728\u5185\u90e8\u91d1\u878d\u767b\u8d26\u3002", (String)"ManualBookBillValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            List sourceIdList = entries.stream().filter(e -> FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(e.getString("paystatus"))).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            if (sourceIdList.isEmpty()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u4ea4\u6613\u6210\u529f\u7684\u660e\u7ec6\u3002", (String)"ManualBookBillValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            QFilter filter = new QFilter("sourcebilltype", "=", (Object)bill.getDataEntityType().getName());
            filter.and("sourcebillentryid", "in", sourceIdList);
            HashSet existSourceIdSet = new HashSet();
            DynamicObjectCollection bankJourData = QueryServiceHelper.query((String)"cas_bankjournal", (String)"sourcebillentryid", (QFilter[])filter.toArray(), (String)"");
            existSourceIdSet.addAll(bankJourData.stream().map(d -> d.get("sourcebillentryid")).collect(Collectors.toSet()));
            if (sourceIdList.size() != existSourceIdSet.size()) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5212\u62e8\u5355\u5df2\u7ecf\u767b\u8bb0\u65e5\u8bb0\u8d26\u3002", (String)"ManualBookBillValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
    }
}

