/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fca.common.errorcode.TransErrorCode;

public class TransBillBeiCommitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("amount");
        selector.add("accountbank");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        TransErrorCode transErrorCode = new TransErrorCode();
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject info = entity.getDataEntity();
            String billStatus = info.getString("billstatus");
            if (!billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
                throw new KDBizException(transErrorCode.COMMITBE_STATUS(), new Object[0]);
            }
            if (info.getBigDecimal("amount").compareTo(BigDecimal.ZERO) >= 0) continue;
            throw new KDBizException(transErrorCode.AMT_MORETHANZERO(), new Object[0]);
        }
    }
}

