/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.enums.FcaTransSourceTypeEnum;

public class TransBillCancellationValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("ischangepaych");
        selector.add("sourcetype");
        selector.add("matchflag");
        selector.add("ismatchbyhead");
        selector.add("entrys.paystatus");
        selector.add("entrys.state");
        selector.add("entrys.entrymatchflag");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            String matchFlag = data.getString("matchflag");
            if (!"0".equalsIgnoreCase(matchFlag)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5339\u914d\u6807\u8bc6\u4e3a\u672a\u5339\u914d\u624d\u80fd\u4f5c\u5e9f\u3002", (String)"TransBillCancellationValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            if (!BillStatusEnum.SAVE.getValue().equals(data.getString("billstatus"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6682\u5b58\u7684\u5355\u636e\u624d\u80fd\u4f5c\u5e9f\u3002", (String)"TransBillCancellationValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            if (!FcaTransSourceTypeEnum.MANUAL.getValue().equals(data.getString("sourcetype"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u624b\u5de5\u521b\u5efa\u7684\u5355\u636e\u624d\u80fd\u4f5c\u5e9f\u3002", (String)"TransBillCancellationValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            if (data.getBoolean("ischangepaych")) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6b63\u5728\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u4f5c\u5e9f\u3002", (String)"TransBillCancellationValidator_3", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
            Optional<DynamicObject> isAllHas = entries.stream().filter(e -> !(!FcaTransDetailStatusEnum.NORMAL.getValue().equals(e.getString("state")) && !FcaTransDetailStatusEnum.BACK.getValue().equals(e.getString("state")) || !FcaTransPayStatusEnum.PAYFAIL.getValue().equals(e.getString("paystatus")) && !FcaTransPayStatusEnum.INIT.getValue().equals(e.getString("paystatus")))).findFirst();
            if (isAllHas.isPresent()) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u6ee1\u8db3\u4f5c\u5e9f\u652f\u4ed8\u660e\u7ec6\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u4f5c\u5e9f\u3002", (String)"TransBillCancellationValidator_4", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
    }
}

